/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.oncrpc;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import org.filesys.oncrpc.MultiThreadedTcpRpcPacketHandler;
import org.filesys.oncrpc.RpcPacket;
import org.filesys.oncrpc.RpcPacketPool;
import org.filesys.oncrpc.RpcProcessor;
import org.filesys.oncrpc.RpcRequestThreadPool;
import org.filesys.oncrpc.TcpRpcPacketHandler;
import org.filesys.oncrpc.TcpRpcSessionHandler;
import org.filesys.server.NetworkServer;

public class MultiThreadedTcpRpcSessionHandler
extends TcpRpcSessionHandler {
    public static final int DefaultPacketPoolSize = 50;
    public static final int DefaultSmallPacketSize = 512;
    private RpcPacketPool m_packetPool;
    private RpcRequestThreadPool m_threadPool;

    public MultiThreadedTcpRpcSessionHandler(String name, String protocol, RpcProcessor rpcServer, NetworkServer server, InetAddress addr, int port, int maxSize) {
        super(name, protocol, rpcServer, server, addr, port, maxSize);
    }

    @Override
    public void initializeSessionHandler(NetworkServer server) throws IOException {
        if (this.m_packetPool == null) {
            this.m_packetPool = new RpcPacketPool(512, 50, this.getMaximumRpcSize(), 50);
        }
        if (this.m_threadPool == null) {
            this.m_threadPool = new RpcRequestThreadPool(this.getHandlerName(), this.getRpcProcessor());
        }
        super.initializeSessionHandler(server);
    }

    protected final RpcPacket allocateRpcPacket(int size) {
        return this.m_packetPool.allocatePacket(size);
    }

    protected final void queueRpcRequest(RpcPacket rpc) {
        this.m_threadPool.queueRpcRequest(rpc);
    }

    @Override
    protected TcpRpcPacketHandler createPacketHandler(int sessId, Socket sock) throws IOException {
        return new MultiThreadedTcpRpcPacketHandler(this, sessId, this.getRpcProcessor(), sock, this.getMaximumRpcSize());
    }

    public final void setPacketPool(int smallSize, int smallPool, int largeSize, int largePool) {
        if (this.m_packetPool == null) {
            this.m_packetPool = new RpcPacketPool(smallSize, smallPool, largeSize, largePool);
        }
    }

    public final void setPacketPool(int poolSize) {
        if (this.m_packetPool == null) {
            this.m_packetPool = new RpcPacketPool(512, poolSize, this.getMaximumRpcSize(), poolSize);
        }
    }

    public final void setPacketPool(RpcPacketPool pktPool) {
        if (this.m_packetPool == null) {
            this.m_packetPool = pktPool;
        }
    }

    public final void setThreadPool(int numThreads) {
        if (this.m_threadPool == null) {
            this.m_threadPool = new RpcRequestThreadPool(this.getHandlerName(), numThreads, this.getRpcProcessor());
        }
    }

    public final void setThreadPool(RpcRequestThreadPool threadPool) {
        if (this.m_threadPool == null) {
            this.m_threadPool = threadPool;
        }
    }
}

