/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.oncrpc;

import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketException;
import org.filesys.oncrpc.RpcPacket;

public abstract class RpcClient {
    private InetAddress m_server;
    private int m_port;
    private int m_protocol;
    private int m_maxRpcSize;

    protected RpcClient(InetAddress addr, int port, int proto, int maxRpcSize) throws IOException, SocketException {
        this.m_server = addr;
        this.m_port = port;
        this.m_protocol = proto;
        this.m_maxRpcSize = maxRpcSize;
    }

    public final int getMaximumRpcSize() {
        return this.m_maxRpcSize;
    }

    public final InetAddress getServerAddress() {
        return this.m_server;
    }

    public final int getServerPort() {
        return this.m_port;
    }

    public final int isProtocol() {
        return this.m_protocol;
    }

    public abstract RpcPacket sendRPC(RpcPacket var1, RpcPacket var2) throws IOException;

    public abstract void closeConnection();

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("[");
        str.append(this.isProtocol() == 6 ? "TCP:" : "UDP:");
        str.append(this.getServerAddress().getHostAddress());
        str.append(":");
        str.append(this.getServerPort());
        str.append(",");
        str.append(this.getMaximumRpcSize());
        str.append("]");
        return str.toString();
    }
}

