/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.oncrpc;

import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import org.filesys.oncrpc.PortMapping;
import org.filesys.oncrpc.RpcPacketHandler;
import org.filesys.oncrpc.RpcPacketPool;
import org.filesys.util.DataPacker;
import org.filesys.util.UTF8Normalizer;

public class RpcPacket {
    private static final int DefaultBufferSize = 8192;
    public static final int FragHeaderLen = 4;
    public static final int ResponseMismatchLen = 24;
    public static final int ResponseAuthFailLen = 20;
    private static UTF8Normalizer _utf8Normalizer = new UTF8Normalizer();
    private byte[] m_buffer;
    private int m_offset;
    private int m_pos;
    private int m_endPos;
    private InetAddress m_clientAddr;
    private int m_clientPort;
    private int m_protocol;
    private RpcPacketHandler m_pktHandler;
    private RpcPacketPool m_ownerPool;

    public RpcPacket() {
        this.m_buffer = new byte[8192];
        this.m_offset = 4;
        this.m_pos = 4;
        this.m_endPos = this.m_buffer.length;
    }

    public RpcPacket(int len) {
        this.m_buffer = new byte[len + 4];
        this.m_offset = 4;
        this.m_pos = 4;
        this.m_endPos = this.m_buffer.length;
    }

    protected RpcPacket(int len, RpcPacketPool owner) {
        this(len);
        this.setOwnerPacketPool(owner);
    }

    public RpcPacket(byte[] buf) {
        this.m_buffer = buf;
        this.m_offset = 4;
        this.m_pos = 4;
        this.m_endPos = buf.length;
    }

    public RpcPacket(byte[] buf, int offset, int len) {
        this.m_buffer = buf;
        this.m_offset = offset;
        this.m_pos = offset;
        this.m_endPos = offset + len;
    }

    public final boolean hasPacketHandler() {
        return this.m_pktHandler != null;
    }

    public final RpcPacketHandler getPacketHandler() {
        return this.m_pktHandler;
    }

    public final boolean isAllocatedFromPool() {
        return this.m_ownerPool != null;
    }

    public final RpcPacketPool getOwnerPacketPool() {
        return this.m_ownerPool;
    }

    public final boolean hasClientAddress() {
        return this.m_clientAddr != null;
    }

    public final InetAddress getClientAddress() {
        return this.m_clientAddr;
    }

    public final int getClientPort() {
        return this.m_clientPort;
    }

    public final int getClientProtocol() {
        return this.m_protocol;
    }

    public final String getClientDetails() {
        if (!this.hasClientAddress()) {
            return "<Unknown>";
        }
        StringBuffer str = new StringBuffer(32);
        str.append(this.getClientProtocol() == 6 ? "T" : "U");
        str.append(this.getClientAddress().getHostAddress());
        str.append(":");
        str.append(this.getClientPort());
        return str.toString();
    }

    public final int getPosition() {
        return this.m_pos;
    }

    public final byte[] getBuffer() {
        return this.m_buffer;
    }

    public final int getAvailableLength() {
        return this.m_buffer.length - this.m_pos;
    }

    public final int getLength() {
        return this.m_endPos - this.m_offset;
    }

    public final int getTxLength() {
        if (this.m_offset == 0) {
            return this.m_endPos;
        }
        return this.m_endPos - this.m_offset + 4;
    }

    public final int getOffset() {
        return this.m_offset;
    }

    public final int getMessageType() {
        return DataPacker.getInt(this.m_buffer, this.m_offset + 4);
    }

    public final int getRpcVersion() {
        return DataPacker.getInt(this.m_buffer, this.m_offset + 8);
    }

    public final int getProgramId() {
        return DataPacker.getInt(this.m_buffer, this.m_offset + 12);
    }

    public final int getProgramVersion() {
        return DataPacker.getInt(this.m_buffer, this.m_offset + 16);
    }

    public final int getProcedureId() {
        return DataPacker.getInt(this.m_buffer, this.m_offset + 20);
    }

    public final int getCredentialsType() {
        return DataPacker.getInt(this.m_buffer, this.m_offset + 24);
    }

    public final int getCredentialsLength() {
        return DataPacker.getInt(this.m_buffer, this.m_offset + 28);
    }

    public final int getVerifierType() {
        return DataPacker.getInt(this.m_buffer, this.m_offset + this.getCredentialsLength() + 32);
    }

    public final int getVerifierLength() {
        return DataPacker.getInt(this.m_buffer, this.m_offset + this.getCredentialsLength() + 36);
    }

    public final int getVerifierOffset() {
        return this.m_offset + this.getCredentialsLength() + 40;
    }

    public final int getProcedureParameterOffset() {
        return this.m_offset + this.getCredentialsLength() + this.getVerifierLength() + 40;
    }

    public final int getProcedureParameterLength() {
        return this.m_endPos - this.getProcedureParameterOffset();
    }

    public final int getXID() {
        return DataPacker.getInt(this.m_buffer, this.m_offset);
    }

    public final boolean hasSuccessStatus() {
        return this.getAcceptStatus() == 0;
    }

    public final int getReplyState() {
        return DataPacker.getInt(this.m_buffer, 8);
    }

    public final int getRejectStatus() {
        return DataPacker.getInt(this.m_buffer, 12);
    }

    public final int getMismatchVersionLow() {
        return DataPacker.getInt(this.m_buffer, 16);
    }

    public final int getMismatchVersionHigh() {
        return DataPacker.getInt(this.m_buffer, 20);
    }

    public final int getAuthFailStatus() {
        return DataPacker.getInt(this.m_buffer, 16);
    }

    public final int getAcceptStatus() {
        int pos = DataPacker.getInt(this.m_buffer, 16) + 20;
        return DataPacker.getInt(this.m_buffer, pos);
    }

    protected final void alignPosition() {
        this.m_pos = this.m_pos + 3 & 0xFFFFFFFC;
    }

    public final void packByte(int bval) {
        this.m_buffer[this.m_pos++] = (byte)(bval & 0xFF);
    }

    public final void packNulls(int len) {
        for (int i = 0; i < len; ++i) {
            this.m_buffer[this.m_pos++] = 0;
        }
    }

    public final void packInt(int ival) {
        DataPacker.putInt(ival, this.m_buffer, this.m_pos);
        this.m_pos += 4;
    }

    public final void packLong(long lval) {
        DataPacker.putLong(lval, this.m_buffer, this.m_pos);
        this.m_pos += 8;
    }

    public final void packByteArrayWithLength(byte[] buf) {
        DataPacker.putInt(buf.length, this.m_buffer, this.m_pos);
        this.m_pos += 4;
        System.arraycopy(buf, 0, this.m_buffer, this.m_pos, buf.length);
        this.m_pos += buf.length;
        this.alignPosition();
    }

    public final void packByteArray(byte[] buf) {
        System.arraycopy(buf, 0, this.m_buffer, this.m_pos, buf.length);
        this.m_pos += buf.length;
        this.alignPosition();
    }

    public final void packIntArrayWithLength(int[] iarray) {
        DataPacker.putInt(iarray.length, this.m_buffer, this.m_pos);
        this.m_pos += 4;
        for (int i = 0; i < iarray.length; ++i) {
            DataPacker.putInt(iarray[i], this.m_buffer, this.m_pos);
            this.m_pos += 4;
        }
    }

    public final void packString(String str) {
        DataPacker.putInt(str != null ? str.getBytes().length : 0, this.m_buffer, this.m_pos);
        this.m_pos += 4;
        if (str != null) {
            this.m_pos = DataPacker.putString(str, this.m_buffer, this.m_pos, false);
            this.alignPosition();
        }
    }

    public final void packUTF8String(String str) {
        byte[] strByts = null;
        try {
            if (str != null) {
                strByts = str.getBytes("UTF-8");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        DataPacker.putInt(strByts != null ? strByts.length : 0, this.m_buffer, this.m_pos);
        this.m_pos += 4;
        if (str != null) {
            System.arraycopy(strByts, 0, this.m_buffer, this.m_pos, strByts.length);
            this.m_pos += strByts.length;
            this.alignPosition();
        }
    }

    public final void packPortMapping(PortMapping portMap) {
        DataPacker.putInt(portMap.getProgramId(), this.m_buffer, this.m_pos);
        DataPacker.putInt(portMap.getVersionId(), this.m_buffer, this.m_pos + 4);
        DataPacker.putInt(portMap.getProtocol(), this.m_buffer, this.m_pos + 8);
        DataPacker.putInt(portMap.getPort(), this.m_buffer, this.m_pos + 12);
        this.m_pos += 16;
    }

    public final int unpackInt() {
        int val = DataPacker.getInt(this.m_buffer, this.m_pos);
        this.m_pos += 4;
        return val;
    }

    public final long unpackLong() {
        long val = DataPacker.getLong(this.m_buffer, this.m_pos);
        this.m_pos += 8;
        return val;
    }

    public final String unpackString() {
        int len = this.unpackInt();
        String str = "";
        if (len > 0) {
            str = DataPacker.getString(this.m_buffer, this.m_pos, len);
            this.m_pos += len;
            this.alignPosition();
        }
        return str;
    }

    public final String unpackUTF8String() {
        int len = this.unpackInt();
        String str = "";
        if (len > 0) {
            boolean utf8 = false;
            int idx = 0;
            while (!utf8 && idx < len) {
                if ((this.m_buffer[this.m_pos + idx] & 0x80) != 0) {
                    utf8 = true;
                    continue;
                }
                ++idx;
            }
            if (utf8) {
                try {
                    str = new String(this.m_buffer, this.m_pos, len, "UTF8");
                    str = _utf8Normalizer.normalize(str);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {}
            } else {
                str = DataPacker.getString(this.m_buffer, this.m_pos, len);
            }
            this.m_pos += len;
            this.alignPosition();
        }
        return str;
    }

    public final void unpackByteArrayWithLength(byte[] buf) {
        int len = DataPacker.getInt(this.m_buffer, this.m_pos);
        this.m_pos += 4;
        if (len > 0) {
            if (len > buf.length) {
                System.arraycopy(this.m_buffer, this.m_pos, buf, 0, buf.length);
            } else {
                System.arraycopy(this.m_buffer, this.m_pos, buf, 0, len);
            }
            this.m_pos += len;
        }
        this.alignPosition();
    }

    public final void unpackByteArray(byte[] buf) {
        System.arraycopy(this.m_buffer, this.m_pos, buf, 0, buf.length);
        this.m_pos += buf.length;
        this.alignPosition();
    }

    public final void unpackIntArray(int[] buf) {
        for (int i = 0; i < buf.length; ++i) {
            buf[i] = this.unpackInt();
        }
    }

    public final void positionAtCredentialsData() {
        this.m_pos = this.m_offset + 32;
    }

    public final void positionAtVerifierData() {
        this.m_pos = this.getVerifierOffset();
    }

    public final void positionAtParameters() {
        this.m_pos = this.getProcedureParameterOffset();
    }

    public final void skipBytes(int cnt) {
        this.m_pos += cnt + 3 & 0xFFFC;
    }

    public final void setClientDetails(InetAddress addr, int port, int protocol) {
        this.m_clientAddr = addr;
        this.m_clientPort = port;
        this.m_protocol = protocol;
    }

    public final void setBuffer(byte[] buf, int offset, int len) {
        this.m_buffer = buf;
        this.m_offset = offset;
        this.m_pos = offset;
        this.m_endPos = offset + len;
    }

    public final void setBuffer(int offset, int len) {
        this.m_offset = offset;
        this.m_pos = offset;
        this.m_endPos = offset + len;
    }

    public final void setLength(int len) {
        this.m_endPos = len + this.m_offset;
        if (this.m_offset == 4) {
            DataPacker.putInt(this.getLength() + Integer.MIN_VALUE, this.m_buffer, 0);
        }
    }

    public final void setLength() {
        this.m_endPos = this.m_pos;
        if (this.m_offset == 4) {
            DataPacker.putInt(this.getLength() + Integer.MIN_VALUE, this.m_buffer, 0);
        }
    }

    public final void setPosition(int pos) {
        this.m_pos = pos;
    }

    public final void setMessageType(int msgType) {
        DataPacker.putInt(msgType, this.m_buffer, this.m_offset + 4);
    }

    public final void setRpcVersion(int rpcVer) {
        DataPacker.putInt(rpcVer, this.m_buffer, this.m_offset + 8);
    }

    public final void setProgramId(int progId) {
        DataPacker.putInt(progId, this.m_buffer, this.m_offset + 12);
    }

    public final void setProgramVersion(int progVer) {
        DataPacker.putInt(progVer, this.m_buffer, this.m_offset + 16);
    }

    public final void setProcedureId(int procId) {
        DataPacker.putInt(procId, this.m_buffer, this.m_offset + 20);
    }

    public final void setCredentialsType(int credtype) {
        DataPacker.putInt(credtype, this.m_buffer, this.m_offset + 24);
    }

    public final void setCredentialsLength(int credlen) {
        DataPacker.putInt(credlen, this.m_buffer, this.m_offset + 28);
    }

    public final void setReplyState(int replySts) {
        DataPacker.putInt(replySts, this.m_buffer, this.m_offset + 8);
    }

    public final void setRejectStatus(int rejSts) {
        DataPacker.putInt(rejSts, this.m_buffer, this.m_offset + 8);
    }

    public final void setRpcMismatch(int rpcLow, int rpcHigh) {
        DataPacker.putInt(rpcLow, this.m_buffer, this.m_offset + 12);
        DataPacker.putInt(rpcHigh, this.m_buffer, this.m_offset + 16);
    }

    public final void setAuthFailStatus(int authSts) {
        DataPacker.putInt(authSts, this.m_buffer, this.m_offset + 8);
    }

    public final void setVerifierType(int verftype) {
        DataPacker.putInt(verftype, this.m_buffer, this.m_offset + this.getCredentialsLength() + 32);
    }

    public final void setVerifierLength(int verflen) {
        DataPacker.putInt(verflen, this.m_buffer, this.m_offset + this.getCredentialsLength() + 36);
    }

    public final void setPacketHandler(RpcPacketHandler pktHandler) {
        this.m_pktHandler = pktHandler;
    }

    public final void setXID(int xid) {
        DataPacker.putInt(xid, this.m_buffer, this.m_offset);
    }

    protected final void setOwnerPacketPool(RpcPacketPool pool) {
        this.m_ownerPool = pool;
    }

    public final void buildRequestHeader(int progId, int verId, int procId, int credType, byte[] cred, int verfType, byte[] verf) {
        this.setXID((int)(System.currentTimeMillis() & 0xFFFFFFFFL));
        this.setMessageType(0);
        this.setRpcVersion(2);
        this.setProgramId(progId);
        this.setProgramVersion(verId);
        this.setProcedureId(procId);
        this.setCredentialsType(credType);
        this.setCredentialsLength(cred != null ? cred.length : 0);
        if (cred != null) {
            System.arraycopy(cred, 0, this.m_buffer, this.m_offset + 32, cred.length);
        }
        this.setVerifierType(verfType);
        this.setVerifierLength(verf != null ? verf.length : 0);
        if (verf != null) {
            int pos = this.getVerifierOffset();
            System.arraycopy(verf, 0, this.m_buffer, pos, verf.length);
        }
        this.positionAtParameters();
    }

    public final void buildResponseHeader() {
        this.setMessageType(1);
        this.setReplyState(0);
        DataPacker.putInt(this.getVerifierType(), this.m_buffer, this.m_offset + 12);
        int verfLen = this.getVerifierLength();
        DataPacker.putInt(verfLen, this.m_buffer, this.m_offset + 16);
        if (verfLen > 0) {
            System.arraycopy(this.m_buffer, this.getVerifierOffset(), this.m_buffer, this.m_offset + 20, verfLen);
        }
        DataPacker.putInt(0, this.m_buffer, this.m_offset + 20 + verfLen);
        this.m_pos = this.m_offset + 24 + verfLen;
        this.setLength();
    }

    public final void buildErrorResponse(int stsCode) {
        boolean isReply = this.getMessageType() == 1;
        this.setMessageType(1);
        this.setReplyState(0);
        int verfLen = 0;
        if (!isReply) {
            DataPacker.putInt(this.getVerifierType(), this.m_buffer, this.m_offset + 12);
            verfLen = this.getVerifierLength();
            DataPacker.putInt(verfLen, this.m_buffer, this.m_offset + 16);
            if (verfLen > 0) {
                System.arraycopy(this.m_buffer, this.getVerifierOffset(), this.m_buffer, this.m_offset + 20, verfLen);
            }
        } else {
            verfLen = DataPacker.getInt(this.m_buffer, this.m_offset + 16);
        }
        DataPacker.putInt(0, this.m_buffer, this.m_offset + 20 + verfLen);
        this.m_pos = this.m_offset + 24 + verfLen;
        DataPacker.putInt(stsCode, this.m_buffer, this.m_pos);
        this.m_pos += 4;
        this.setLength();
    }

    public final void buildRpcMismatchResponse() {
        this.setMessageType(1);
        this.setReplyState(1);
        this.setRejectStatus(0);
        this.setRpcMismatch(2, 2);
        this.setLength(24);
    }

    public final void buildAuthFailResponse(int stsCode) {
        this.setMessageType(1);
        this.setReplyState(1);
        this.setRejectStatus(1);
        this.setAuthFailStatus(stsCode);
        this.setLength(20);
    }

    public final void buildAcceptErrorResponse(int stsCode) {
        this.setMessageType(1);
        this.setReplyState(0);
        DataPacker.putInt(this.getVerifierType(), this.m_buffer, this.m_offset + 12);
        int verfLen = this.getVerifierLength();
        DataPacker.putInt(verfLen, this.m_buffer, this.m_offset + 16);
        if (verfLen > 0) {
            System.arraycopy(this.m_buffer, this.getVerifierOffset(), this.m_buffer, this.m_offset + 20, verfLen);
        }
        DataPacker.putInt(stsCode, this.m_buffer, this.m_offset + 20 + verfLen);
        this.setLength(this.m_offset + 24 + verfLen);
    }

    public final void buildProgramMismatchResponse(int verLow, int verHigh) {
        this.setMessageType(1);
        this.setReplyState(0);
        DataPacker.putInt(this.getVerifierType(), this.m_buffer, this.m_offset + 12);
        int verfLen = this.getVerifierLength();
        DataPacker.putInt(verfLen, this.m_buffer, this.m_offset + 16);
        if (verfLen > 0) {
            System.arraycopy(this.m_buffer, this.getVerifierOffset(), this.m_buffer, this.m_offset + 20, verfLen);
        }
        int pos = this.m_offset + 20 + verfLen;
        DataPacker.putInt(2, this.m_buffer, pos);
        DataPacker.putInt(verLow, this.m_buffer, pos + 4);
        DataPacker.putInt(verHigh, this.m_buffer, pos + 8);
        this.setLength(pos + 12);
    }

    public String toString() {
        StringBuffer str = new StringBuffer(128);
        str.append("[");
        if (this.hasClientAddress()) {
            str.append(this.getClientProtocol() == 6 ? "T" : "U");
            str.append(this.getClientAddress().getHostAddress());
            str.append(":");
            str.append(this.getClientPort());
        } else {
            str.append("<Unknown>");
        }
        if (this.getMessageType() == 0) {
            str.append("-Call,XID=0x");
            str.append(Integer.toHexString(this.getXID()));
            str.append(",RpcVer=");
            str.append(this.getRpcVersion());
            str.append(",ProgId=");
            str.append(this.getProgramId());
            str.append(",ProgVer=");
            str.append(this.getProgramVersion());
            str.append(",Proc=");
            str.append(this.getProcedureId());
            str.append(",CredType=");
            str.append(this.getCredentialsType());
            str.append(",CredLen=");
            str.append(this.getCredentialsLength());
            str.append(",VerfType");
            str.append(this.getVerifierType());
            str.append(",VerfLen=");
            str.append(this.getVerifierLength());
            str.append(",ParamLen=");
            str.append(this.getProcedureParameterLength());
        } else {
            str.append("-Reply,XID=0x");
            str.append(Integer.toHexString(this.getXID()));
            if (this.getReplyState() == 0) {
                str.append(",Accepted");
            } else {
                str.append(",Denied");
                if (this.getRejectStatus() == 0) {
                    str.append(",RpcMismatch, Low=");
                    str.append(this.getMismatchVersionLow());
                    str.append("/High=");
                    str.append(this.getMismatchVersionHigh());
                } else {
                    str.append(",AuthError, Status=");
                    str.append(this.getAuthFailStatus());
                }
            }
        }
        if (this.isAllocatedFromPool()) {
            str.append(",Pool");
        }
        str.append("]");
        return str.toString();
    }
}

