/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.oncrpc;

import java.util.ArrayList;
import java.util.List;
import org.filesys.oncrpc.RpcPacket;

public class RpcPacketPool {
    public static final int DefaultSmallSize = 512;
    public static final int DefaultLargeSize = 32768;
    public static final int DefaultSmallLimit = -1;
    public static final int DefaultLargeLimit = -1;
    private List<RpcPacket> m_smallPackets = new ArrayList<RpcPacket>();
    private List<RpcPacket> m_largePackets = new ArrayList<RpcPacket>();
    private int m_smallPktSize;
    private int m_smallPktLimit;
    private int m_largePktSize;
    private int m_largePktLimit;
    private int m_smallPktCount;
    private int m_largePktCount;
    private static final boolean m_debug = false;

    public RpcPacketPool() {
        this.m_smallPktSize = 512;
        this.m_smallPktLimit = -1;
        this.m_largePktSize = 32768;
        this.m_largePktLimit = -1;
    }

    public RpcPacketPool(int smallSize, int smallLimit, int largeSize, int largeLimit) {
        this.m_smallPktSize = smallSize;
        this.m_smallPktLimit = smallLimit;
        this.m_largePktSize = largeSize;
        this.m_largePktLimit = largeLimit;
    }

    public RpcPacketPool(int largeSize, int largeLimit) {
        this.m_smallPktSize = 512;
        this.m_smallPktLimit = largeLimit;
        this.m_largePktSize = largeSize;
        this.m_largePktLimit = largeLimit;
    }

    public final int getSmallPacketSize() {
        return this.m_smallPktSize;
    }

    public final int getSmallPacketCount() {
        return this.m_smallPktCount;
    }

    public final int getSmallPacketAllocationLimit() {
        return this.m_smallPktLimit;
    }

    public final int availableLargePackets() {
        return this.m_largePackets.size();
    }

    public final int getLargePacketSize() {
        return this.m_largePktSize;
    }

    public final int getLargePacketCount() {
        return this.m_largePktCount;
    }

    public final int getLargePacketAllocationLimit() {
        return this.m_largePktLimit;
    }

    public final int availableSmallPackets() {
        return this.m_smallPackets.size();
    }

    public final RpcPacket allocatePacket(int reqSize) {
        RpcPacket pkt = null;
        pkt = reqSize <= this.m_smallPktSize ? this.allocateSmallPacket() : this.allocateLargePacket();
        return pkt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void releasePacket(RpcPacket pkt) {
        if (pkt.getBuffer().length >= this.m_largePktSize) {
            List<RpcPacket> list = this.m_largePackets;
            synchronized (list) {
                this.m_largePackets.add(pkt);
                this.m_largePackets.notify();
            }
        }
        List<RpcPacket> list = this.m_smallPackets;
        synchronized (list) {
            this.m_smallPackets.add(pkt);
            this.m_smallPackets.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final RpcPacket allocateSmallPacket() {
        RpcPacket pkt = null;
        List<RpcPacket> list = this.m_smallPackets;
        synchronized (list) {
            if (this.m_smallPackets.size() > 0) {
                pkt = this.m_smallPackets.remove(0);
            } else if (this.m_smallPktLimit == -1 || this.m_smallPktCount < this.m_smallPktLimit) {
                pkt = new RpcPacket(this.m_smallPktSize, this);
                ++this.m_smallPktCount;
            } else {
                try {
                    this.m_smallPackets.wait();
                    if (this.m_smallPackets.size() > 0) {
                        pkt = this.m_smallPackets.remove(0);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        return pkt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final RpcPacket allocateLargePacket() {
        RpcPacket pkt = null;
        List<RpcPacket> list = this.m_largePackets;
        synchronized (list) {
            if (this.m_largePackets.size() > 0) {
                pkt = this.m_largePackets.remove(0);
            } else if (this.m_largePktLimit == -1 || this.m_largePktCount < this.m_largePktLimit) {
                pkt = new RpcPacket(this.m_largePktSize, this);
                ++this.m_largePktCount;
            } else {
                try {
                    while (this.m_largePackets.isEmpty()) {
                        this.m_largePackets.wait();
                    }
                    if (this.m_largePackets.size() > 0) {
                        pkt = this.m_largePackets.remove(0);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        return pkt;
    }
}

