/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.oncrpc;

import org.filesys.debug.Debug;
import org.filesys.oncrpc.RpcPacket;
import org.filesys.oncrpc.RpcProcessor;
import org.filesys.oncrpc.RpcRequestQueue;

public class RpcRequestThreadPool {
    public static final int DefaultWorkerThreads = 8;
    public static final int MinimumWorkerThreads = 4;
    public static final int MaximumWorkerThreads = 50;
    private RpcRequestQueue m_queue;
    private ThreadWorker[] m_workers;
    private RpcProcessor m_rpcProcessor;
    private static boolean m_debug = true;

    public RpcRequestThreadPool(String threadName, RpcProcessor rpcServer) {
        this(threadName, 8, rpcServer);
    }

    public RpcRequestThreadPool(String threadName, int poolSize, RpcProcessor rpcServer) {
        this.m_rpcProcessor = rpcServer;
        this.m_queue = new RpcRequestQueue();
        if (poolSize < 4) {
            poolSize = 4;
        }
        this.m_workers = new ThreadWorker[poolSize];
        for (int i = 0; i < this.m_workers.length; ++i) {
            this.m_workers[i] = new ThreadWorker(threadName + (i + 1), i);
        }
    }

    public static final boolean hasDebug() {
        return m_debug;
    }

    public final int getNumberOfRequests() {
        return this.m_queue.numberOfRequests();
    }

    public final void queueRpcRequest(RpcPacket pkt) {
        this.m_queue.addRequest(pkt);
    }

    public void shutdownThreadPool() {
        if (this.m_workers != null) {
            for (int i = 0; i < this.m_workers.length; ++i) {
                this.m_workers[i].shutdownRequest();
            }
        }
    }

    protected class ThreadWorker
    implements Runnable {
        private Thread mi_thread;
        private int mi_id;
        private boolean mi_shutdown = false;

        public ThreadWorker(String name, int id) {
            this.mi_id = id;
            this.mi_thread = new Thread(this);
            this.mi_thread.setName(name);
            this.mi_thread.setDaemon(true);
            this.mi_thread.start();
        }

        public final void shutdownRequest() {
            this.mi_shutdown = true;
            try {
                this.mi_thread.interrupt();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            RpcPacket rpc = null;
            RpcPacket response = null;
            while (!this.mi_shutdown) {
                try {
                    rpc = RpcRequestThreadPool.this.m_queue.removeRequest();
                }
                catch (InterruptedException ex) {
                    if (this.mi_shutdown) break;
                }
                if (rpc == null) continue;
                try {
                    response = RpcRequestThreadPool.this.m_rpcProcessor.processRpc(rpc);
                    if (response == null) continue;
                    response.getPacketHandler().sendRpcResponse(response);
                }
                catch (Throwable ex) {
                    if (this.mi_shutdown) continue;
                    Debug.println("Worker " + Thread.currentThread().getName() + ":");
                    Debug.println(ex);
                }
                finally {
                    if (rpc.getClientProtocol() == 6 && rpc.isAllocatedFromPool()) {
                        rpc.getOwnerPacketPool().releasePacket(rpc);
                    }
                    if (response == null || response.getClientProtocol() != 6 || response.getBuffer() == rpc.getBuffer() || !response.isAllocatedFromPool()) continue;
                    response.getOwnerPacketPool().releasePacket(response);
                }
            }
        }
    }
}

