/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.oncrpc;

import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import org.filesys.debug.Debug;
import org.filesys.oncrpc.RpcPacket;
import org.filesys.oncrpc.RpcProcessor;
import org.filesys.oncrpc.TcpRpcSessionHandler;
import org.filesys.server.SocketPacketHandler;
import org.filesys.util.DataPacker;

public class TcpRpcPacketHandler
extends SocketPacketHandler
implements Runnable {
    private TcpRpcSessionHandler m_handler;
    private RpcProcessor m_rpcProcessor;
    private int m_sessId;
    private boolean m_shutdown;
    private int m_maxRpcSize;
    private RpcPacket m_rxPkt;
    private byte[] m_fragBuf;

    public TcpRpcPacketHandler(TcpRpcSessionHandler handler, int sessId, RpcProcessor server, Socket socket, int maxRpcSize) throws IOException {
        super(socket);
        this.m_handler = handler;
        this.m_sessId = sessId;
        this.m_rpcProcessor = server;
        this.m_maxRpcSize = maxRpcSize;
        this.m_fragBuf = new byte[4];
        Thread th = new Thread(this);
        th.setName(handler.getProtocolName() + "_" + this.getSessionId());
        th.start();
    }

    public TcpRpcPacketHandler(Socket socket, int maxRpcSize) throws IOException {
        super(socket);
        this.m_maxRpcSize = maxRpcSize;
        this.m_fragBuf = new byte[4];
    }

    @Override
    public String getProtocolName() {
        return "TCP RPC";
    }

    public final int getSessionId() {
        return this.m_sessId;
    }

    public final int getMaximumRpcSize() {
        return this.m_maxRpcSize;
    }

    protected final TcpRpcSessionHandler getHandler() {
        return this.m_handler;
    }

    @Override
    public void run() {
        int rxLen = 0;
        RpcPacket rpcPkt = null;
        while (!this.m_shutdown) {
            block9: {
                try {
                    rpcPkt = this.allocateRpcPacket(this.getMaximumRpcSize());
                    rxLen = this.receiveRpc(rpcPkt);
                    if (rxLen == -1) {
                        this.deallocateRpcPacket(rpcPkt);
                        this.m_handler.closeSession(this.getSessionId());
                        break;
                    }
                }
                catch (SocketException ex) {
                    if (rpcPkt != null) {
                        this.deallocateRpcPacket(rpcPkt);
                    }
                    this.m_handler.closeSession(this.getSessionId());
                    break;
                }
                catch (IOException ex) {
                    if (this.m_shutdown) break block9;
                    Debug.println(ex);
                }
            }
            try {
                if (rpcPkt.getRpcVersion() != 2) {
                    rpcPkt.buildRpcMismatchResponse();
                    this.sendRpc(rpcPkt);
                    continue;
                }
                this.processRpc(rpcPkt);
            }
            catch (IOException ex) {
                if (this.m_shutdown) continue;
                Debug.println(ex);
            }
        }
    }

    @Override
    public void closePacketHandler() {
        this.m_shutdown = true;
        super.closePacketHandler();
    }

    protected final void sendRpc(RpcPacket rpc) throws IOException {
        this.writePacket(rpc.getBuffer(), 0, rpc.getTxLength());
    }

    protected final int receiveRpc(RpcPacket rpc) throws IOException {
        int rxLen = this.receiveRpc(rpc.getBuffer(), 4, rpc.getBuffer().length - 4);
        if (rxLen > 0) {
            rpc.setBuffer(4, rxLen + 4);
            rpc.setClientDetails(this.getSocket().getInetAddress(), this.getSocket().getPort(), 6);
        }
        return rxLen;
    }

    protected final int receiveRpc(byte[] buffer, int offset, int maxLen) throws IOException {
        int rxLen = 0;
        int totLen = 0;
        int rxOffset = offset;
        int fragLen = 0;
        boolean lastFrag = false;
        while (!lastFrag) {
            rxLen = this.readPacket(this.m_fragBuf, 0, 4);
            if (rxLen == -1) {
                return rxLen;
            }
            fragLen = DataPacker.getInt(this.m_fragBuf, 0);
            if ((fragLen & Integer.MIN_VALUE) != 0) {
                lastFrag = true;
                fragLen &= Integer.MAX_VALUE;
            }
            if (fragLen > buffer.length - rxOffset) {
                throw new IOException("Receive RPC buffer overflow, fragment len = " + fragLen);
            }
            while (fragLen > 0) {
                rxLen = this.readPacket(buffer, offset, fragLen);
                if (rxLen == -1) {
                    return -1;
                }
                totLen += rxLen;
                fragLen -= rxLen;
                offset += rxLen;
            }
        }
        return totLen;
    }

    protected RpcPacket allocateRpcPacket(int maxSize) {
        if (this.m_rxPkt == null) {
            this.m_rxPkt = new RpcPacket(maxSize);
        }
        return this.m_rxPkt;
    }

    protected void deallocateRpcPacket(RpcPacket pkt) {
    }

    protected void processRpc(RpcPacket rpc) throws IOException {
        RpcPacket response = this.m_rpcProcessor.processRpc(rpc);
        if (response != null) {
            this.sendRpc(response);
        }
    }
}

