/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.oncrpc.mount;

import java.io.IOException;
import java.util.Enumeration;
import org.filesys.debug.Debug;
import org.filesys.oncrpc.PortMapping;
import org.filesys.oncrpc.RpcAuthenticationException;
import org.filesys.oncrpc.RpcAuthenticator;
import org.filesys.oncrpc.RpcNetworkServer;
import org.filesys.oncrpc.RpcPacket;
import org.filesys.oncrpc.RpcProcessor;
import org.filesys.oncrpc.TcpRpcSessionHandler;
import org.filesys.oncrpc.UdpRpcDatagramHandler;
import org.filesys.oncrpc.mount.MountEntry;
import org.filesys.oncrpc.mount.MountEntryList;
import org.filesys.oncrpc.nfs.NFSConfigSection;
import org.filesys.oncrpc.nfs.NFSHandle;
import org.filesys.oncrpc.nfs.NFSSrvSession;
import org.filesys.server.Version;
import org.filesys.server.auth.acl.AccessControlManager;
import org.filesys.server.config.ServerConfiguration;
import org.filesys.server.core.ShareType;
import org.filesys.server.core.SharedDevice;
import org.filesys.server.core.SharedDeviceList;
import org.filesys.server.filesys.DiskInterface;
import org.filesys.server.filesys.FileInfo;
import org.filesys.server.filesys.TreeConnection;
import org.filesys.server.filesys.TreeConnectionHash;

public class MountServer
extends RpcNetworkServer
implements RpcProcessor {
    private static final String ServerVersion = Version.MountServerVersion;
    public static final int MaxRequestSize = 8192;
    public static final String UNIX_SEPERATOR = "/";
    public static final char UNIX_SEPERATOR_CHAR = '/';
    public static final String DOS_SEPERATOR = "\\";
    public static final char DOS_SEPERATOR_CHAR = '\\';
    private NFSConfigSection m_nfsConfig;
    private UdpRpcDatagramHandler m_udpHandler;
    private TcpRpcSessionHandler m_tcpHandler;
    private TreeConnectionHash m_connections;
    private MountEntryList m_mounts;
    private int m_port;

    public MountServer(ServerConfiguration config) {
        super("Mount", config);
        this.setVersion(ServerVersion);
        this.m_nfsConfig = (NFSConfigSection)config.getConfigSection("NFS");
        if (this.m_nfsConfig != null) {
            this.setDebug(this.getNFSConfiguration().hasMountServerDebug());
            this.setPort(this.getNFSConfiguration().getMountServerPort());
            this.setPortMapper(this.getNFSConfiguration().getPortMapperPort());
        } else {
            this.setEnabled(false);
        }
    }

    public final int getPort() {
        return this.m_port;
    }

    private final NFSConfigSection getNFSConfiguration() {
        return this.m_nfsConfig;
    }

    public final void setPort(int port) {
        this.m_port = port;
    }

    @Override
    public void startServer() {
        try {
            this.m_udpHandler = new UdpRpcDatagramHandler("Mountd", "Mnt", this, this, null, this.getPort(), 8192);
            this.m_udpHandler.initializeSessionHandler(this);
            Thread udpThread = new Thread(this.m_udpHandler);
            udpThread.setName("Mountd_UDP");
            udpThread.start();
            this.m_tcpHandler = new TcpRpcSessionHandler("Mountd", "Mnt", this, this, null, this.getPort(), 8192);
            this.m_tcpHandler.initializeSessionHandler(this);
            Thread tcpThread = new Thread(this.m_tcpHandler);
            tcpThread.setName("Mountd_TCP");
            tcpThread.start();
            PortMapping[] mappings = new PortMapping[]{new PortMapping(100005, 1, 17, this.m_udpHandler.getPort()), new PortMapping(100005, 3, 17, this.m_udpHandler.getPort()), new PortMapping(100005, 1, 6, this.m_tcpHandler.getPort()), new PortMapping(100005, 3, 6, this.m_tcpHandler.getPort())};
            this.registerRPCServer(mappings);
        }
        catch (Exception ex) {
            Debug.println(ex);
        }
        this.m_connections = new TreeConnectionHash();
        SharedDeviceList shareList = this.getShareMapper().getShareList(this.getConfiguration().getServerName(), null, false);
        Enumeration<SharedDevice> shares = shareList.enumerateShares();
        while (shares.hasMoreElements()) {
            SharedDevice share = shares.nextElement();
            if (share == null || share.getType() != ShareType.DISK) continue;
            this.m_connections.addConnection(new TreeConnection(share));
        }
        this.m_mounts = new MountEntryList();
    }

    @Override
    public void shutdownServer(boolean immediate) {
        block4: {
            try {
                PortMapping[] mappings = new PortMapping[]{new PortMapping(100005, 1, 17, this.m_udpHandler.getPort()), new PortMapping(100005, 3, 17, this.m_udpHandler.getPort()), new PortMapping(100005, 1, 6, this.m_tcpHandler.getPort()), new PortMapping(100005, 3, 6, this.m_tcpHandler.getPort())};
                this.unregisterRPCServer(mappings);
            }
            catch (IOException ex) {
                if (!this.hasDebug()) break block4;
                Debug.println(ex);
            }
        }
        if (this.m_udpHandler != null) {
            this.m_udpHandler.closeSessionHandler(this);
            this.m_udpHandler = null;
        }
        if (this.m_tcpHandler != null) {
            this.m_tcpHandler.closeSessionHandler(this);
            this.m_tcpHandler = null;
        }
        this.fireServerEvent(2);
    }

    @Override
    public RpcPacket processRpc(RpcPacket rpc) throws IOException {
        int version = rpc.getProgramVersion();
        if (rpc.getProgramId() != 100005) {
            rpc.buildAcceptErrorResponse(1);
            return rpc;
        }
        if (version != 1 && version != 3) {
            rpc.buildProgramMismatchResponse(1, 3);
            return rpc;
        }
        rpc.positionAtParameters();
        int procId = rpc.getProcedureId();
        NFSSrvSession sess = null;
        if (!(version == 1 && procId == 0) && !(version == 3 && procId == 0)) {
            try {
                sess = this.createTemporarySession(rpc);
            }
            catch (RpcAuthenticationException ex) {
                rpc.buildAuthFailResponse(ex.getAuthenticationErrorCode());
                return rpc;
            }
        }
        rpc.positionAtParameters();
        RpcPacket response = null;
        if (version == 1) {
            switch (rpc.getProcedureId()) {
                case 0: {
                    response = this.procNull(rpc);
                    break;
                }
                case 1: {
                    response = this.procMount(sess, rpc, version);
                    break;
                }
                case 2: {
                    response = this.procDump(sess, rpc, version);
                    break;
                }
                case 3: {
                    response = this.procUnMount(sess, rpc, version);
                    break;
                }
                case 4: {
                    response = this.procUnMountAll(sess, rpc, version);
                    break;
                }
                case 5: {
                    response = this.procExport(sess, rpc, version);
                    break;
                }
                case 6: {
                    response = this.procExportAll(sess, rpc);
                }
            }
        } else if (version == 3) {
            switch (rpc.getProcedureId()) {
                case 0: {
                    response = this.procNull(rpc);
                    break;
                }
                case 1: {
                    response = this.procMount(sess, rpc, version);
                    break;
                }
                case 2: {
                    response = this.procDump(sess, rpc, version);
                    break;
                }
                case 3: {
                    response = this.procUnMount(sess, rpc, version);
                    break;
                }
                case 4: {
                    response = this.procUnMountAll(sess, rpc, version);
                    break;
                }
                case 5: {
                    response = this.procExport(sess, rpc, version);
                }
            }
        }
        return response;
    }

    private final RpcPacket procNull(RpcPacket rpc) {
        rpc.buildResponseHeader();
        return rpc;
    }

    private final RpcPacket procMount(NFSSrvSession sess, RpcPacket rpc, int version) {
        String mountPath = rpc.unpackString();
        if (this.hasDebug()) {
            Debug.println("[Mount] Mount request from " + rpc.getClientDetails() + " path=" + mountPath);
        }
        byte[] handle = this.allocateFileHandle(version);
        int sts = this.mountPath(sess, mountPath, handle);
        rpc.buildResponseHeader();
        if (version == 1) {
            rpc.packInt(sts);
            if (sts == 0) {
                rpc.packByteArray(handle);
            }
        } else if (version == 3) {
            rpc.packInt(sts);
            if (sts == 0) {
                rpc.packByteArrayWithLength(handle);
            }
            rpc.packIntArrayWithLength(this.getNFSConfiguration().getRpcAuthenticator().getRpcAuthenticationTypes());
        }
        rpc.setLength();
        return rpc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final RpcPacket procDump(NFSSrvSession sess, RpcPacket rpc, int version) {
        if (this.hasDebug()) {
            Debug.println("[Mount] Dump request from " + rpc.getClientDetails());
        }
        MountEntryList activeList = null;
        MountEntryList mountEntryList = this.m_mounts;
        synchronized (mountEntryList) {
            if (this.m_mounts.numberOfEntries() > 0) {
                activeList = new MountEntryList();
                for (int i = 0; i < this.m_mounts.numberOfEntries(); ++i) {
                    activeList.addEntry(this.m_mounts.getEntryAt(i));
                }
            }
        }
        rpc.buildResponseHeader();
        if (activeList != null) {
            for (int i = 0; i < activeList.numberOfEntries(); ++i) {
                MountEntry mntEntry = activeList.getEntryAt(i);
                rpc.packInt(1);
                rpc.packString(mntEntry.getPath());
                rpc.packString(mntEntry.getHost());
            }
        }
        rpc.packInt(0);
        rpc.setLength();
        return rpc;
    }

    private final RpcPacket procUnMount(NFSSrvSession sess, RpcPacket rpc, int version) {
        String mountPath = rpc.unpackString();
        if (this.hasDebug()) {
            Debug.println("[Mount] UnMount request from " + rpc.getClientDetails() + " path=" + mountPath);
        }
        this.m_mounts.removeEntry(mountPath, sess.getRemoteName());
        rpc.buildResponseHeader();
        return rpc;
    }

    private final RpcPacket procUnMountAll(NFSSrvSession sess, RpcPacket rpc, int version) {
        if (this.hasDebug()) {
            Debug.println("[Mount] UnMountAll request from " + rpc.getClientDetails());
        }
        this.m_mounts.removeHostEntries(sess.getRemoteName());
        rpc.buildResponseHeader();
        return rpc;
    }

    private final RpcPacket procExport(NFSSrvSession sess, RpcPacket rpc, int version) {
        if (this.hasDebug()) {
            Debug.println("[Mount] Export request from " + rpc.getClientDetails());
        }
        SharedDeviceList shareList = sess.getServer().getShareMapper().getShareList(this.getConfiguration().getServerName(), sess, false);
        if (sess.getServer().hasAccessControlManager()) {
            AccessControlManager aclMgr = sess.getServer().getAccessControlManager();
            shareList = aclMgr.filterShareList(sess, shareList);
        }
        rpc.buildResponseHeader();
        Enumeration<SharedDevice> enm = shareList.enumerateShares();
        while (enm.hasMoreElements()) {
            SharedDevice share = enm.nextElement();
            if (share.getType() != ShareType.DISK) continue;
            rpc.packInt(1);
            rpc.packString(UNIX_SEPERATOR + share.getName());
            rpc.packInt(0);
        }
        rpc.packInt(0);
        rpc.setLength();
        return rpc;
    }

    private final RpcPacket procExportAll(NFSSrvSession sess, RpcPacket rpc) {
        return null;
    }

    private final NFSSrvSession createTemporarySession(RpcPacket rpc) throws RpcAuthenticationException {
        RpcAuthenticator rpcAuth = this.getNFSConfiguration().getRpcAuthenticator();
        Object sessKey = rpcAuth.authenticateRpcClient(rpc.getCredentialsType(), rpc);
        NFSSrvSession nfsSess = new NFSSrvSession(this, rpc.getClientAddress(), rpc.getClientPort(), rpc.getClientProtocol());
        nfsSess.setClientInformation(rpcAuth.getRpcClientInformation(sessKey, rpc));
        nfsSess.setDebugPrefix("[Mount] ");
        return nfsSess;
    }

    protected final int mountPath(NFSSrvSession sess, String path, byte[] handle) {
        if (this.hasDebug()) {
            Debug.println("MountPath path=" + path);
        }
        if (path.startsWith(UNIX_SEPERATOR) && path.length() >= 2) {
            String shareName = null;
            String extraPath = null;
            int shareId = -1;
            int pos = path.indexOf(UNIX_SEPERATOR, 1);
            if (pos != -1) {
                shareName = path.substring(1, pos);
                extraPath = path.substring(pos);
            } else {
                shareName = path.substring(1);
            }
            SharedDevice share = null;
            try {
                share = this.getShareMapper().findShare(this.getConfiguration().getServerName(), shareName, ShareType.DISK, sess, false);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (share != null) {
                AccessControlManager aclMgr;
                if (this.getSecurityConfiguration().hasAccessControlManager() && (aclMgr = this.getSecurityConfiguration().getAccessControlManager()).checkAccessControl(sess, share) == 0) {
                    if (this.hasDebug()) {
                        Debug.println("Failed to mount path=" + path + ", access denied");
                    }
                    return 2;
                }
                shareId = shareName.hashCode();
                if (extraPath != null) {
                    if ((extraPath = extraPath.replace('/', '\\')).endsWith(DOS_SEPERATOR)) {
                        extraPath = extraPath.substring(0, extraPath.length() - 2);
                    }
                    try {
                        TreeConnection conn = this.m_connections.findConnection(shareId);
                        DiskInterface disk = (DiskInterface)conn.getSharedDevice().getInterface();
                        FileInfo finfo = disk.getFileInformation(sess, conn, extraPath);
                        if (finfo == null) {
                            return 2;
                        }
                        if (!finfo.isDirectory()) {
                            return 20;
                        }
                        NFSHandle.packDirectoryHandle(shareId, finfo.getFileId(), handle);
                    }
                    catch (Exception exception) {}
                } else {
                    NFSHandle.packShareHandle(share.getName(), handle);
                }
                this.m_mounts.addEntry(new MountEntry(sess.getRemoteName(), path));
                if (this.hasDebug()) {
                    Debug.println("Mounted path=" + path + ", handle=" + NFSHandle.asString(handle));
                }
                return 0;
            }
            if (this.hasDebug()) {
                Debug.println("Failed to mount path=" + path);
            }
            return 2;
        }
        return 2;
    }

    private final byte[] allocateFileHandle(int version) {
        byte[] handle = null;
        if (version == 1) {
            handle = new byte[32];
        } else if (version == 3) {
            handle = new byte[32];
        }
        return handle;
    }
}

