/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.oncrpc.nfs;

public final class NFS {
    public static final int DefaultPort = 2049;
    public static final int ProgramId = 100003;
    public static final int VersionId = 3;
    public static final int ProcNull = 0;
    public static final int ProcGetAttr = 1;
    public static final int ProcSetAttr = 2;
    public static final int ProcLookup = 3;
    public static final int ProcAccess = 4;
    public static final int ProcReadLink = 5;
    public static final int ProcRead = 6;
    public static final int ProcWrite = 7;
    public static final int ProcCreate = 8;
    public static final int ProcMkDir = 9;
    public static final int ProcSymLink = 10;
    public static final int ProcMkNode = 11;
    public static final int ProcRemove = 12;
    public static final int ProcRmDir = 13;
    public static final int ProcRename = 14;
    public static final int ProcLink = 15;
    public static final int ProcReadDir = 16;
    public static final int ProcReadDirPlus = 17;
    public static final int ProcFsStat = 18;
    public static final int ProcFsInfo = 19;
    public static final int ProcPathConf = 20;
    public static final int ProcCommit = 21;
    public static final int ProcMax = 21;
    public static final int StsSuccess = 0;
    public static final int StsPerm = 1;
    public static final int StsNoEnt = 2;
    public static final int StsIO = 5;
    public static final int StsNxIO = 6;
    public static final int StsAccess = 13;
    public static final int StsExist = 17;
    public static final int StsXDev = 18;
    public static final int StsNoDev = 19;
    public static final int StsNotDir = 20;
    public static final int StsIsDir = 21;
    public static final int StsInVal = 22;
    public static final int StsFBig = 27;
    public static final int StsNoSpc = 28;
    public static final int StsROFS = 30;
    public static final int StsMLink = 31;
    public static final int StsNameTooLong = 63;
    public static final int StsNotEmpty = 66;
    public static final int StsDQuot = 69;
    public static final int StsStale = 70;
    public static final int StsRemote = 71;
    public static final int StsBadHandle = 10001;
    public static final int StsNotSync = 10002;
    public static final int StsBadCookie = 10003;
    public static final int StsNotSupp = 10004;
    public static final int StsTooSmall = 10005;
    public static final int StsServerFault = 10006;
    public static final int StsBadType = 10007;
    public static final int StsJukeBox = 10008;
    public static final int FileHandleSize = 32;
    public static final int WriteVerfSize = 8;
    public static final int CreateVerfSize = 8;
    public static final int CookieVerfSize = 8;
    public static final int FileTypeReg = 1;
    public static final int FileTypeDir = 2;
    public static final int FileTypeBlk = 3;
    public static final int FileTypeChr = 4;
    public static final int FileTypeLnk = 5;
    public static final int FileTypeSock = 6;
    public static final int FileTypeFifo = 7;
    public static final int FileSysLink = 1;
    public static final int FileSysSymLink = 2;
    public static final int FileSysHomogeneuos = 4;
    public static final int FileSysCanSetTime = 8;
    public static final int AccessRead = 1;
    public static final int AccessLookup = 2;
    public static final int AccessModify = 4;
    public static final int AccessExtend = 8;
    public static final int AccessDelete = 16;
    public static final int AccessExecute = 32;
    public static final int AccessAll = 63;
    public static final int CreateUnchecked = 1;
    public static final int CreateGuarded = 2;
    public static final int CreateExclusive = 3;
    public static final int WriteUnstable = 0;
    public static final int WriteDataSync = 1;
    public static final int WriteFileSync = 2;
    public static final int DoNotSetTime = 0;
    public static final int SetTimeServer = 1;
    public static final int SetTimeClient = 2;
    private static final String[] _procNames = new String[]{"Null", "GetAttr", "SetAttr", "Lookup", "Access", "ReadLink", "Read", "Write", "Create", "MkDir", "SymLink", "MkNode", "Remove", "RmDir", "Rename", "Link", "ReadDir", "ReadDirPlus", "FsStat", "FsInfo", "PathConf", "Commit"};

    public static final String getProcedureName(int id) {
        if (id < 0 || id > 21) {
            return null;
        }
        return _procNames[id];
    }

    public static final String getStatusString(int sts) {
        String str = null;
        switch (sts) {
            case 0: {
                str = "Success status";
                break;
            }
            case 13: {
                str = "Access denied";
                break;
            }
            case 10003: {
                str = "Bad cookie";
                break;
            }
            case 10001: {
                str = "Bad handle";
                break;
            }
            case 10007: {
                str = "Bad type";
                break;
            }
            case 69: {
                str = "Quota exceeded";
                break;
            }
            case 1: {
                str = "No permission";
                break;
            }
            case 17: {
                str = "Already exists";
                break;
            }
            case 27: {
                str = "File too large";
                break;
            }
            case 22: {
                str = "Invalid argument";
                break;
            }
            case 5: {
                str = "I/O error";
                break;
            }
            case 21: {
                str = "Is directory";
                break;
            }
            case 10008: {
                str = "Jukebox";
                break;
            }
            case 31: {
                str = "Too many hard links";
                break;
            }
            case 63: {
                str = "Name too long";
                break;
            }
            case 19: {
                str = "No such device";
                break;
            }
            case 2: {
                str = "No entity";
                break;
            }
            case 28: {
                str = "No space left on device";
                break;
            }
            case 10002: {
                str = "Update synchronization mismatch";
                break;
            }
            case 20: {
                str = "Not directory";
                break;
            }
            case 66: {
                str = "Not empty";
                break;
            }
            case 10004: {
                str = "Not supported";
                break;
            }
            case 6: {
                str = "Nxio";
                break;
            }
            case 71: {
                str = "Too many levels of remote in path";
                break;
            }
            case 30: {
                str = "Readonly filesystem";
                break;
            }
            case 10006: {
                str = "Server fault";
                break;
            }
            case 70: {
                str = "Stale";
                break;
            }
            case 10005: {
                str = "Too small";
                break;
            }
            case 18: {
                str = "Cross device hard link attempted";
            }
        }
        return str;
    }
}

