/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.oncrpc.nfs;

import java.net.InetAddress;
import java.util.Enumeration;
import org.filesys.oncrpc.nfs.NFSConfigSection;
import org.filesys.oncrpc.nfs.NFSServer;
import org.filesys.oncrpc.nfs.NetworkFileCache;
import org.filesys.server.NetworkServer;
import org.filesys.server.SrvSession;
import org.filesys.server.auth.ClientInfo;
import org.filesys.server.core.DeviceInterface;
import org.filesys.server.filesys.SearchContext;
import org.filesys.server.filesys.TreeConnection;
import org.filesys.server.filesys.TreeConnectionHash;

public class NFSSrvSession
extends SrvSession {
    private static final int DefaultSearches = 32;
    private static final int MaxSearches = 256;
    private InetAddress m_remAddr;
    private int m_remPort;
    private int m_type;
    private Object m_authIdentifier;
    private TreeConnectionHash m_connections;
    private NetworkFileCache m_fileCache;
    private long m_lastAccess;
    private SearchContext[] m_search;
    private int m_searchCount;
    private ClientInfo m_nfsClientInfo;

    public NFSSrvSession(NetworkServer srv, InetAddress addr, int port, int type) {
        super(-1, srv, "NFS", null);
        this.m_remAddr = addr;
        this.m_remPort = port;
        this.m_type = type;
        StringBuffer str = new StringBuffer();
        str.append(type == 6 ? "T" : "U");
        str.append(this.m_remAddr.getHostAddress());
        str.append(":");
        str.append(this.m_remPort);
        this.setUniqueId(str.toString());
        this.setRemoteName(this.m_remAddr.getHostAddress());
        this.setLastAccess(System.currentTimeMillis());
    }

    public final int isType() {
        return this.m_type;
    }

    public final NetworkFileCache getFileCache() {
        if (this.m_fileCache == null) {
            this.m_fileCache = new NetworkFileCache(this.getUniqueId());
            NFSConfigSection config = this.getNFSServer().getNFSConfiguration();
            this.m_fileCache.setDebug(this.hasDebug(32));
            if (config.getNFSFileCacheIOTimer() > 0L) {
                this.m_fileCache.setIOTimer(config.getNFSFileCacheIOTimer());
            }
            if (config.getNFSFileCacheCloseTimer() > 0L) {
                this.m_fileCache.setCloseTimer(config.getNFSFileCacheCloseTimer());
            }
            this.m_fileCache.setRpcAuthenticator(config.getRpcAuthenticator());
        }
        return this.m_fileCache;
    }

    public final boolean hasAuthIdentifier() {
        return this.m_authIdentifier != null;
    }

    public final Object getAuthIdentifier() {
        return this.m_authIdentifier;
    }

    @Override
    public InetAddress getRemoteAddress() {
        return this.m_remAddr;
    }

    public final int getRemotePort() {
        return this.m_remPort;
    }

    public final long getLastAccess() {
        return this.m_lastAccess;
    }

    public final ClientInfo getNFSClientInformation() {
        return this.m_nfsClientInfo;
    }

    public final void setNFSClientInformation(ClientInfo cInfo) {
        this.m_nfsClientInfo = cInfo;
    }

    public final TreeConnection findConnection(int shareHash) {
        if (this.m_connections == null) {
            return null;
        }
        return this.m_connections.findConnection(shareHash);
    }

    public final void addConnection(TreeConnection tree) {
        if (this.m_connections == null) {
            this.m_connections = new TreeConnectionHash();
        }
        this.m_connections.addConnection(tree);
    }

    public final void removeConnection(TreeConnection tree) {
        if (this.m_connections == null) {
            return;
        }
        this.m_connections.deleteConnection(tree.getSharedDevice().getName());
    }

    public final void setAuthIdentifier(Object authIdent) {
        this.m_authIdentifier = authIdent;
    }

    public final void setLastAccess(long dateTime) {
        this.m_lastAccess = dateTime;
    }

    public final void setLastAccess() {
        this.m_lastAccess = System.currentTimeMillis();
    }

    @Override
    public void closeSession() {
        this.cleanupSession();
        this.getNFSServer().fireSessionClosed(this);
        super.closeSession();
    }

    protected final synchronized int allocateSearchSlot(SearchContext search) {
        int idx;
        if (this.m_search == null) {
            this.m_search = new SearchContext[32];
        }
        for (idx = 0; idx < this.m_search.length && this.m_search[idx] != null; ++idx) {
        }
        if (idx == this.m_search.length) {
            if (this.m_search.length >= 256) {
                return -1;
            }
            SearchContext[] newSearch = new SearchContext[this.m_search.length * 2];
            System.arraycopy(this.m_search, 0, newSearch, 0, this.m_search.length);
            this.m_search = newSearch;
        }
        if (search != null) {
            this.m_search[idx] = search;
        }
        ++this.m_searchCount;
        return idx;
    }

    protected final synchronized void deallocateSearchSlot(int ctxId) {
        if (this.m_search == null || ctxId >= this.m_search.length) {
            return;
        }
        if (this.m_search[ctxId] != null) {
            this.m_search[ctxId].closeSearch();
        }
        --this.m_searchCount;
        this.m_search[ctxId] = null;
    }

    public final NFSServer getNFSServer() {
        return (NFSServer)this.getServer();
    }

    protected final SearchContext getSearchContext(int srchId) {
        if (this.m_search == null || srchId >= this.m_search.length) {
            return null;
        }
        return this.m_search[srchId];
    }

    public final int getSearchCount() {
        return this.m_searchCount;
    }

    protected final void setSearchContext(int slot, SearchContext srch) {
        if (this.m_search == null || slot > this.m_search.length) {
            return;
        }
        this.m_search[slot] = srch;
    }

    protected final void cleanupSession() {
        if (this.hasDebug(1024)) {
            this.debugPrintln("NFS Cleanup session, searches=" + this.getSearchCount() + ", files=" + (this.m_fileCache != null ? this.m_fileCache.numberOfEntries() : 0) + ", treeConns=" + (this.m_connections != null ? this.m_connections.numberOfEntries() : 0));
        }
        if (this.m_search != null) {
            for (int idx = 0; idx < this.m_search.length; ++idx) {
                if (this.m_search[idx] == null) continue;
                this.deallocateSearchSlot(idx);
            }
            this.m_search = null;
            this.m_searchCount = 0;
        }
        if (this.m_fileCache != null) {
            this.m_fileCache.closeAllFiles();
        }
        if (this.m_connections != null && this.m_connections.numberOfEntries() > 0) {
            Enumeration<TreeConnection> conns = this.m_connections.enumerateConnections();
            while (conns.hasMoreElements()) {
                TreeConnection tree = conns.nextElement();
                tree.closeConnection(this);
                DeviceInterface devIface = tree.getInterface();
                if (devIface != null) {
                    devIface.treeClosed(this, tree);
                }
                this.m_connections = null;
            }
        }
    }

    @Override
    public boolean useCaseSensitiveSearch() {
        return true;
    }
}

