/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.oncrpc.nfs;

import org.filesys.debug.Debug;
import org.filesys.server.filesys.SearchContext;

public class SearchCache {
    public static final int MaximumSearches = 255;
    public static final long DefaultSearchTimeout = 30000L;
    private SearchEntry[] m_searches = new SearchEntry[255];
    private int m_lastIdx;
    private long m_searchTmo = 30000L;
    private boolean m_debug = true;

    public SearchCache() {
        new SearchExpiry(15000L);
    }

    public final boolean hasDebug() {
        return this.m_debug;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int allocateSearchId(SearchContext search) {
        SearchEntry[] searchEntryArray = this.m_searches;
        synchronized (this.m_searches) {
            for (int cnt = 0; cnt < 255; ++cnt) {
                if (this.m_lastIdx >= 255) {
                    this.m_lastIdx = 0;
                }
                if (this.m_searches[this.m_lastIdx] == null) {
                    SearchEntry entry;
                    this.m_searches[this.m_lastIdx] = entry = new SearchEntry(search);
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return this.m_lastIdx++;
                }
                ++this.m_lastIdx;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void releaseSearchId(int id) {
        if (id < 0 || id >= 255) {
            return;
        }
        SearchEntry[] searchEntryArray = this.m_searches;
        synchronized (this.m_searches) {
            this.m_searches[id] = null;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final SearchContext getSearch(int id) {
        if (id < 0 || id >= 255) {
            return null;
        }
        SearchEntry entry = null;
        SearchEntry[] searchEntryArray = this.m_searches;
        synchronized (this.m_searches) {
            entry = this.m_searches[id];
            // ** MonitorExit[var3_3] (shouldn't be in output)
            if (entry != null) {
                entry.updateTimeout();
                return entry.getSearch();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void dumpSearches() {
        SearchEntry[] searchEntryArray = this.m_searches;
        synchronized (this.m_searches) {
            for (int i = 0; i < this.m_searches.length; ++i) {
                if (this.m_searches[i] == null) continue;
                SearchEntry entry = this.m_searches[i];
                Debug.println("" + i + ": " + entry.getSearch().toString());
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    protected class SearchExpiry
    implements Runnable {
        private Thread m_thread;
        private long m_wakeup;

        public SearchExpiry(long wakeup) {
            this.m_wakeup = wakeup;
            this.m_thread = new Thread(this);
            this.m_thread.setDaemon(true);
            this.m_thread.setName("NFSSearchExpiry");
            this.m_thread.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                try {
                    Thread.sleep(this.m_wakeup);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                long timeNow = System.currentTimeMillis();
                SearchEntry[] searchEntryArray = SearchCache.this.m_searches;
                synchronized (searchEntryArray) {
                    for (int i = 0; i < SearchCache.this.m_searches.length; ++i) {
                        if (SearchCache.this.m_searches[i] == null || SearchCache.this.m_searches[i].getTimeout() >= timeNow) continue;
                        SearchEntry entry = SearchCache.this.m_searches[i];
                        ((SearchCache)SearchCache.this).m_searches[i] = null;
                        entry.getSearch().closeSearch();
                        if (!SearchCache.this.hasDebug()) continue;
                        Debug.println("NFSSearchExpiry: Closed search=" + entry.getSearch().getSearchString() + ", id=" + i);
                    }
                }
            }
        }
    }

    protected class SearchEntry {
        private SearchContext m_search;
        private long m_timeout;

        public SearchEntry(SearchContext search) {
            this.m_search = search;
            this.updateTimeout();
        }

        public final long getTimeout() {
            return this.m_timeout;
        }

        public final SearchContext getSearch() {
            return this.m_search;
        }

        public final void updateTimeout() {
            this.m_timeout = System.currentTimeMillis() + SearchCache.this.m_searchTmo;
        }
    }
}

