/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.server;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import org.filesys.server.ServerListener;
import org.filesys.server.SessionListener;
import org.filesys.server.SrvSession;
import org.filesys.server.auth.acl.AccessControlManager;
import org.filesys.server.config.GlobalConfigSection;
import org.filesys.server.config.SecurityConfigSection;
import org.filesys.server.config.ServerConfiguration;
import org.filesys.server.core.ShareMapper;
import org.filesys.server.core.ShareType;
import org.filesys.server.core.SharedDevice;
import org.filesys.server.core.SharedDeviceList;

public abstract class NetworkServer {
    protected static final int SHUTDOWN_TIMEOUT = 60000;
    private String m_protoName;
    private String m_version;
    private ServerConfiguration m_config;
    private GlobalConfigSection m_globalConfig;
    private SecurityConfigSection m_securityConfig;
    private boolean m_debug;
    private int m_debugFlags;
    private InetAddress[] m_ipAddr;
    private boolean m_shutdown = false;
    private boolean m_active = false;
    private boolean m_enabled;
    private Exception m_exception;
    private ServerListener m_listener;
    private List<SessionListener> m_sessListeners;

    public NetworkServer(String proto, ServerConfiguration config) {
        this.m_protoName = proto;
        this.m_config = config;
        this.m_securityConfig = (SecurityConfigSection)this.m_config.getConfigSection("Security");
        this.m_globalConfig = (GlobalConfigSection)this.m_config.getConfigSection("Global");
    }

    public final ServerConfiguration getConfiguration() {
        return this.m_config;
    }

    public final boolean hasAccessControlManager() {
        if (this.m_securityConfig != null) {
            return this.m_securityConfig.getAccessControlManager() != null;
        }
        return false;
    }

    public final AccessControlManager getAccessControlManager() {
        if (this.m_securityConfig != null) {
            return this.m_securityConfig.getAccessControlManager();
        }
        return null;
    }

    public final InetAddress[] getServerAddresses() {
        return this.m_ipAddr;
    }

    public final ShareMapper getShareMapper() {
        if (this.m_securityConfig != null) {
            return this.m_securityConfig.getShareMapper();
        }
        return null;
    }

    public final SharedDeviceList getShareList(String host, SrvSession sess) {
        if (this.m_securityConfig != null) {
            return this.m_securityConfig.getShareMapper().getShareList(host, sess, false);
        }
        return null;
    }

    public final SharedDeviceList getFullShareList(String host, SrvSession sess) {
        if (this.m_securityConfig != null) {
            return this.m_securityConfig.getShareMapper().getShareList(host, sess, true);
        }
        return null;
    }

    public final GlobalConfigSection getGlobalConfiguration() {
        if (this.m_globalConfig == null) {
            this.m_globalConfig = (GlobalConfigSection)this.m_config.getConfigSection("Global");
        }
        return this.m_globalConfig;
    }

    public final SecurityConfigSection getSecurityConfiguration() {
        if (this.m_securityConfig == null) {
            this.m_securityConfig = (SecurityConfigSection)this.m_config.getConfigSection("Security");
        }
        return this.m_securityConfig;
    }

    public final SharedDevice findShare(String host, String name, ShareType typ, SrvSession sess, boolean create) throws Exception {
        if (this.m_securityConfig != null) {
            return this.m_securityConfig.getShareMapper().findShare(host, name, typ, sess, create);
        }
        return null;
    }

    public final boolean isActive() {
        return this.m_active;
    }

    public final boolean isEnabled() {
        return this.m_enabled;
    }

    public final String isVersion() {
        return this.m_version;
    }

    public final boolean hasException() {
        return this.m_exception != null;
    }

    public final Exception getException() {
        return this.m_exception;
    }

    public final void clearException() {
        this.m_exception = null;
    }

    public final String getProtocolName() {
        return this.m_protoName;
    }

    public final boolean hasDebug() {
        return this.m_debug;
    }

    public final boolean hasDebugFlag(int flg) {
        return (this.m_debugFlags & flg) != 0;
    }

    public final boolean hasShutdown() {
        return this.m_shutdown;
    }

    protected void setActive(boolean active) {
        this.m_active = active;
    }

    protected void setEnabled(boolean ena) {
        this.m_enabled = ena;
    }

    protected final void setException(Exception ex) {
        this.m_exception = ex;
    }

    protected final void setServerAddresses(InetAddress[] addrs) {
        this.m_ipAddr = addrs;
    }

    protected final void setVersion(String ver) {
        this.m_version = ver;
    }

    protected final void setDebug(boolean dbg) {
        this.m_debug = dbg;
    }

    protected final void setDebugFlags(int flags) {
        this.m_debugFlags = flags;
        this.setDebug(flags != 0);
    }

    protected final void setShutdown(boolean ena) {
        this.m_shutdown = ena;
    }

    public final void addServerListener(ServerListener l) {
        this.m_listener = l;
    }

    public final void removeServerListener(ServerListener l) {
        if (this.m_listener == l) {
            this.m_listener = null;
        }
    }

    public final void addSessionListener(SessionListener l) {
        if (this.m_sessListeners == null) {
            this.m_sessListeners = new ArrayList<SessionListener>();
        }
        this.m_sessListeners.add(l);
    }

    public final void removeSessionListener(SessionListener l) {
        if (this.m_sessListeners == null) {
            return;
        }
        this.m_sessListeners.remove(l);
    }

    protected final void fireServerEvent(int event) {
        if (this.m_listener != null) {
            try {
                this.m_listener.serverStatusEvent(this, event);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public abstract void startServer();

    public abstract void shutdownServer(boolean var1);

    protected final void fireSessionClosedEvent(SrvSession sess) {
        if (this.m_sessListeners == null || this.m_sessListeners.size() == 0) {
            return;
        }
        for (int i = 0; i < this.m_sessListeners.size(); ++i) {
            try {
                SessionListener sessListener = this.m_sessListeners.get(i);
                sessListener.sessionClosed(sess);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected final void fireSessionLoggedOnEvent(SrvSession sess) {
        if (this.m_sessListeners == null || this.m_sessListeners.size() == 0) {
            return;
        }
        for (int i = 0; i < this.m_sessListeners.size(); ++i) {
            try {
                SessionListener sessListener = this.m_sessListeners.get(i);
                sessListener.sessionLoggedOn(sess);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected final void fireSessionOpenEvent(SrvSession sess) {
        if (this.m_sessListeners == null || this.m_sessListeners.size() == 0) {
            return;
        }
        for (int i = 0; i < this.m_sessListeners.size(); ++i) {
            try {
                SessionListener sessListener = this.m_sessListeners.get(i);
                sessListener.sessionCreated(sess);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

