/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.server;

import java.io.IOException;
import java.net.InetAddress;
import org.filesys.server.NetworkServer;
import org.filesys.server.SessionHandlerInterface;

public abstract class SessionHandlerBase
implements SessionHandlerInterface {
    public static final int ListenBacklog = 100;
    private NetworkServer m_server;
    private int m_port;
    private InetAddress m_bindAddr;
    private int m_backLog = 100;
    private int m_sessId;
    private String m_name;
    private String m_protocol;
    private boolean m_shutdown;
    private boolean m_debug;

    public SessionHandlerBase(String name, String protocol, NetworkServer server, InetAddress addr, int port) {
        this.m_name = name;
        this.m_protocol = protocol;
        this.m_server = server;
        this.m_bindAddr = addr;
        this.m_port = port;
    }

    public final NetworkServer getServer() {
        return this.m_server;
    }

    @Override
    public final String getHandlerName() {
        return this.m_name;
    }

    public final String getProtocolName() {
        return this.m_protocol;
    }

    public final boolean hasBindAddress() {
        return this.m_bindAddr != null;
    }

    public final InetAddress getBindAddress() {
        return this.m_bindAddr;
    }

    public final int getPort() {
        return this.m_port;
    }

    public final int getListenBacklog() {
        return this.m_backLog;
    }

    public final boolean hasDebug() {
        return this.m_debug;
    }

    protected final void clearShutdown() {
        this.m_shutdown = false;
    }

    protected final boolean hasShutdown() {
        return this.m_shutdown;
    }

    protected synchronized int getNextSessionId() {
        return this.m_sessId++;
    }

    public final void setDebug(boolean dbg) {
        this.m_debug = dbg;
    }

    protected final void setPort(int port) {
        this.m_port = port;
    }

    protected final void setShutdown(boolean shut) {
        this.m_shutdown = shut;
    }

    @Override
    public abstract void initializeSessionHandler(NetworkServer var1) throws IOException;

    @Override
    public abstract void closeSessionHandler(NetworkServer var1);

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("[");
        str.append(this.getProtocolName());
        str.append(",");
        str.append(this.getHandlerName());
        str.append(",");
        if (this.hasBindAddress()) {
            str.append(this.getBindAddress().getHostAddress());
        } else {
            str.append("ALL");
        }
        str.append(":");
        str.append(this.getPort());
        str.append("]");
        return str.toString();
    }
}

