/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.server;

import java.net.InetAddress;
import org.filesys.debug.Debug;
import org.filesys.server.NetworkServer;
import org.filesys.server.RequestPostProcessor;
import org.filesys.server.auth.AuthContext;
import org.filesys.server.auth.ClientInfo;
import org.filesys.server.core.SharedDevice;
import org.filesys.server.core.SharedDeviceList;
import org.filesys.server.filesys.TransactionalFilesystemInterface;

public abstract class SrvSession {
    private NetworkServer m_server;
    private int m_sessId;
    private String m_uniqueId;
    private int m_processId = -1;
    private boolean m_loggedOn;
    private boolean m_persistentSess;
    private long m_disconnectTime;
    private static ThreadLocal<ClientInfo> m_clientInfo = new ThreadLocal();
    private AuthContext m_authContext;
    private int m_debug;
    private String m_dbgPrefix;
    private SharedDeviceList m_dynamicShares;
    private boolean m_shutdown;
    private String m_protocol;
    private String m_remoteName;
    private static ThreadLocal<Object> m_tx = new ThreadLocal();
    private static ThreadLocal<TransactionalFilesystemInterface> m_txInterface = new ThreadLocal();
    private long m_lastIO;
    private RequestPostProcessor m_reqPostProcessor;
    private Object driverState;

    public SrvSession(int sessId, NetworkServer srv, String proto, String remoteName) {
        this.m_sessId = sessId;
        this.m_server = srv;
        this.setProtocolName(proto);
        this.setRemoteName(remoteName);
    }

    public final void debugPrint(String str) {
        Debug.print(str);
    }

    public final void debugPrintln(String str) {
        Debug.print(this.m_dbgPrefix);
        Debug.println(str);
    }

    public final void debugPrintln(Exception ex) {
        Debug.println(ex);
    }

    public final boolean hasAuthenticationContext() {
        return this.m_authContext != null;
    }

    public final AuthContext getAuthenticationContext() {
        return this.m_authContext;
    }

    public final void addDynamicShare(SharedDevice shrDev) {
        if (this.m_dynamicShares == null) {
            this.m_dynamicShares = new SharedDeviceList();
        }
        this.m_dynamicShares.addShare(shrDev);
    }

    public final boolean hasDynamicShares() {
        return this.m_dynamicShares != null;
    }

    public final SharedDeviceList getDynamicShareList() {
        return this.m_dynamicShares;
    }

    public final int getProcessId() {
        return this.m_processId;
    }

    public abstract InetAddress getRemoteAddress();

    public final int getSessionId() {
        return this.m_sessId;
    }

    public final NetworkServer getServer() {
        return this.m_server;
    }

    public final boolean hasClientInformation() {
        return m_clientInfo.get() != null;
    }

    public final ClientInfo getClientInformation() {
        return m_clientInfo.get();
    }

    public final boolean hasProtocolName() {
        return this.m_protocol != null;
    }

    public final String getProtocolName() {
        return this.m_protocol;
    }

    public final boolean hasRemoteName() {
        return this.m_remoteName != null;
    }

    public final String getRemoteName() {
        return this.m_remoteName;
    }

    public final boolean isLoggedOn() {
        return this.m_loggedOn;
    }

    public final boolean isPersistentSession() {
        return this.m_persistentSess;
    }

    public final boolean isShutdown() {
        return this.m_shutdown;
    }

    public final String getUniqueId() {
        return this.m_uniqueId;
    }

    public final boolean hasDebug(int dbgFlag) {
        return (this.m_debug & dbgFlag) != 0;
    }

    public final long getLastIOTime() {
        return this.m_lastIO;
    }

    public final boolean hasPostProcessorRequests() {
        return RequestPostProcessor.hasPostProcessor();
    }

    public final RequestPostProcessor getNextPostProcessor() {
        return RequestPostProcessor.dequeuePostProcessor();
    }

    public abstract boolean useCaseSensitiveSearch();

    public final void setAuthenticationContext(AuthContext ctx) {
        this.m_authContext = ctx;
    }

    public final void setClientInformation(ClientInfo client) {
        m_clientInfo.set(client);
    }

    public final void setDebug(int flgs) {
        this.m_debug = flgs;
    }

    public final void setDebugPrefix(String prefix) {
        this.m_dbgPrefix = prefix;
    }

    public final void setLoggedOn(boolean loggedOn) {
        this.m_loggedOn = loggedOn;
    }

    public final void setPersistentSession(boolean persistSess) {
        this.m_persistentSess = persistSess;
    }

    public final boolean isDisconnectedSession() {
        return this.m_disconnectTime != 0L;
    }

    public final long getDisconnectedAt() {
        return this.m_disconnectTime;
    }

    public final void setDisconnectedAt(long disconnectTime) {
        this.m_disconnectTime = disconnectTime;
    }

    public final void clearDisconnectedAt() {
        this.m_disconnectTime = 0L;
    }

    public final void setProcessId(int id) {
        this.m_processId = id;
    }

    public final void setProtocolName(String name) {
        this.m_protocol = name;
    }

    public final void setRemoteName(String name) {
        this.m_remoteName = name;
    }

    public final void setSessionId(int id) {
        this.m_sessId = id;
    }

    public final void setUniqueId(String unid) {
        this.m_uniqueId = unid;
    }

    public final void setLastIOTime(long ioTime) {
        this.m_lastIO = ioTime;
    }

    protected final void setShutdown(boolean flg) {
        this.m_shutdown = flg;
    }

    public void closeSession() {
        if (this.hasDynamicShares()) {
            this.getServer().getShareMapper().deleteShares(this);
        }
    }

    public final void initializeTransactionObject() {
        if (m_tx == null) {
            m_tx = new ThreadLocal();
        }
        if (m_txInterface == null) {
            m_txInterface = new ThreadLocal();
        }
    }

    public final ThreadLocal<Object> getTransactionObject() {
        return m_tx;
    }

    public final void setTransaction(Object tx, TransactionalFilesystemInterface txIface) {
        m_tx.set(tx);
        m_txInterface.set(txIface);
    }

    public final void setTransaction(TransactionalFilesystemInterface txIface) {
        m_txInterface.set(txIface);
    }

    public final void clearTransaction() {
        m_tx.set(null);
        m_txInterface.set(null);
    }

    public final void endTransaction() {
        if (m_txInterface != null && m_txInterface.get() != null && m_tx != null) {
            m_txInterface.get().endTransaction(this, m_tx.get());
        }
    }

    public final boolean hasTransaction() {
        if (m_tx == null) {
            return false;
        }
        return m_tx.get() != null;
    }

    public boolean isPseudoFilesEnabled() {
        return false;
    }

    public Object getDriverState() {
        return this.driverState;
    }

    public void setDriverState(Object driverState) {
        this.driverState = driverState;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("[Session id=");
        str.append(this.getSessionId());
        str.append(",unique=");
        str.append(this.getUniqueId());
        str.append(",proto=");
        str.append(this.getProtocolName());
        if (this.isPersistentSession()) {
            str.append(" Persistent");
        }
        if (this.isDisconnectedSession()) {
            str.append(" Disconnected");
        }
        str.append("]");
        return str.toString();
    }
}

