/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.server;

import java.util.LinkedList;
import org.filesys.server.SrvSession;

public class SrvSessionQueue {
    private LinkedList<SrvSession> m_queue = new LinkedList();

    public final synchronized int numberOfSessions() {
        return this.m_queue.size();
    }

    public final synchronized void addSession(SrvSession sess) {
        this.m_queue.add(sess);
        this.notify();
    }

    public final synchronized SrvSession removeSession() throws InterruptedException {
        this.waitWhileEmpty();
        return this.m_queue.removeFirst();
    }

    public final synchronized SrvSession removeSessionNoWait() {
        SrvSession sess = null;
        if (this.m_queue.size() > 0) {
            sess = this.m_queue.removeFirst();
        }
        return sess;
    }

    public final synchronized void waitWhileEmpty() throws InterruptedException {
        while (this.m_queue.size() == 0) {
            this.wait();
        }
    }

    public final synchronized void waitUntilEmpty() throws InterruptedException {
        while (this.m_queue.size() != 0) {
            this.wait();
        }
    }
}

