/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.server.auth;

import org.filesys.server.auth.ClientInfoFactory;
import org.filesys.server.auth.DefaultClientInfoFactory;

public class ClientInfo {
    private static ClientInfoFactory m_factory = new DefaultClientInfoFactory();
    private String m_user;
    private byte[] m_password;
    private byte[] m_ansiPwd;
    private LogonType m_logonType = LogonType.Unknown;
    private String m_domain;
    private String m_opsys;
    private String m_ipAddr;
    private int m_pid = -1;
    private int m_gid = -1;
    private int m_uid = -1;
    private int[] m_groups;
    private int m_nfsAuthType = -1;
    private String m_loggedOnName;

    protected ClientInfo(String user, byte[] pwd) {
        this.setUserName(user);
        this.setPassword(pwd);
    }

    public final String getDomain() {
        return this.m_domain;
    }

    public final String getOperatingSystem() {
        return this.m_opsys;
    }

    public final byte[] getPassword() {
        return this.m_password;
    }

    public final String getPasswordAsString() {
        if (this.m_password != null) {
            return new String(this.m_password);
        }
        return null;
    }

    public final boolean hasANSIPassword() {
        return this.m_ansiPwd != null;
    }

    public final byte[] getANSIPassword() {
        return this.m_ansiPwd;
    }

    public final String getANSIPasswordAsString() {
        if (this.m_ansiPwd != null) {
            return new String(this.m_ansiPwd);
        }
        return null;
    }

    public final String getUserName() {
        return this.m_user;
    }

    public final LogonType getLogonType() {
        return this.m_logonType;
    }

    public final String getLogonTypeString() {
        return this.m_logonType.name();
    }

    public final boolean isGuest() {
        return this.m_logonType == LogonType.Guest;
    }

    public final boolean isNullSession() {
        return this.m_logonType == LogonType.Null;
    }

    public final boolean isAdministrator() {
        return this.m_logonType == LogonType.Administrator;
    }

    public final boolean hasClientAddress() {
        return this.m_ipAddr != null;
    }

    public final String getClientAddress() {
        return this.m_ipAddr;
    }

    public final int getGid() {
        return this.m_gid;
    }

    public final int getUid() {
        return this.m_uid;
    }

    public final boolean hasGroupsList() {
        return this.m_groups != null;
    }

    public final int[] getGroupsList() {
        return this.m_groups;
    }

    public final int getNFSAuthenticationType() {
        return this.m_nfsAuthType;
    }

    public final int getProcessId() {
        return this.m_pid;
    }

    public final boolean hasLoggedOnName() {
        return this.m_loggedOnName != null;
    }

    public final String getLoggedOnName() {
        return this.m_loggedOnName;
    }

    public final void setProcessId(int pid) {
        this.m_pid = pid;
    }

    public final void setDomain(String domain) {
        this.m_domain = domain;
    }

    public final void setOperatingSystem(String opsys) {
        this.m_opsys = opsys;
    }

    public final void setPassword(byte[] pwd) {
        this.m_password = pwd;
    }

    public final void setANSIPassword(byte[] pwd) {
        this.m_ansiPwd = pwd;
    }

    public final void setPassword(String pwd) {
        this.m_password = (byte[])(pwd != null ? pwd.getBytes() : null);
    }

    public final void setUserName(String user) {
        this.m_user = user;
    }

    public final void setLogonType(LogonType logonType) {
        this.m_logonType = logonType;
    }

    public final void setGuest(boolean guest) {
        if (guest) {
            this.setLogonType(LogonType.Guest);
        } else if (this.getLogonType() == LogonType.Unknown) {
            this.setLogonType(LogonType.Normal);
        }
    }

    public final void setClientAddress(String addr) {
        this.m_ipAddr = addr;
    }

    public final void setGid(int gid) {
        this.m_gid = gid;
    }

    public final void setUid(int uid) {
        this.m_uid = uid;
    }

    public final void setGroupsList(int[] groups) {
        this.m_groups = groups;
    }

    public final void setNFSAuthenticationType(int type) {
        this.m_nfsAuthType = type;
    }

    public final void setLoggedOnName(String fullName) {
        this.m_loggedOnName = fullName;
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("[");
        str.append(this.getUserName());
        str.append(":");
        str.append(this.getPassword());
        str.append(",");
        str.append(this.getDomain());
        str.append(",");
        str.append(this.getOperatingSystem());
        if (this.hasClientAddress()) {
            str.append(",");
            str.append(this.getClientAddress());
        }
        str.append(",");
        str.append(this.getLogonTypeString());
        if (this.isGuest()) {
            str.append(",Guest");
        }
        if (this.hasLoggedOnName()) {
            str.append(", loggedOnAs=");
            str.append(this.getLoggedOnName());
        }
        str.append("]");
        return str.toString();
    }

    public static final ClientInfoFactory getFactory() {
        return m_factory;
    }

    public static final void setFactory(ClientInfoFactory factory) {
        m_factory = factory;
    }

    public static final ClientInfo createInfo(String user, byte[] password) {
        return m_factory.createInfo(user, password);
    }

    public static enum LogonType {
        Normal,
        Guest,
        Null,
        Administrator,
        Unknown;

    }
}

