/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.server.auth;

import java.net.InetAddress;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Random;
import org.filesys.debug.Debug;
import org.filesys.server.SrvSession;
import org.filesys.server.auth.AuthContext;
import org.filesys.server.auth.ClientInfo;
import org.filesys.server.auth.ISMBAuthenticator;
import org.filesys.server.auth.NTLanManAuthContext;
import org.filesys.server.auth.PasswordEncryptor;
import org.filesys.server.auth.SecurityBlob;
import org.filesys.server.auth.UserAccount;
import org.filesys.server.auth.passthru.DomainMapping;
import org.filesys.server.config.InvalidConfigurationException;
import org.filesys.server.config.SecurityConfigSection;
import org.filesys.server.config.ServerConfiguration;
import org.filesys.server.config.ServerConfigurationAccessor;
import org.filesys.server.core.NoPooledMemoryException;
import org.filesys.server.core.SharedDevice;
import org.filesys.smb.DialectSelector;
import org.filesys.smb.server.SMBConfigSection;
import org.filesys.smb.server.SMBSrvException;
import org.filesys.smb.server.SMBSrvPacket;
import org.filesys.smb.server.SMBSrvSession;
import org.filesys.smb.server.SMBV1Parser;
import org.filesys.smb.server.VirtualCircuit;
import org.filesys.util.DataPacker;
import org.filesys.util.HexDump;
import org.filesys.util.IPAddress;
import org.springframework.extensions.config.ConfigElement;

public abstract class SMBAuthenticator
implements ISMBAuthenticator {
    protected static final String GUEST_USERNAME = "guest";
    private DialectSelector m_dialects;
    private int m_securityMode = 3;
    private PasswordEncryptor m_encryptor = new PasswordEncryptor();
    private ISMBAuthenticator.AuthMode m_accessMode = ISMBAuthenticator.AuthMode.USER;
    private boolean m_extendedSecurity;
    private boolean m_allowGuest;
    private boolean m_mapToGuest;
    private String m_guestUserName = "guest";
    protected Random m_random = new Random(System.currentTimeMillis());
    protected ServerConfigurationAccessor m_config;
    private boolean m_sessCleanup = true;
    private boolean m_debug;

    public void setDebug(boolean debug) {
        this.m_debug = debug;
    }

    public void setConfig(ServerConfigurationAccessor config) {
        this.m_config = config;
    }

    @Override
    public ISMBAuthenticator.ShareStatus authenticateShareConnect(ClientInfo client, SharedDevice share, String sharePwd, SrvSession sess) {
        return ISMBAuthenticator.ShareStatus.WRITEABLE;
    }

    @Override
    public ISMBAuthenticator.AuthStatus authenticateUser(ClientInfo client, SrvSession sess, ISMBAuthenticator.PasswordAlgorithm alg) {
        UserAccount userAcc = this.getUserDetails(client.getUserName());
        if (userAcc != null) {
            boolean authSts = false;
            if (client.getPassword() != null) {
                authSts = this.validatePassword(userAcc, client, sess.getAuthenticationContext(), alg);
            } else if (client.hasANSIPassword()) {
                authSts = this.validatePassword(userAcc, client, sess.getAuthenticationContext(), ISMBAuthenticator.PasswordAlgorithm.LANMAN);
            }
            return authSts ? ISMBAuthenticator.AuthStatus.AUTHENTICATED : ISMBAuthenticator.AuthStatus.BAD_PASSWORD;
        }
        if (client.isNullSession() && sess instanceof SMBSrvSession) {
            return ISMBAuthenticator.AuthStatus.AUTHENTICATED;
        }
        return this.allowGuest() ? ISMBAuthenticator.AuthStatus.GUEST_LOGON : ISMBAuthenticator.AuthStatus.DISALLOW;
    }

    public void initialize() throws InvalidConfigurationException {
        if (this.m_config == null) {
            throw new InvalidConfigurationException("server configuration accessor not set");
        }
        this.m_dialects = new DialectSelector();
        this.m_dialects.enableUpTo(8);
    }

    public void initialize(ServerConfiguration config, ConfigElement params) throws InvalidConfigurationException {
        if (params.getChild("Debug") != null) {
            this.setDebug(true);
        }
        this.setConfig(config);
        this.initialize();
    }

    protected final byte[] generateEncryptedPassword(String plainPwd, byte[] encryptKey, ISMBAuthenticator.PasswordAlgorithm alg, String userName, String domain) {
        int passAlg = 0;
        switch (alg) {
            case LANMAN: {
                passAlg = 0;
                break;
            }
            case NTLM1: {
                passAlg = 1;
                break;
            }
            case NTLM2: {
                passAlg = 2;
            }
        }
        byte[] encPwd = null;
        try {
            encPwd = this.m_encryptor.generateEncryptedPassword(plainPwd, encryptKey, passAlg, userName, domain);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
        }
        catch (InvalidKeyException invalidKeyException) {
            // empty catch block
        }
        return encPwd;
    }

    @Override
    public final ISMBAuthenticator.AuthMode getAccessMode() {
        return this.m_accessMode;
    }

    @Override
    public final boolean hasExtendedSecurity() {
        return this.m_extendedSecurity;
    }

    @Override
    public AuthContext getAuthContext(SMBSrvSession sess) {
        AuthContext authCtx = null;
        if (sess.hasAuthenticationContext() && sess.getAuthenticationContext() instanceof NTLanManAuthContext) {
            authCtx = sess.getAuthenticationContext();
        } else {
            authCtx = new NTLanManAuthContext();
            sess.setAuthenticationContext(authCtx);
        }
        return authCtx;
    }

    public final DialectSelector getEnabledDialects() {
        return this.m_dialects;
    }

    @Override
    public final int getSecurityMode() {
        return this.m_securityMode;
    }

    public final SMBConfigSection getSMBConfig() {
        return (SMBConfigSection)this.m_config.getConfigSection("SMB");
    }

    public final SecurityConfigSection getSecurityConfig() {
        return (SecurityConfigSection)this.m_config.getConfigSection("Security");
    }

    public final boolean hasDebug() {
        return this.m_debug;
    }

    @Override
    public void processSessionSetup(SMBSrvSession sess, SMBSrvPacket reqPkt) throws SMBSrvException {
        int discCnt;
        VirtualCircuit vc;
        int uid;
        SMBV1Parser parser = (SMBV1Parser)reqPkt.getParser();
        if (!parser.checkPacketIsValid(13, 0)) {
            throw new SMBSrvException(-1073741811, 2, 1);
        }
        int maxBufSize = parser.getParameter(2);
        int maxMpx = parser.getParameter(3);
        int vcNum = parser.getParameter(4);
        int ascPwdLen = parser.getParameter(7);
        int uniPwdLen = parser.getParameter(8);
        int capabs = parser.getParameterLong(11);
        byte[] buf = parser.getBuffer();
        boolean isUni = parser.isUnicode();
        byte[] ascPwd = parser.unpackBytes(ascPwdLen);
        byte[] uniPwd = parser.unpackBytes(uniPwdLen);
        String user = parser.unpackString(isUni);
        if (user == null) {
            throw new SMBSrvException(-1073741811, 2, 1);
        }
        String domain = "";
        if (parser.hasMoreData() && (domain = parser.unpackString(isUni)) == null) {
            throw new SMBSrvException(-1073741811, 2, 1);
        }
        String clientOS = "";
        if (parser.hasMoreData() && (clientOS = parser.unpackString(isUni)) == null) {
            throw new SMBSrvException(-1073741811, 2, 1);
        }
        if (sess.hasDebug(32)) {
            Debug.println("[SMB] NT Session setup from user=" + user + ", password=" + (uniPwd != null ? HexDump.hexString(uniPwd) : "none") + ", ANSIpwd=" + (ascPwd != null ? HexDump.hexString(ascPwd) : "none") + ", domain=" + domain + ", os=" + clientOS + ", VC=" + vcNum + ", maxBuf=" + maxBufSize + ", maxMpx=" + maxMpx + ", authCtx=" + sess.getAuthenticationContext());
            Debug.println("[SMB]  MID=" + parser.getMultiplexId() + ", UID=" + parser.getUserId() + ", PID=" + parser.getProcessId());
        }
        sess.setClientMaximumBufferSize(maxBufSize != 0 ? maxBufSize : 65540);
        sess.setClientMaximumMultiplex(maxMpx);
        sess.setClientCapabilities(capabs);
        ClientInfo client = ClientInfo.getFactory().createInfo(user, uniPwd);
        client.setANSIPassword(ascPwd);
        client.setDomain(domain);
        client.setOperatingSystem(clientOS);
        if (sess.hasRemoteAddress()) {
            client.setClientAddress(sess.getRemoteAddress().getHostAddress());
        }
        if (user.length() == 0 && domain.length() == 0 && uniPwdLen == 0 && ascPwdLen == 1) {
            client.setLogonType(ClientInfo.LogonType.Null);
        }
        boolean isGuest = false;
        ISMBAuthenticator.AuthStatus sts = this.authenticateUser(client, sess, ISMBAuthenticator.PasswordAlgorithm.NTLM1);
        if (sts.intValue() > 0 && sts == ISMBAuthenticator.AuthStatus.GUEST_LOGON) {
            isGuest = true;
            if (sess.hasDebug(32)) {
                Debug.println("[SMB] User " + user + ", logged on as guest");
            }
        } else {
            if (sts != ISMBAuthenticator.AuthStatus.AUTHENTICATED) {
                if (sess.hasDebug(32)) {
                    Debug.println("[SMB] User " + user + ", access denied");
                }
                throw new SMBSrvException(-1073741715, 1, 5);
            }
            if (sess.hasDebug(32)) {
                Debug.println("[SMB] User " + user + " logged on " + (client != null ? " (type " + client.getLogonTypeString() + ")" : ""));
            }
        }
        if ((uid = sess.addVirtualCircuit(vc = new VirtualCircuit(vcNum, client))) == -1) {
            if (sess.hasDebug(32)) {
                Debug.println("[SMB] Failed to allocate UID for virtual circuit, " + vc);
            }
            throw new SMBSrvException(-1073741715, 1, 5);
        }
        if (sess.hasDebug(32)) {
            Debug.println("[SMB] Allocated UID=" + uid + " for VC=" + vc);
        }
        if (!client.isNullSession()) {
            client.setGuest(isGuest);
        }
        sess.setLoggedOn(true);
        if (vcNum == 0 && this.hasSessionCleanup() && (discCnt = sess.disconnectClientSessions()) > 0 && sess.hasDebug(32)) {
            Debug.println("[SMB] Disconnected " + discCnt + " existing sessions from client, sess=" + sess);
        }
        SMBSrvPacket respPkt = reqPkt;
        if (parser.hasAndXCommand()) {
            try {
                respPkt = sess.getPacketPool().allocatePacket(reqPkt.getLength(), reqPkt);
                respPkt.setParser(SMBSrvPacket.Version.V1);
                parser = (SMBV1Parser)respPkt.getParser();
            }
            catch (NoPooledMemoryException ex) {
                throw new SMBSrvException(2, 83);
            }
        }
        parser.setParameterCount(3);
        parser.setParameter(0, 0);
        parser.setParameter(1, 0);
        parser.setParameter(2, isGuest ? 1 : 0);
        parser.setByteCount(0);
        parser.setTreeId(0);
        parser.setUserId(uid);
        int flags = parser.getFlags();
        parser.setFlags(flags &= 0xFFFFFFF7);
        int flags2 = 1;
        if (isUni) {
            flags2 += 32768;
        }
        if (!this.hasExtendedSecurity()) {
            flags2 &= 0xFFFFF7FF;
        }
        parser.setFlags2(flags2);
        int pos = parser.getByteOffset();
        buf = parser.getBuffer();
        if (isUni) {
            pos = DataPacker.wordAlign(pos);
        }
        pos = DataPacker.putString("Java", buf, pos, true, isUni);
        pos = DataPacker.putString("Java File Server " + sess.getServer().isVersion(), buf, pos, true, isUni);
        pos = DataPacker.putString(sess.getSMBServer().getSMBConfiguration().getDomainName(), buf, pos, true, isUni);
        parser.setByteCount(pos - parser.getByteOffset());
        parser.setParameter(1, pos - 4);
    }

    @Override
    public ISMBAuthenticator.AuthStatus processSecurityBlob(SMBSrvSession sess, ClientInfo client, SecurityBlob secBlob) throws SMBSrvException {
        return ISMBAuthenticator.AuthStatus.UNSUPPORTED;
    }

    @Override
    public int getEncryptionKeyLength() {
        return 8;
    }

    @Override
    public int getServerCapabilities() {
        return 49788;
    }

    public final boolean allowGuest() {
        return this.m_allowGuest;
    }

    public final String getGuestUserName() {
        return this.m_guestUserName;
    }

    public final boolean mapUnknownUserToGuest() {
        return this.m_mapToGuest;
    }

    public final void setAllowGuest(boolean ena) {
        this.m_allowGuest = ena;
    }

    public final void setGuestUserName(String guest) {
        this.m_guestUserName = guest;
    }

    public final void setMapToGuest(boolean ena) {
        this.m_mapToGuest = ena;
    }

    protected final void setSecurityMode(int flg) {
        this.m_securityMode = flg;
    }

    protected final void setExtendedSecurity(boolean extSec) {
        this.m_extendedSecurity = extSec;
    }

    public final boolean hasSessionCleanup() {
        return this.m_sessCleanup;
    }

    public void setSessionCleanup(boolean ena) {
        this.m_sessCleanup = ena;
    }

    @Override
    public void closeAuthenticator() {
    }

    protected final boolean validatePassword(UserAccount user, ClientInfo client, AuthContext authCtx, ISMBAuthenticator.PasswordAlgorithm alg) {
        byte[] encryptKey = null;
        if (authCtx == null || !(authCtx instanceof NTLanManAuthContext)) {
            return false;
        }
        NTLanManAuthContext ntlmCtx = (NTLanManAuthContext)authCtx;
        encryptKey = ntlmCtx.getChallenge();
        byte[] encryptedPwd = null;
        encryptedPwd = alg == ISMBAuthenticator.PasswordAlgorithm.LANMAN ? client.getANSIPassword() : client.getPassword();
        byte[] encPwd = null;
        if (user.hasMD4Password() && alg != ISMBAuthenticator.PasswordAlgorithm.LANMAN) {
            try {
                if (alg == ISMBAuthenticator.PasswordAlgorithm.NTLM1) {
                    byte[] p21 = new byte[21];
                    System.arraycopy(user.getMD4Password(), 0, p21, 0, user.getMD4Password().length);
                    encPwd = this.getEncryptor().doNTLM1Encryption(p21, encryptKey);
                } else if (alg == ISMBAuthenticator.PasswordAlgorithm.NTLM2) {
                    encPwd = this.getEncryptor().doNTLM2Encryption(user.getMD4Password(), client.getUserName(), client.getDomain());
                }
            }
            catch (NoSuchAlgorithmException p21) {
            }
            catch (InvalidKeyException p21) {}
        } else {
            encPwd = this.generateEncryptedPassword(user.getPassword() != null ? user.getPassword() : "", encryptKey, alg, client.getUserName(), client.getDomain());
        }
        if (encPwd != null && encryptedPwd != null && encPwd.length == 24 && encryptedPwd.length == 24) {
            for (int i = 0; i < 24; ++i) {
                if (encPwd[i] == encryptedPwd[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected final byte[] convertPassword(String pwd) {
        StringBuffer p14str = new StringBuffer();
        p14str.append(pwd);
        if (p14str.length() > 14) {
            p14str.setLength(14);
        } else {
            while (p14str.length() < 14) {
                p14str.append('\u0000');
            }
        }
        return p14str.toString().getBytes();
    }

    protected final PasswordEncryptor getEncryptor() {
        return this.m_encryptor;
    }

    public final void setAccessMode(ISMBAuthenticator.AuthMode mode) {
        this.m_accessMode = mode;
    }

    protected void doGuestLogon(ClientInfo client, SrvSession sess) {
        client.setUserName(this.getGuestUserName());
        client.setGuest(true);
    }

    public final UserAccount getUserDetails(String user) {
        return this.getSecurityConfig().getUsersInterface().getUserAccount(user);
    }

    @Override
    public void setCurrentUser(ClientInfo client) {
    }

    protected final String mapClientAddressToDomain(InetAddress clientIP) {
        SecurityConfigSection securityConfig = this.getSecurityConfig();
        if (!securityConfig.hasDomainMappings()) {
            return null;
        }
        int clientAddr = IPAddress.asInteger(clientIP);
        for (DomainMapping domainMap : securityConfig.getDomainMappings()) {
            if (!domainMap.isMemberOfDomain(clientAddr)) continue;
            if (this.hasDebug()) {
                Debug.println("Mapped client IP " + clientIP + " to domain " + domainMap.getDomain());
            }
            return domainMap.getDomain();
        }
        if (this.hasDebug()) {
            Debug.println("Failed to map client IP " + clientIP + " to a domain");
        }
        return null;
    }

    @Override
    public boolean usingSPNEGO() {
        return false;
    }

    @Override
    public byte[] getNegTokenInit() {
        return null;
    }

    public String toString() {
        return this.getClass().getName() + ", mode=" + this.getAccessMode().name();
    }
}

