/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.server.auth;

import org.filesys.util.HexDump;
import org.filesys.util.StringList;

public class UserAccount {
    private String m_userName;
    private String m_password;
    private byte[] m_md4Password;
    private String m_realName;
    private String m_comment;
    private StringList m_shares;
    private boolean m_admin;
    private boolean m_guest;
    private String m_homeDir;
    private String m_mappedName;

    public UserAccount() {
    }

    public UserAccount(String user, String pwd) {
        this.setUserName(user);
        this.setPassword(pwd);
    }

    public final void addShare(String shr) {
        if (this.m_shares == null) {
            this.m_shares = new StringList();
        }
        this.m_shares.addString(shr);
    }

    public final boolean allowsShare(String shr) {
        if (this.m_shares == null) {
            return true;
        }
        return this.m_shares.containsString(shr);
    }

    public final boolean hasHomeDirectory() {
        return this.m_homeDir != null;
    }

    public final String getHomeDirectory() {
        return this.m_homeDir;
    }

    public final String getPassword() {
        return this.m_password;
    }

    public final boolean hasMD4Password() {
        return this.m_md4Password != null;
    }

    public final byte[] getMD4Password() {
        return this.m_md4Password;
    }

    public final String getUserName() {
        return this.m_userName;
    }

    public final String getRealName() {
        return this.m_realName;
    }

    public final String getComment() {
        return this.m_comment;
    }

    public final boolean hasMappedName() {
        return this.m_mappedName != null;
    }

    public final String getMappedName() {
        return this.m_mappedName;
    }

    public final boolean hasShare(String shr) {
        return this.m_shares == null || this.m_shares.containsString(shr);
    }

    public final boolean hasShareRestrictions() {
        return this.m_shares != null;
    }

    public final StringList getShareList() {
        return this.m_shares;
    }

    public final boolean isAdministrator() {
        return this.m_admin;
    }

    public final boolean isGuest() {
        return this.m_guest;
    }

    public final void removeAllShares() {
        this.m_shares = null;
    }

    public final void removeShare(String shr) {
        if (this.m_shares != null) {
            this.m_shares.removeString(shr);
            if (this.m_shares.numberOfStrings() == 0) {
                this.m_shares = null;
            }
        }
    }

    public final void setAdministrator(boolean admin) {
        this.m_admin = admin;
    }

    public final void setGuest(boolean guest) {
        this.m_guest = guest;
    }

    public final void setHomeDirectory(String home) {
        this.m_homeDir = home;
    }

    public final void setPassword(String pwd) {
        this.m_password = pwd;
    }

    public final void setMD4Password(byte[] md4Pwd) {
        this.m_md4Password = md4Pwd;
    }

    public final void setUserName(String user) {
        this.m_userName = user;
    }

    public final void setRealName(String name) {
        this.m_realName = name;
    }

    public final void setComment(String comment) {
        this.m_comment = comment;
    }

    public final void setMappedName(String mappedName) {
        this.m_mappedName = mappedName;
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("[");
        str.append(this.getUserName());
        str.append(":");
        str.append(this.getPassword());
        if (this.hasMD4Password()) {
            str.append(",MD4=");
            str.append(HexDump.hexString(this.getMD4Password()));
        }
        if (this.isAdministrator()) {
            str.append(" (ADMIN)");
        }
        if (this.isGuest()) {
            str.append(" (GUEST)");
        }
        str.append(",Real=");
        str.append(this.getRealName());
        if (this.hasMappedName()) {
            str.append(", mapped=");
            str.append(this.getMappedName());
        }
        str.append(",Comment=");
        str.append(this.getComment());
        str.append(",Allow=");
        if (this.m_shares == null) {
            str.append("<ALL>");
        } else {
            str.append(this.m_shares);
        }
        str.append("]");
        str.append(",Home=");
        if (this.hasHomeDirectory()) {
            str.append(this.getHomeDirectory());
        } else {
            str.append("None");
        }
        return str.toString();
    }
}

