/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.server.auth.acl;

import org.filesys.server.auth.acl.ACLParseException;
import org.filesys.server.auth.acl.AccessControl;
import org.filesys.server.auth.acl.AccessControlParser;
import org.filesys.server.auth.acl.IpAddressAccessControl;
import org.filesys.util.IPAddress;
import org.springframework.extensions.config.ConfigElement;

public class IpAddressAccessControlParser
extends AccessControlParser {
    @Override
    public String getType() {
        return "address";
    }

    @Override
    public AccessControl createAccessControl(ConfigElement params) throws ACLParseException {
        int access = this.parseAccessType(params);
        String val = params.getAttribute("ip");
        if (val != null) {
            if (val.length() == 0 || !IPAddress.isNumericAddress(val)) {
                throw new ACLParseException("Invalid IP address, " + val);
            }
            if (params.getAttributeCount() != 2) {
                throw new ACLParseException("Invalid parameter(s) specified for address");
            }
            return new IpAddressAccessControl(val, null, this.getType(), access);
        }
        val = params.getAttribute("subnet");
        if (val != null) {
            String maskVal = params.getAttribute("mask");
            if (maskVal.length() == 0 || maskVal == null) {
                throw new ACLParseException("Invalid subnet/mask parameter");
            }
            if (!IPAddress.isNumericAddress(val)) {
                throw new ACLParseException("Invalid subnet parameter, " + val);
            }
            if (!IPAddress.isNumericAddress(maskVal)) {
                throw new ACLParseException("Invalid mask parameter, " + maskVal);
            }
            return new IpAddressAccessControl(val, maskVal, this.getType(), access);
        }
        throw new ACLParseException("Unknown address parameter(s)");
    }
}

