/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.server.auth.acl;

import org.filesys.server.auth.acl.ACLParseException;
import org.filesys.server.auth.acl.AccessControl;
import org.filesys.server.auth.acl.AccessControlParser;
import org.filesys.server.auth.acl.UidAccessControl;
import org.springframework.extensions.config.ConfigElement;

public class UidAccessControlParser
extends AccessControlParser {
    @Override
    public String getType() {
        return "uid";
    }

    @Override
    public AccessControl createAccessControl(ConfigElement params) throws ACLParseException {
        int access = this.parseAccessType(params);
        String val = params.getAttribute("id");
        if (val == null || val.length() == 0) {
            throw new ACLParseException("User id not specified");
        }
        String userId = val.trim();
        int uid = -1;
        try {
            uid = Integer.parseInt(userId);
            if (uid < 0 || uid > 32768) {
                throw new ACLParseException("Invalid user id, out of valid range");
            }
        }
        catch (NumberFormatException ex) {
            throw new ACLParseException("User id not valid");
        }
        return new UidAccessControl(userId, uid, this.getType(), access);
    }
}

