/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.server.auth.asn;

import java.io.IOException;
import java.util.StringTokenizer;
import org.filesys.server.auth.asn.DERBuffer;
import org.filesys.server.auth.asn.DERObject;

public class DEROid
extends DERObject {
    private String m_oid;

    public DEROid() {
    }

    public DEROid(String oid) {
        this.m_oid = oid;
    }

    public final String getOid() {
        return this.m_oid;
    }

    @Override
    public void derDecode(DERBuffer buf) throws IOException {
        StringBuffer oidStr;
        if (buf.unpackType() == 6) {
            int len = buf.unpackLength();
            long oidVal = 0L;
            oidStr = new StringBuffer();
            for (int i = 0; i < len; ++i) {
                int byt = buf.unpackByte();
                oidVal = (oidVal << 7) + (long)(byt & 0x7F);
                if ((byt & 0x80) != 0) continue;
                if (oidStr.length() == 0) {
                    switch ((int)(oidVal / 40L)) {
                        case 0: {
                            oidStr.append("0");
                            break;
                        }
                        case 1: {
                            oidStr.append("1");
                            oidVal -= 40L;
                            break;
                        }
                        default: {
                            oidStr.append("2");
                            oidVal -= 80L;
                        }
                    }
                }
                oidStr.append(".");
                oidStr.append(Long.toString(oidVal));
                oidVal = 0L;
            }
        } else {
            throw new IOException("Invalid type in buffer, not ObjectIdentifier");
        }
        this.m_oid = oidStr.toString();
    }

    @Override
    public void derEncode(DERBuffer buf) throws IOException {
        buf.packByte(6);
        int lenPos = buf.getPosition();
        buf.packByte(0);
        StringTokenizer tok = new StringTokenizer(this.m_oid, ".");
        this.packOidField(buf, Integer.parseInt(tok.nextToken()) * 40 + Integer.parseInt(tok.nextToken()));
        while (tok.hasMoreTokens()) {
            this.packOidField(buf, Integer.parseInt(tok.nextToken()));
        }
        int len = buf.getPosition() - (lenPos + 1);
        buf.packByteAt(lenPos, len);
    }

    private void packOidField(DERBuffer buf, long oidVal) throws IOException {
        for (int fieldShift = 56; fieldShift > 0; fieldShift -= 7) {
            if (oidVal <= 1L << fieldShift) continue;
            buf.packByte((int)(oidVal >> fieldShift) | 0x80);
        }
        buf.packByte((int)(oidVal & 0x7FL));
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("[Oid:");
        str.append(this.m_oid);
        str.append("]");
        return str.toString();
    }
}

