/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.server.auth.kerberos;

import java.io.IOException;
import org.filesys.server.auth.asn.DERBuffer;
import org.filesys.server.auth.asn.DERGeneralizedTime;
import org.filesys.server.auth.asn.DERInteger;
import org.filesys.server.auth.asn.DERObject;
import org.filesys.server.auth.asn.DEROctetString;
import org.filesys.server.auth.asn.DERSequence;
import org.filesys.util.HexDump;

public class EncApRepPart {
    private int m_microseconds;
    private String m_timestamp;
    private int m_subKeyType;
    private byte[] m_subKey;
    private int m_seqNo;

    public EncApRepPart() {
    }

    public EncApRepPart(byte[] blob) throws IOException {
        this.parseApRep(blob);
    }

    public final String getTimestamp() {
        return this.m_timestamp;
    }

    public final int getSubKeyType() {
        return this.m_subKeyType;
    }

    public final byte[] getSubKey() {
        return this.m_subKey;
    }

    public final int getSequenceNumber() {
        return this.m_seqNo;
    }

    public final void setSubkey(int keyType, byte[] subkey) {
        this.m_subKeyType = keyType;
        this.m_subKey = subkey;
    }

    public final void parseApRep(byte[] apRep) throws IOException {
        DERBuffer derBuf = new DERBuffer(apRep);
        DERObject derObj = derBuf.unpackObject();
        if (derObj instanceof DERSequence) {
            DERSequence derSeq = (DERSequence)derObj;
            block10: for (int idx = 0; idx < derSeq.numberOfObjects(); ++idx) {
                derObj = derSeq.getObjectAt(idx);
                if (derObj == null || !derObj.isTagged()) continue;
                switch (derObj.getTagNo()) {
                    case 0: {
                        if (!(derObj instanceof DERGeneralizedTime)) continue block10;
                        DERGeneralizedTime derTime = (DERGeneralizedTime)derObj;
                        this.m_timestamp = derTime.getValue();
                        continue block10;
                    }
                    case 1: {
                        if (!(derObj instanceof DERInteger)) continue block10;
                        DERInteger derInt = (DERInteger)derObj;
                        this.m_microseconds = (int)derInt.getValue();
                        continue block10;
                    }
                    case 2: {
                        if (!(derObj instanceof DERSequence)) continue block10;
                        DERSequence derEncSeq = (DERSequence)derObj;
                        block11: for (int i = 0; i < derEncSeq.numberOfObjects(); ++i) {
                            derObj = derEncSeq.getObjectAt(i);
                            if (derObj == null || !derObj.isTagged()) continue;
                            switch (derObj.getTagNo()) {
                                case 0: {
                                    if (!(derObj instanceof DERInteger)) continue block11;
                                    DERInteger derInt = (DERInteger)derObj;
                                    this.m_subKeyType = (int)derInt.getValue();
                                    continue block11;
                                }
                                case 1: {
                                    if (!(derObj instanceof DEROctetString)) continue block11;
                                    DEROctetString derOct = (DEROctetString)derObj;
                                    this.m_subKey = derOct.getValue();
                                }
                            }
                        }
                        continue block10;
                    }
                    case 3: {
                        if (!(derObj instanceof DERInteger)) continue block10;
                        DERInteger derInt = (DERInteger)derObj;
                        this.m_seqNo = (int)derInt.getValue();
                    }
                }
            }
        }
    }

    public final byte[] encodeApRep() throws IOException {
        DERSequence derList = new DERSequence();
        DERGeneralizedTime derTime = new DERGeneralizedTime(this.getTimestamp());
        derTime.setTagNo(0);
        derList.addObject(derTime);
        DERInteger derInt = new DERInteger(this.m_microseconds);
        derInt.setTagNo(1);
        derList.addObject(derInt);
        DERSequence derSeq = new DERSequence(2);
        DERObject derObj = new DERInteger(this.m_subKeyType);
        derObj.setTagNo(0);
        derSeq.addObject(derObj);
        derObj = new DEROctetString(this.m_subKey);
        derObj.setTagNo(1);
        derSeq.addObject(derObj);
        derSeq.setTagNo(2);
        derList.addObject(derSeq);
        DERInteger derIntSeq = new DERInteger(this.m_seqNo);
        derIntSeq.setTagNo(3);
        derList.addObject(derIntSeq);
        DERBuffer derBuf = new DERBuffer(256);
        derBuf.packApplicationSpecific(27, derList);
        return derBuf.getBytes();
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("[AP-REP uSec=");
        str.append(this.m_microseconds);
        str.append(",Time=");
        str.append(this.getTimestamp());
        str.append(",SubKey=Type=");
        str.append(this.getSubKeyType());
        str.append(",Key=");
        str.append(this.getSubKey() != null ? HexDump.hexString(this.getSubKey()) : "null");
        str.append(",SeqNo=");
        str.append(this.getSequenceNumber());
        str.append("]");
        return str.toString();
    }
}

