/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.server.auth.ntlm;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.filesys.server.auth.ntlm.FlagsTargetInfo;
import org.filesys.server.auth.ntlm.StringTargetInfo;
import org.filesys.server.auth.ntlm.TargetInfo;
import org.filesys.server.auth.ntlm.TimestampTargetInfo;
import org.filesys.smb.NTTime;
import org.filesys.util.DataBuffer;
import org.filesys.util.DataPacker;
import org.filesys.util.HexDump;

public class NTLMv2Blob {
    public static final int HMAC_LEN = 16;
    public static final int CHALLENGE_LEN = 8;
    public static final int OFFSET_HMAC = 0;
    public static final int OFFSET_HEADER = 16;
    public static final int OFFSET_RESERVED = 20;
    public static final int OFFSET_TIMESTAMP = 24;
    public static final int OFFSET_CHALLENGE = 32;
    public static final int OFFSET_UNKNOWN = 36;
    public static final int OFFSET_TARGETINFO = 44;
    private byte[] m_blob;
    private int m_offset;
    private int m_len;

    public NTLMv2Blob(byte[] buf) {
        this.m_blob = buf;
        this.m_offset = 0;
        this.m_len = this.m_blob.length;
    }

    public NTLMv2Blob(byte[] buf, int offset, int len) {
        this.m_blob = buf;
        this.m_offset = offset;
        this.m_len = len;
    }

    public final byte[] getBuffer() {
        return this.m_blob;
    }

    public final int getOffset() {
        return this.m_offset;
    }

    public final int getLength() {
        return this.m_len;
    }

    public final byte[] getHMAC() {
        byte[] hmac = new byte[16];
        System.arraycopy(this.m_blob, this.m_offset, hmac, 0, 16);
        return hmac;
    }

    public final long getTimeStamp() {
        return DataPacker.getIntelLong(this.m_blob, this.m_offset + 24);
    }

    public final byte[] getClientChallenge() {
        byte[] challenge = new byte[8];
        System.arraycopy(this.m_blob, this.m_offset + 32, challenge, 0, 8);
        return challenge;
    }

    public final List<TargetInfo> getTargetInfo() {
        DataBuffer tBuf = new DataBuffer(this.getBuffer(), this.getOffset() + 44, this.getLength() - 44);
        ArrayList<TimestampTargetInfo> tList = null;
        boolean endOfList = false;
        while (!endOfList) {
            TargetInfo.Type tTyp = TargetInfo.Type.fromInt(tBuf.getShort());
            int tLen = tBuf.getShort();
            if (tTyp == TargetInfo.Type.END_OF_LIST) {
                endOfList = true;
                continue;
            }
            TargetInfo tInfo = null;
            switch (tTyp) {
                case SERVER: 
                case DOMAIN: 
                case FULL_DNS: 
                case DNS_DOMAIN: 
                case DNS_TREE: 
                case SPN: {
                    String sVal = tBuf.getString(tLen / 2, true);
                    tInfo = new StringTargetInfo(tTyp, sVal);
                    break;
                }
                case TIMESTAMP: {
                    long lVal = tBuf.getLong();
                    tInfo = new TimestampTargetInfo(lVal);
                    break;
                }
                case FLAGS: {
                    int iVal = tBuf.getInt();
                    tInfo = new FlagsTargetInfo(iVal);
                }
            }
            if (tInfo == null) continue;
            if (tList == null) {
                tList = new ArrayList<TimestampTargetInfo>();
            }
            tList.add((TimestampTargetInfo)tInfo);
        }
        return tList;
    }

    public final byte[] calculateHMAC(byte[] challenge, byte[] v2hash) throws Exception {
        byte[] blob = new byte[this.m_len - 16 + 8];
        System.arraycopy(challenge, 0, blob, 0, 8);
        System.arraycopy(this.m_blob, this.m_offset + 16, blob, 8, this.m_len - 16);
        Mac hmacMd5 = Mac.getInstance("HMACMD5");
        SecretKeySpec blobKey = new SecretKeySpec(v2hash, 0, v2hash.length, "MD5");
        hmacMd5.init(blobKey);
        return hmacMd5.doFinal(blob);
    }

    public final byte[] calculateLMv2HMAC(byte[] v2hash, byte[] srvChallenge, byte[] clChallenge) throws Exception {
        byte[] blob = new byte[16];
        System.arraycopy(srvChallenge, 0, blob, 0, srvChallenge.length);
        System.arraycopy(clChallenge, 0, blob, 8, clChallenge.length);
        Mac hmacMd5 = Mac.getInstance("HMACMD5");
        SecretKeySpec blobKey = new SecretKeySpec(v2hash, 0, v2hash.length, "MD5");
        hmacMd5.init(blobKey);
        return hmacMd5.doFinal(blob);
    }

    public final void Dump() {
        System.out.println("NTLMv2 blob :");
        System.out.println("       HMAC : " + HexDump.hexString(this.getHMAC()));
        System.out.println("     Header : 0x" + Integer.toHexString(DataPacker.getIntelInt(this.m_blob, this.m_offset + 16)));
        System.out.println("  Timestamp : " + new Date(NTTime.toJavaDate(this.getTimeStamp())));
        System.out.println("  Challenge : " + HexDump.hexString(this.getClientChallenge()));
    }
}

