/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.server.auth.ntlm;

public abstract class TargetInfo {
    private Type m_type;

    public TargetInfo(Type type) {
        this.m_type = type;
    }

    public final Type isType() {
        return this.m_type;
    }

    public abstract String valueAsString();

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("[");
        str.append(this.isType().name());
        str.append(":");
        str.append(this.valueAsString());
        str.append("]");
        return str.toString();
    }

    public static enum Type {
        END_OF_LIST(0),
        SERVER(1),
        DOMAIN(2),
        FULL_DNS(3),
        DNS_DOMAIN(4),
        DNS_TREE(5),
        FLAGS(6),
        TIMESTAMP(7),
        SINGLE_HOST(8),
        SPN(9),
        CHANNEL_BINDING(10);

        private final int infoType;

        private Type(int typ) {
            this.infoType = typ;
        }

        public final int intValue() {
            return this.infoType;
        }

        public static Type fromInt(int iVal) {
            if (iVal < 0 || iVal > 10) {
                return END_OF_LIST;
            }
            return Type.values()[iVal];
        }
    }
}

