/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.server.auth.spnego;

import java.io.IOException;
import org.filesys.server.auth.SecurityBlob;
import org.filesys.server.auth.asn.DER;

public class SPNEGO {
    public static final int NegTokenInit = 0;
    public static final int NegTokenTarg = 1;
    public static final int ContextDelete = 0;
    public static final int ContextMutual = 1;
    public static final int ContextReplay = 2;
    public static final int ContextSequence = 3;
    public static final int ContextAnon = 4;
    public static final int ContextConf = 5;
    public static final int ContextInteg = 6;

    public static int checkTokenType(byte[] buf, int off, int len) throws IOException {
        if (DER.isApplicationSpecific(buf[off])) {
            return 0;
        }
        if (DER.isTagged(buf[off])) {
            return 1;
        }
        return -1;
    }

    public static int checkTokenType(SecurityBlob secBlob) throws IOException {
        byte typ = secBlob.getSecurityBlob()[secBlob.getSecurityOffset()];
        if (DER.isApplicationSpecific(typ)) {
            return 0;
        }
        if (DER.isTagged(typ)) {
            return 1;
        }
        return -1;
    }

    public static enum Result {
        AcceptCompleted(0),
        AcceptIncomplete(1),
        Reject(2),
        Invalid(-1);

        private final int result;

        private Result(int ival) {
            this.result = ival;
        }

        public final int intValue() {
            return this.result;
        }

        public static final Result fromInt(int ival) {
            Result res = Invalid;
            switch (ival) {
                case 0: {
                    res = AcceptCompleted;
                    break;
                }
                case 1: {
                    res = AcceptIncomplete;
                    break;
                }
                case 2: {
                    res = Reject;
                }
            }
            return res;
        }
    }
}

