/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.server.filesys;

import org.filesys.smb.PCShare;

public class DiskInfo {
    protected String m_nodename;
    protected String m_share;
    protected long m_totalunits;
    protected long m_freeunits;
    protected long m_blockperunit;
    protected long m_blocksize;

    public DiskInfo() {
    }

    public DiskInfo(PCShare shr, int totunits, int blkunit, int blksiz, int freeunit) {
        if (shr != null) {
            this.m_nodename = shr.getNodeName();
            this.m_share = shr.getShareName();
        }
        this.m_totalunits = totunits;
        this.m_freeunits = freeunit;
        this.m_blockperunit = blkunit;
        this.m_blocksize = blksiz;
    }

    public DiskInfo(PCShare shr, long totunits, int blkunit, int blksiz, long freeunit) {
        if (shr != null) {
            this.m_nodename = shr.getNodeName();
            this.m_share = shr.getShareName();
        }
        this.m_totalunits = totunits;
        this.m_freeunits = freeunit;
        this.m_blockperunit = blkunit;
        this.m_blocksize = blksiz;
    }

    public final int getBlockSize() {
        return (int)this.m_blocksize;
    }

    public final int getBlocksPerAllocationUnit() {
        return (int)this.m_blockperunit;
    }

    public final long getDiskFreeSizeKb() {
        return this.m_freeunits * this.m_blockperunit * this.m_blocksize / 1024L;
    }

    public final long getDiskFreeSizeMb() {
        return this.getDiskFreeSizeKb() / 1024L;
    }

    public final long getDiskSizeKb() {
        return this.m_totalunits * this.m_blockperunit * this.m_blocksize / 1024L;
    }

    public final long getDiskSizeMb() {
        return this.getDiskSizeKb() / 1024L;
    }

    public final long getFreeUnits() {
        return this.m_freeunits;
    }

    public final long getUnitSize() {
        return this.m_blockperunit * this.m_blocksize;
    }

    public final String getNodeName() {
        return this.m_nodename;
    }

    public final String getShareName() {
        return this.m_share;
    }

    public final long getTotalUnits() {
        return this.m_totalunits;
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("[");
        str.append(this.getTotalUnits());
        str.append("/");
        str.append(this.getFreeUnits());
        str.append(",");
        str.append(this.getBlockSize());
        str.append("/");
        str.append(this.getBlocksPerAllocationUnit());
        str.append(",");
        str.append(this.getDiskSizeMb());
        str.append("Mb/");
        str.append(this.getDiskFreeSizeMb());
        str.append("Mb");
        str.append("]");
        return str.toString();
    }
}

