/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.server.filesys;

import org.filesys.server.SrvSession;
import org.filesys.server.filesys.AccessMode;
import org.filesys.server.filesys.CreateDisposition;
import org.filesys.server.filesys.FileAttribute;
import org.filesys.server.filesys.FileType;
import org.filesys.server.locking.OplockOwner;
import org.filesys.smb.ImpersonationLevel;
import org.filesys.smb.OpLockType;
import org.filesys.smb.SharingMode;

public class FileOpenParams {
    public static final String StreamSeparator = ":";
    private static int[] _NTToLMOpenCode = new int[]{18, 1, 16, 17, 2, 18};
    private String m_path;
    private String m_stream;
    private CreateDisposition m_openAction;
    private int m_accessMode;
    private int m_attr;
    private long m_allocSize;
    private SharingMode m_sharedAccess = SharingMode.READ_WRITE;
    private long m_createDate;
    private int m_rootFID;
    private int m_createOptions;
    private ImpersonationLevel m_secLevel;
    private int m_secFlags;
    private int m_gid = -1;
    private int m_uid = -1;
    private int m_mode = -1;
    private FileType m_fileType;
    private String m_symName;
    private int m_pid;
    private int m_createFlags;
    private SrvSession m_sess;
    private int m_treeId = -1;
    private OplockOwner m_oplockOwner;
    private long m_prevVersion;

    public FileOpenParams(String path, int openAction, int accessMode, int fileAttr, int pid) {
        this.parseFileName(path);
        this.m_openAction = this.convertToNTOpenAction(openAction);
        this.m_accessMode = this.convertToNTAccessMode(accessMode);
        this.m_attr = fileAttr;
        this.m_pid = pid;
        if (FileAttribute.isDirectory(this.m_attr)) {
            this.m_createOptions = 1;
        }
        this.m_secLevel = ImpersonationLevel.INVALID;
    }

    public FileOpenParams(String path, int openAction, int accessMode, int fileAttr, int gid, int uid, int mode, int pid) {
        this.parseFileName(path);
        this.m_openAction = this.convertToNTOpenAction(openAction);
        this.m_accessMode = this.convertToNTAccessMode(accessMode);
        this.m_attr = fileAttr;
        this.m_pid = pid;
        if (FileAttribute.isDirectory(this.m_attr)) {
            this.m_createOptions = 1;
        }
        this.m_secLevel = ImpersonationLevel.INVALID;
        this.m_gid = gid;
        this.m_uid = uid;
        this.m_mode = mode;
    }

    public FileOpenParams(String path, int openAction, int accessMode, int searchAttr, int fileAttr, int allocSize, long createDate, int pid) {
        this.parseFileName(path);
        this.m_openAction = this.convertToNTOpenAction(openAction);
        this.m_accessMode = this.convertToNTAccessMode(accessMode);
        this.m_attr = fileAttr;
        this.m_sharedAccess = this.convertToNTSharedMode(accessMode);
        this.m_allocSize = allocSize;
        this.m_createDate = createDate;
        this.m_pid = pid;
        if (FileAttribute.isDirectory(this.m_attr)) {
            this.m_createOptions = 1;
        }
        this.m_secLevel = ImpersonationLevel.INVALID;
    }

    public FileOpenParams(String path, CreateDisposition openAction, int accessMode, int attr, SharingMode sharedAccess, long allocSize, int createOption, int rootFID, ImpersonationLevel secLevel, int secFlags, int pid) {
        this.parseFileName(path);
        this.m_openAction = openAction;
        this.m_accessMode = accessMode;
        this.m_attr = attr;
        this.m_sharedAccess = sharedAccess;
        this.m_allocSize = allocSize;
        this.m_createOptions = createOption;
        this.m_rootFID = rootFID;
        this.m_secLevel = secLevel;
        this.m_secFlags = secFlags;
        this.m_pid = pid;
        if ((createOption & 1) != 0 && (this.m_attr & 0x10) == 0) {
            this.m_attr += 16;
        }
    }

    public FileOpenParams(String path, CreateDisposition openAction, int accessMode, int attr, SharingMode sharedAccess, int createOption, ImpersonationLevel secLevel, int pid) {
        this.parseFileName(path);
        this.m_openAction = openAction;
        this.m_accessMode = accessMode;
        this.m_attr = attr;
        this.m_sharedAccess = sharedAccess;
        this.m_createOptions = createOption;
        this.m_secLevel = secLevel;
        this.m_secFlags = 0;
        this.m_pid = pid;
        if ((createOption & 1) != 0 && (this.m_attr & 0x10) == 0) {
            this.m_attr += 16;
        }
    }

    public final String getPath() {
        return this.m_path;
    }

    public final String getFullPath() {
        if (this.isStream()) {
            return this.m_path + this.m_stream;
        }
        return this.m_path;
    }

    public final int getAttributes() {
        return this.m_attr;
    }

    public final long getAllocationSize() {
        return this.m_allocSize;
    }

    public final boolean hasCreationDateTime() {
        return this.m_createDate != 0L;
    }

    public final long getCreationDateTime() {
        return this.m_createDate;
    }

    public final CreateDisposition getOpenAction() {
        return this.m_openAction;
    }

    public final int getProcessId() {
        return this.m_pid;
    }

    public final int getRootDirectoryFID() {
        return this.m_rootFID;
    }

    public final String getStreamName() {
        return this.m_stream;
    }

    public final boolean hasCreateOption(int flag) {
        return (this.m_createOptions & flag) != 0;
    }

    public final int getCreateOptions() {
        return this.m_createOptions;
    }

    public final boolean isStream() {
        return this.m_stream != null;
    }

    public final boolean isReadOnlyAccess() {
        return (this.m_accessMode & 3) == 1 || this.m_accessMode == Integer.MIN_VALUE;
    }

    public final boolean isWriteOnlyAccess() {
        return (this.m_accessMode & 3) == 2 || this.m_accessMode == 0x40000000;
    }

    public final boolean isReadWriteAccess() {
        return (this.m_accessMode & 3) == 3 || (this.m_accessMode & 0xC0000000) == -1073741824 || this.m_accessMode == 0x10000000;
    }

    public final boolean isAttributesOnlyAccess() {
        return (this.m_accessMode & 7) == 0 && (this.m_accessMode & 0x180) != 0;
    }

    public final int getAccessMode() {
        return this.m_accessMode;
    }

    public final boolean isDirectory() {
        return this.hasCreateOption(1);
    }

    public final FileType isFileType() {
        return this.m_fileType;
    }

    public final boolean isSymbolicLink() {
        return this.isFileType() == FileType.SymbolicLink;
    }

    public final String getSymbolicLinkName() {
        return this.m_symName;
    }

    public final boolean isSequentialAccessOnly() {
        return this.hasCreateOption(4);
    }

    public final boolean isDeleteOnClose() {
        return this.hasCreateOption(4096);
    }

    public final boolean isWriteThrough() {
        return this.hasCreateOption(2);
    }

    public final boolean isOverwrite() {
        return this.getOpenAction() == CreateDisposition.SUPERSEDE || this.getOpenAction() == CreateDisposition.OVERWRITE || this.getOpenAction() == CreateDisposition.OVERWRITE_IF;
    }

    public final SharingMode getSharedAccess() {
        return this.m_sharedAccess;
    }

    public final boolean hasSecurityLevel() {
        return this.m_secLevel != ImpersonationLevel.INVALID;
    }

    public final ImpersonationLevel getSecurityLevel() {
        return this.m_secLevel;
    }

    public final boolean hasSecurityContextTracking() {
        return (this.m_secFlags & 0x40000) != 0;
    }

    public final boolean hasSecurityEffectiveOnly() {
        return (this.m_secFlags & 0x80000) != 0;
    }

    public final boolean hasGid() {
        return this.m_gid != -1;
    }

    public final int getGid() {
        return this.m_gid;
    }

    public final boolean hasUid() {
        return this.m_uid != -1;
    }

    public final int getUid() {
        return this.m_uid;
    }

    public final boolean hasMode() {
        return this.m_mode != -1;
    }

    public final int getMode() {
        return this.m_mode;
    }

    public final boolean isPreviousVersion() {
        return this.m_prevVersion != 0L;
    }

    public final long getPreviousVersionDateTime() {
        return this.m_prevVersion;
    }

    public final OpLockType requestedOplockType() {
        OpLockType lockTyp = OpLockType.LEVEL_NONE;
        if (this.requestBatchOpLock()) {
            lockTyp = OpLockType.LEVEL_BATCH;
        } else if (this.requestExclusiveOpLock()) {
            lockTyp = OpLockType.LEVEL_EXCLUSIVE;
        } else if (this.requestLevelIIOplock()) {
            lockTyp = OpLockType.LEVEL_II;
        }
        return lockTyp;
    }

    public final boolean requestBatchOpLock() {
        return (this.m_createFlags & 4) != 0;
    }

    public final boolean requestExclusiveOpLock() {
        return (this.m_createFlags & 2) != 0;
    }

    public boolean requestLevelIIOplock() {
        return false;
    }

    public final boolean hasOplockOwner() {
        return this.m_oplockOwner != null;
    }

    public final OplockOwner getOplockOwner() {
        return this.m_oplockOwner;
    }

    public final void setOplockOwner(OplockOwner owner) {
        this.m_oplockOwner = owner;
    }

    public final boolean requestExtendedResponse() {
        return (this.m_createFlags & 0x10) != 0;
    }

    public final boolean hasSession() {
        return this.m_sess != null;
    }

    public final SrvSession getSession() {
        return this.m_sess;
    }

    public final boolean hasAccessMode(int mode) {
        return (this.m_accessMode & mode) == mode;
    }

    public final boolean hasTreeId() {
        return this.m_treeId != -1;
    }

    public final int getTreeId() {
        return this.m_treeId;
    }

    public final void setTreeId(int treeId) {
        this.m_treeId = treeId;
    }

    public final void setMode(int mode) {
        this.m_mode = mode;
    }

    public final void setCreateOption(int flag) {
        this.m_createOptions |= flag;
    }

    public final void setNTCreateFlags(int createFlags) {
        this.m_createFlags = createFlags;
    }

    protected final int getNTCreateFlags() {
        return this.m_createFlags;
    }

    public final void setSession(SrvSession sess) {
        this.m_sess = sess;
    }

    public final void setFileType(FileType typ) {
        this.m_fileType = typ;
    }

    public final void setSymbolicLink(String name) {
        this.m_symName = name;
        this.m_fileType = FileType.SymbolicLink;
    }

    public final void setPreviousVersionDateTime(long tstamp) {
        this.m_prevVersion = tstamp;
    }

    private final int convertToNTAccessMode(int accessMode) {
        int mode = 0;
        switch (AccessMode.getAccessMode(accessMode)) {
            case 0: {
                mode = 1;
                break;
            }
            case 1: {
                mode = 2;
                break;
            }
            case 2: {
                mode = 3;
            }
        }
        return mode;
    }

    private final CreateDisposition convertToNTOpenAction(int openAction) {
        CreateDisposition action = CreateDisposition.OPEN;
        for (int i = 0; i < _NTToLMOpenCode.length; ++i) {
            if (_NTToLMOpenCode[i] != openAction) continue;
            action = CreateDisposition.fromInt(i);
        }
        return action;
    }

    private final SharingMode convertToNTSharedMode(int sharedAccess) {
        int shr = AccessMode.getSharingMode(sharedAccess);
        SharingMode ret = SharingMode.READ_WRITE;
        switch (shr) {
            case 16: {
                ret = SharingMode.NOSHARING;
                break;
            }
            case 48: {
                ret = SharingMode.WRITE;
                break;
            }
            case 32: {
                ret = SharingMode.READ;
            }
        }
        return ret;
    }

    private final void parseFileName(String fileName) {
        int pos;
        if (fileName != null && !fileName.startsWith("\\")) {
            fileName = "\\" + fileName;
        }
        if ((pos = fileName.indexOf(StreamSeparator)) == -1) {
            this.m_path = fileName;
            if (this.m_path.length() == 0) {
                this.m_path = "\\";
            }
            return;
        }
        this.m_path = fileName.substring(0, pos);
        this.m_stream = fileName.substring(pos);
        if (this.m_stream.equals("::$DATA")) {
            this.m_stream = null;
        } else if (this.m_stream.endsWith(":$DATA")) {
            this.m_stream = this.m_stream.substring(0, this.m_stream.length() - ":$DATA".length());
        }
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("[");
        str.append(this.getPath());
        str.append(",");
        str.append(this.getOpenAction().name());
        str.append(",acc=0x");
        str.append(Integer.toHexString(this.m_accessMode));
        str.append(",attr=0x");
        str.append(Integer.toHexString(this.getAttributes()));
        str.append(",alloc=");
        str.append(this.getAllocationSize());
        str.append(",share=");
        str.append(this.getSharedAccess().name());
        str.append(",pid=");
        str.append(this.getProcessId());
        if (this.getRootDirectoryFID() != 0) {
            str.append(",fid=");
            str.append(this.getRootDirectoryFID());
        }
        if (this.hasCreationDateTime()) {
            str.append(",cdate=");
            str.append(this.getCreationDateTime());
        }
        if (this.m_createOptions != 0) {
            str.append(",copt=0x");
            str.append(Integer.toHexString(this.m_createOptions));
        }
        if (this.hasSecurityLevel()) {
            str.append(",seclev=");
            str.append(this.getSecurityLevel().name());
            str.append(",secflg=0x");
            str.append(Integer.toHexString(this.m_secFlags));
        }
        if (this.hasGid() || this.hasUid()) {
            str.append(",gid=");
            str.append(this.getGid());
            str.append(",uid=");
            str.append(this.getUid());
        }
        if (this.getMode() != -1) {
            str.append(",mode=0");
            str.append(Integer.toOctalString(this.getMode()));
        }
        if (this.m_createFlags != 0) {
            if (this.requestBatchOpLock()) {
                str.append(",BatchOpLck");
            }
            if (this.requestExclusiveOpLock()) {
                str.append(",ExOpLck");
            }
            if (this.requestExtendedResponse()) {
                str.append(",ExtResp");
            }
        }
        if (this.isPreviousVersion()) {
            str.append(",PrevVer=");
            str.append(this.getPreviousVersionDateTime());
        }
        str.append("]");
        return str.toString();
    }
}

