/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.server.filesys;

import java.util.Enumeration;
import org.filesys.server.config.ConfigSection;
import org.filesys.server.config.ServerConfiguration;
import org.filesys.server.core.DeviceContext;
import org.filesys.server.core.SharedDevice;
import org.filesys.server.core.SharedDeviceList;
import org.filesys.server.filesys.cache.FileStateCache;
import org.filesys.server.filesys.cache.FileStateReaper;

public class FilesystemsConfigSection
extends ConfigSection {
    public static final String SectionName = "Filesystems";
    private SharedDeviceList m_shareList = new SharedDeviceList();
    private FileStateReaper m_stateReaper;

    public FilesystemsConfigSection(ServerConfiguration config) {
        super(SectionName, config);
    }

    public final SharedDeviceList getShares() {
        return this.m_shareList;
    }

    public final boolean addShare(SharedDevice shr) {
        return this.m_shareList.addShare(shr);
    }

    public final synchronized void addFileStateCache(String filesysName, FileStateCache stateCache) {
        if (this.m_stateReaper == null) {
            this.m_stateReaper = new FileStateReaper();
        }
        this.m_stateReaper.addStateCache(filesysName, stateCache);
    }

    @Override
    public final void closeConfig() {
        if (this.getShares() != null && this.getShares().numberOfShares() > 0) {
            Enumeration<SharedDevice> shareEnum = this.getShares().enumerateShares();
            while (shareEnum.hasMoreElements()) {
                SharedDevice share = shareEnum.nextElement();
                DeviceContext devCtx = share.getContext();
                if (devCtx == null) continue;
                if (this.m_stateReaper != null) {
                    this.m_stateReaper.removeStateCache(share.getName());
                }
                devCtx.CloseContext();
            }
            if (this.m_stateReaper != null) {
                this.m_stateReaper.shutdownRequest();
                this.m_stateReaper = null;
            }
        }
    }
}

