/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.server.filesys;

import java.io.IOException;
import java.util.EnumSet;
import java.util.Set;
import org.filesys.locking.FileLock;
import org.filesys.locking.FileLockList;
import org.filesys.server.filesys.FileAccessToken;
import org.filesys.server.filesys.HashedSearchMap;
import org.filesys.server.filesys.SearchContext;
import org.filesys.server.filesys.SearchMap;
import org.filesys.server.filesys.TooManySearchesException;
import org.filesys.server.locking.OpLockDetails;

public abstract class NetworkFile {
    protected int m_fid;
    protected int m_dirId;
    protected long m_uniqueId;
    private int m_protocolId = -1;
    protected String m_name;
    protected String m_streamName;
    protected int m_streamId;
    protected String m_fullName;
    protected int m_attrib;
    protected long m_fileSize;
    protected long m_createDate;
    protected long m_modifyDate;
    protected long m_accessDate;
    protected Access m_grantedAccess;
    protected int m_accessMask;
    protected Access m_allowedAccess = Access.READ_WRITE;
    protected int m_writeCount;
    private FileLockList m_lockList;
    private Set<Flags> m_flags = EnumSet.of(Flags.CLOSED);
    private OpLockDetails m_oplock;
    private FileAccessToken m_accessToken;
    private SearchMap m_searchMap;

    public NetworkFile(int fid) {
        this.m_fid = fid;
    }

    public NetworkFile(int fid, int did) {
        this.m_fid = fid;
        this.m_dirId = did;
    }

    public NetworkFile(int fid, int stid, int did) {
        this.m_fid = fid;
        this.m_streamId = stid;
        this.m_dirId = did;
    }

    public NetworkFile(String name) {
        this.m_name = name;
    }

    public final int getDirectoryId() {
        return this.m_dirId;
    }

    public final int getFileAttributes() {
        return this.m_attrib;
    }

    public final int getFileId() {
        return this.m_fid;
    }

    public final long getFileSize() {
        return this.m_fileSize;
    }

    public final int getFileSizeInt() {
        return (int)(this.m_fileSize & 0xFFFFFFFFL);
    }

    public final String getFullName() {
        return this.m_fullName;
    }

    public final String getFullNameStream() {
        if (this.isStream()) {
            return this.m_fullName + this.m_streamName;
        }
        return this.m_fullName;
    }

    public final Access getGrantedAccess() {
        return this.m_grantedAccess;
    }

    public final int getAccessMask() {
        return this.m_accessMask;
    }

    public final Access getAllowedAccess() {
        return this.m_allowedAccess;
    }

    public String getName() {
        return this.m_name;
    }

    public final int getStreamId() {
        return this.m_streamId;
    }

    public final String getStreamName() {
        return this.m_streamName;
    }

    public final long getUniqueId() {
        return this.m_uniqueId;
    }

    public final boolean isClosed() {
        return this.m_flags.contains((Object)Flags.CLOSED);
    }

    public final boolean isDirectory() {
        return (this.m_attrib & 0x10) != 0;
    }

    public final boolean isHidden() {
        return (this.m_attrib & 2) != 0;
    }

    public final boolean isReadOnly() {
        return (this.m_attrib & 1) != 0;
    }

    public final boolean isSystem() {
        return (this.m_attrib & 4) != 0;
    }

    public final boolean isArchived() {
        return (this.m_attrib & 0x20) != 0;
    }

    public final boolean isStream() {
        return this.m_streamName != null;
    }

    public final boolean hasLocks() {
        return this.m_lockList != null && this.m_lockList.numberOfLocks() > 0;
    }

    public final boolean hasNTAttribute(int attr) {
        return (this.m_attrib & attr) == attr;
    }

    public final boolean hasAccessDate() {
        return this.m_accessDate != 0L;
    }

    public final long getAccessDate() {
        return this.m_accessDate;
    }

    public final boolean hasCreationDate() {
        return this.m_createDate != 0L;
    }

    public final long getCreationDate() {
        return this.m_createDate;
    }

    public final boolean hasDelayedWriteError() {
        return this.m_flags.contains((Object)Flags.DELAYED_WRITE_ERROR);
    }

    public final boolean hasDeleteOnClose() {
        return this.m_flags.contains((Object)Flags.DELETE_ON_CLOSE);
    }

    public final boolean hasIOPending() {
        return this.m_flags.contains((Object)Flags.IO_PENDING);
    }

    public final boolean hasDelayedClose() {
        return this.m_flags.contains((Object)Flags.DELAYED_CLOSE);
    }

    public final boolean wasCreated() {
        return this.m_flags.contains((Object)Flags.CREATED);
    }

    public final boolean isPreviousVersion() {
        return this.m_flags.contains((Object)Flags.PREVIOUS_VERSION);
    }

    public final boolean requiresPostCloseProcessing() {
        return this.m_flags.contains((Object)Flags.POST_CLOSE_FILE);
    }

    public boolean hasModifyDate() {
        return this.m_modifyDate != 0L;
    }

    public final long getModifyDate() {
        return this.m_modifyDate;
    }

    public final int getWriteCount() {
        return this.m_writeCount;
    }

    public final void incrementWriteCount() {
        ++this.m_writeCount;
    }

    public final int getProtocolId() {
        return this.m_protocolId;
    }

    public final void setAttributes(int attrib) {
        this.m_attrib = attrib;
    }

    public final void setDeleteOnClose(boolean del) {
        this.setStatusFlag(Flags.DELETE_ON_CLOSE, del);
    }

    public final void setDirectoryId(int dirId) {
        this.m_dirId = dirId;
    }

    public final void setFileId(int fid) {
        this.m_fid = fid;
    }

    public final void setFileSize(long siz) {
        this.m_fileSize = siz;
    }

    public final void setFileSize(int siz) {
        this.m_fileSize = siz;
    }

    public final void setFullName(String name) {
        this.m_fullName = name;
    }

    public final void setGrantedAccess(Access mode) {
        this.m_grantedAccess = mode;
    }

    public final void setAccessMask(int accessMask) {
        this.m_accessMask = accessMask;
    }

    public final void setAllowedAccess(Access mode) {
        this.m_allowedAccess = mode;
    }

    public final void setName(String name) {
        this.m_name = name;
    }

    public final void setIOPending(boolean pending) {
        this.setStatusFlag(Flags.IO_PENDING, pending);
    }

    public final void setStreamId(int id) {
        this.m_streamId = id;
    }

    public final void setStreamName(String name) {
        this.m_streamName = name;
    }

    public final synchronized void setClosed(boolean b) {
        this.setStatusFlag(Flags.CLOSED, b);
    }

    public final void setAccessDate(long dattim) {
        this.m_accessDate = dattim;
    }

    public final void setCreationDate(long dattim) {
        this.m_createDate = dattim;
    }

    public final void setDelayedWriteError(boolean err) {
        this.setStatusFlag(Flags.DELAYED_WRITE_ERROR, err);
    }

    public final void setDelayedClose(boolean delayClose) {
        this.setStatusFlag(Flags.DELAYED_CLOSE, delayClose);
    }

    public final void setModifyDate(long dattim) {
        this.m_modifyDate = dattim;
    }

    public final void setPreviousVersion(boolean prevVer) {
        this.setStatusFlag(Flags.PREVIOUS_VERSION, prevVer);
    }

    public final synchronized void setStatusFlag(Flags flag, boolean sts) {
        if (sts) {
            this.m_flags.add(flag);
        } else {
            this.m_flags.remove((Object)flag);
        }
    }

    public final synchronized void addLock(FileLock lock) {
        if (this.m_lockList == null) {
            this.m_lockList = new FileLockList();
        }
        this.m_lockList.addLock(lock);
    }

    public final synchronized void removeLock(FileLock lock) {
        if (this.m_lockList == null) {
            return;
        }
        this.m_lockList.removeLock(lock);
    }

    public final synchronized void removeAllLocks() {
        if (this.m_lockList != null) {
            this.m_lockList.removeAllLocks();
        }
    }

    public final int numberOfLocks() {
        if (this.m_lockList == null) {
            return 0;
        }
        return this.m_lockList.numberOfLocks();
    }

    public final FileLock getLockAt(int idx) {
        if (this.m_lockList != null) {
            return this.m_lockList.getLockAt(idx);
        }
        return null;
    }

    public final FileLockList getLockList() {
        return this.m_lockList;
    }

    public final boolean hasOpLock() {
        return this.m_oplock != null;
    }

    public final OpLockDetails getOpLock() {
        return this.m_oplock;
    }

    public final void setOpLock(OpLockDetails oplock) {
        this.m_oplock = oplock;
    }

    protected final void setUniqueId(long id) {
        this.m_uniqueId = id;
    }

    protected final void setUniqueId(int fid, int did) {
        long ldid = did;
        long lfid = fid;
        this.m_uniqueId = (ldid << 32) + lfid;
    }

    protected final void setUniqueId(String path) {
        this.m_uniqueId = path.toUpperCase().hashCode();
    }

    public final void setProtocolId(int id) {
        this.m_protocolId = id;
    }

    public final boolean hasAccessToken() {
        return this.m_accessToken != null;
    }

    public final FileAccessToken getAccessToken() {
        return this.m_accessToken;
    }

    public final void setAccessToken(FileAccessToken token) {
        this.m_accessToken = token;
    }

    public final synchronized boolean allocateSearchSlotWithId(int searchId) throws TooManySearchesException {
        if (this.m_searchMap == null) {
            this.m_searchMap = new HashedSearchMap();
        }
        return this.m_searchMap.allocateSearchSlotWithId(searchId);
    }

    public final synchronized void deallocateSearchSlot(int ctxId) {
        if (this.m_searchMap != null) {
            this.m_searchMap.deallocateSearchSlot(ctxId);
        }
    }

    public final synchronized SearchContext getSearchContext(int srchId) {
        if (this.m_searchMap == null) {
            return null;
        }
        return this.m_searchMap.findSearchContext(srchId);
    }

    public final synchronized void setSearchContext(int slot, SearchContext srch) {
        if (this.m_searchMap != null) {
            this.m_searchMap.setSearchContext(slot, srch);
        }
    }

    public final synchronized int getSearchCount() {
        if (this.m_searchMap == null) {
            return 0;
        }
        return this.m_searchMap.numberOfSearches();
    }

    public abstract void openFile(boolean var1) throws IOException;

    public abstract int readFile(byte[] var1, int var2, int var3, long var4) throws IOException;

    public abstract void writeFile(byte[] var1, int var2, int var3, long var4) throws IOException;

    public abstract long seekFile(long var1, int var3) throws IOException;

    public abstract void flushFile() throws IOException;

    public abstract void truncateFile(long var1) throws IOException;

    public abstract void closeFile() throws IOException;

    public void close() throws IOException {
        this.closeFile();
    }

    public boolean allowsOpenCloseViaNetworkFile() {
        return true;
    }

    public boolean isForce() {
        return this.m_flags.contains((Object)Flags.FORCE_CLOSE);
    }

    public void setForce(boolean force) {
        this.setStatusFlag(Flags.FORCE_CLOSE, force);
    }

    public final synchronized void closeSearches() {
        if (this.m_searchMap != null) {
            this.m_searchMap.closeAllSearches();
        }
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("[");
        str.append(this.getName());
        str.append("/");
        str.append(this.getFullName());
        str.append(" ");
        str.append(this.isDirectory() ? "D" : "-");
        str.append(this.isArchived() ? "A" : "-");
        str.append(this.isSystem() ? "S" : "-");
        str.append(this.isHidden() ? "H" : "-");
        str.append(" ");
        str.append(this.getFileSize());
        str.append(":");
        str.append(this.getFileId());
        str.append("/");
        str.append(this.getDirectoryId());
        if (this.isPreviousVersion()) {
            str.append(" Ver");
        }
        str.append("]");
        return str.toString();
    }

    public static enum Flags {
        IO_PENDING,
        DELETE_ON_CLOSE,
        DELAYED_WRITE_ERROR,
        CREATED,
        DELAYED_CLOSE,
        CLOSED,
        FORCE_CLOSE,
        PREVIOUS_VERSION,
        POST_CLOSE_FILE;

    }

    public static enum Access {
        ATTRIBUTES_ONLY(0),
        READ_ONLY(1),
        WRITE_ONLY(2),
        READ_WRITE(3);

        private final int accessType;

        private Access(int typ) {
            this.accessType = typ;
        }

        public final int intValue() {
            return this.accessType;
        }
    }
}

