/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.server.filesys;

import org.filesys.server.filesys.FileInfo;

public abstract class SearchContext {
    private int m_maxFiles;
    private int m_maxSize;
    private int m_treeId;
    private String m_searchStr;
    private int m_flags;
    private boolean m_closed;

    public SearchContext() {
    }

    protected SearchContext(int maxFiles, int treeId) {
        this.m_maxFiles = maxFiles;
        this.m_treeId = treeId;
    }

    public void closeSearch() {
    }

    public final int getFlags() {
        return this.m_flags;
    }

    public final int getMaximumFiles() {
        return this.m_maxFiles;
    }

    public final int getMaximumResponseSize() {
        return this.m_maxSize;
    }

    public abstract int getResumeId();

    public final String getSearchString() {
        return this.m_searchStr != null ? this.m_searchStr : "";
    }

    public final int getTreeId() {
        return this.m_treeId;
    }

    public final boolean isClosed() {
        return this.m_closed;
    }

    public abstract boolean hasMoreFiles();

    public abstract boolean nextFileInfo(FileInfo var1);

    public abstract String nextFileName();

    public int numberOfEntries() {
        return -1;
    }

    public abstract boolean restartAt(int var1);

    public abstract boolean restartAt(FileInfo var1);

    public final void setFlags(int flg) {
        this.m_flags = flg;
    }

    public final void setMaximumFiles(int maxFiles) {
        this.m_maxFiles = maxFiles;
    }

    public final void setMaximumResponseSize(int maxSize) {
        this.m_maxSize = maxSize;
    }

    public final void setSearchString(String str) {
        this.m_searchStr = str;
    }

    public final void setTreeId(int id) {
        this.m_treeId = id;
    }

    public boolean hasDotFiles() {
        return false;
    }

    public boolean getDotInfo(FileInfo finfo) {
        return false;
    }

    public boolean getDotDotInfo(FileInfo finfo) {
        return false;
    }

    public final void setClosed() {
        this.m_closed = true;
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("[");
        str.append(this.getSearchString());
        str.append(", maxFiles=");
        str.append(this.getMaximumFiles());
        str.append(", maxSize=");
        str.append(this.getMaximumResponseSize());
        str.append(", flags=0x");
        str.append(Integer.toHexString(this.getFlags()));
        if (this.hasDotFiles()) {
            str.append(",DotFiles");
        }
        if (this.isClosed()) {
            str.append(", CLOSED");
        }
        str.append("]");
        return str.toString();
    }
}

