/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.server.filesys;

import org.filesys.server.filesys.SearchContext;
import org.filesys.server.filesys.SearchContextAdapter;
import org.filesys.server.filesys.TooManySearchesException;

public abstract class SearchMap {
    protected static final int DefaultSearches = 8;
    protected static final int MaxSearches = 256;
    public static final int InvalidSearchId = -1;
    protected static final SearchContextAdapter SearchSlotMarker = new SearchContextAdapter();
    private int m_maxSearches = 256;

    public SearchMap() {
    }

    public SearchMap(int maxSearches) {
        this.m_maxSearches = maxSearches;
    }

    public abstract int allocateSearchSlot() throws TooManySearchesException;

    public abstract boolean allocateSearchSlotWithId(int var1) throws TooManySearchesException;

    public abstract SearchContext deallocateSearchSlot(int var1);

    public abstract SearchContext findSearchContext(int var1);

    public abstract void setSearchContext(int var1, SearchContext var2);

    public abstract int numberOfSearches();

    public final int maximumNumberOfSearches() {
        return this.m_maxSearches;
    }

    public abstract void closeAllSearches();

    protected final void setMaximumNumberOfSearches(int maxSearches) {
        this.m_maxSearches = maxSearches;
    }
}

