/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.server.filesys;

import org.filesys.server.SrvSession;
import org.filesys.server.auth.ISMBAuthenticator;
import org.filesys.server.core.DeviceContext;
import org.filesys.server.core.DeviceInterface;
import org.filesys.server.core.InvalidDeviceInterfaceException;
import org.filesys.server.core.SharedDevice;
import org.filesys.server.filesys.DiskInterface;
import org.filesys.server.filesys.NetworkFile;
import org.filesys.server.filesys.NetworkFileServer;
import org.filesys.server.filesys.TooManyFilesException;

public class TreeConnection {
    public static final int MAXFILES = 8192;
    public static final int INITIALFILES = 32;
    private SharedDevice m_shareDev;
    private NetworkFile[] m_files;
    private int m_fileCount;
    private ISMBAuthenticator.ShareStatus m_permission;
    private int m_treeId;

    public TreeConnection(SharedDevice shrDev) {
        this.m_shareDev = shrDev;
        this.m_shareDev.incrementConnectionCount();
    }

    public TreeConnection(SharedDevice shrDev, int treeId) {
        this.m_shareDev = shrDev;
        this.m_shareDev.incrementConnectionCount();
        this.m_treeId = treeId;
    }

    public final int getId() {
        return this.m_treeId;
    }

    public synchronized int addFile(NetworkFile file, SrvSession sess) throws TooManyFilesException {
        NetworkFileServer fileSrv;
        int idx;
        if (this.m_files == null) {
            this.m_files = new NetworkFile[32];
        }
        for (idx = 0; idx < this.m_files.length && this.m_files[idx] != null; ++idx) {
        }
        if (idx == this.m_files.length) {
            if (this.m_files.length >= 8192) {
                throw new TooManyFilesException();
            }
            NetworkFile[] newFiles = new NetworkFile[this.m_files.length * 2];
            System.arraycopy(this.m_files, 0, newFiles, 0, this.m_files.length);
            this.m_files = newFiles;
        }
        if ((fileSrv = (NetworkFileServer)sess.getServer()) != null) {
            fileSrv.fireOpenFileEvent(sess, file);
        }
        this.m_files[idx] = file;
        ++this.m_fileCount;
        file.setProtocolId(idx);
        return idx;
    }

    public synchronized void closeConnection(SrvSession sess) {
        if (this.openFileCount() > 0) {
            for (int idx = 0; idx < this.m_files.length; ++idx) {
                if (this.m_files[idx] == null) continue;
                try {
                    DiskInterface disk = (DiskInterface)this.m_shareDev.getInterface();
                    this.m_files[idx].setForce(true);
                    disk.closeFile(sess, this, this.m_files[idx]);
                    this.m_files[idx].setClosed(true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.removeFile(idx, sess);
            }
        }
        this.m_shareDev.decrementConnectionCount();
    }

    public synchronized NetworkFile findFile(int fid) {
        if (this.m_files == null || fid >= this.m_files.length || fid < 0) {
            return null;
        }
        return this.m_files[fid];
    }

    public synchronized int getFileTableLength() {
        if (this.m_files == null) {
            return 0;
        }
        return this.m_files.length;
    }

    public final boolean hasContext() {
        if (this.m_shareDev != null) {
            return this.m_shareDev.getContext() != null;
        }
        return false;
    }

    public final DeviceContext getContext() {
        if (this.m_shareDev == null) {
            return null;
        }
        return this.m_shareDev.getContext();
    }

    public final ISMBAuthenticator.ShareStatus getPermission() {
        return this.m_permission;
    }

    public final boolean hasReadAccess() {
        return this.m_permission == ISMBAuthenticator.ShareStatus.READ_ONLY || this.m_permission == ISMBAuthenticator.ShareStatus.WRITEABLE;
    }

    public final boolean hasWriteAccess() {
        return this.m_permission == ISMBAuthenticator.ShareStatus.WRITEABLE;
    }

    public final SharedDevice getSharedDevice() {
        return this.m_shareDev;
    }

    public final DeviceInterface getInterface() {
        if (this.m_shareDev == null) {
            return null;
        }
        try {
            return this.m_shareDev.getInterface();
        }
        catch (InvalidDeviceInterfaceException invalidDeviceInterfaceException) {
            return null;
        }
    }

    public synchronized int openFileCount() {
        return this.m_fileCount;
    }

    public final synchronized void removeAllFiles() {
        if (this.m_files == null) {
            return;
        }
        int idx = 0;
        while (idx < this.m_files.length) {
            this.m_files[idx++] = null;
        }
        this.m_fileCount = 0;
    }

    public synchronized void removeFile(int idx, SrvSession sess) {
        if (this.m_files == null || idx >= this.m_files.length) {
            return;
        }
        NetworkFileServer fileSrv = (NetworkFileServer)sess.getServer();
        if (fileSrv != null) {
            fileSrv.fireCloseFileEvent(sess, this.m_files[idx]);
        }
        if (this.m_files[idx] != null) {
            this.m_files[idx].setProtocolId(-1);
        }
        this.m_files[idx] = null;
        --this.m_fileCount;
    }

    public final void setPermission(ISMBAuthenticator.ShareStatus perm) {
        this.m_permission = perm;
    }

    public final void setPermission(int aclPerm) {
        switch (aclPerm) {
            case 0: {
                this.m_permission = ISMBAuthenticator.ShareStatus.NO_ACCESS;
                break;
            }
            case 1: {
                this.m_permission = ISMBAuthenticator.ShareStatus.READ_ONLY;
                break;
            }
            case 2: {
                this.m_permission = ISMBAuthenticator.ShareStatus.WRITEABLE;
            }
        }
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("[");
        str.append(this.m_shareDev.toString());
        str.append(", id=");
        str.append(this.getId());
        str.append(", fileCnt=");
        str.append(this.openFileCount());
        str.append(", perm=");
        str.append(this.m_permission.name());
        str.append("]");
        return str.toString();
    }
}

