/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.server.filesys.cache;

import java.util.Enumeration;
import java.util.Hashtable;
import org.filesys.debug.Debug;
import org.filesys.server.filesys.cache.FileStateCache;

public class FileStateReaper
implements Runnable {
    private static final long DEFAULT_EXPIRECHECK = 15000L;
    private long m_expireInterval = 15000L;
    private Thread m_thread = new Thread(this);
    private boolean m_shutdown;
    private Hashtable<String, FileStateCache> m_stateCaches;
    private boolean m_debug;

    public FileStateReaper() {
        this.m_thread.setDaemon(true);
        this.m_thread.setName("FileStateReaper");
        this.m_thread.start();
        this.m_stateCaches = new Hashtable();
    }

    public final boolean hasDebug() {
        return this.m_debug;
    }

    public final long getCheckInterval() {
        return this.m_expireInterval;
    }

    public final void setCheckInterval(long chkIntval) {
        this.m_expireInterval = chkIntval;
    }

    public final void addStateCache(String filesysName, FileStateCache stateCache) {
        if (this.hasDebug()) {
            Debug.println("Added file state cache for " + filesysName);
        }
        this.m_stateCaches.put(filesysName, stateCache);
        stateCache.stateCacheStarted();
    }

    public final void removeStateCache(String filesysName) {
        FileStateCache stateCache = this.m_stateCaches.remove(filesysName);
        if (this.hasDebug()) {
            Debug.println("Removed file state table for " + filesysName);
        }
        stateCache.stateCacheShuttingDown();
    }

    @Override
    public void run() {
        this.m_shutdown = false;
        while (!this.m_shutdown) {
            try {
                Thread.sleep(this.getCheckInterval());
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.m_shutdown) {
                if (this.hasDebug()) {
                    Debug.println("FileStateReaper thread closing");
                }
                return;
            }
            if (this.m_stateCaches == null || this.m_stateCaches.size() <= 0) continue;
            try {
                Enumeration<String> filesysNames = this.m_stateCaches.keys();
                while (filesysNames.hasMoreElements()) {
                    String filesysName = filesysNames.nextElement();
                    FileStateCache stateCache = this.m_stateCaches.get(filesysName);
                    int cnt = stateCache.removeExpiredFileStates();
                    if (!this.hasDebug() || cnt <= 0) continue;
                    Debug.println("Expired " + cnt + " file states for " + filesysName + ", cache=" + stateCache.numberOfStates());
                }
            }
            catch (Exception ex) {
                if (this.m_shutdown) continue;
                Debug.println(ex);
            }
        }
    }

    public final void shutdownRequest() {
        Enumeration<String> filesysNames = this.m_stateCaches.keys();
        while (filesysNames.hasMoreElements()) {
            String filesysName = filesysNames.nextElement();
            this.removeStateCache(filesysName);
        }
        this.m_shutdown = true;
        if (this.m_thread != null) {
            try {
                this.m_thread.interrupt();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

