/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.server.filesys.cache;

import java.util.HashMap;
import org.filesys.server.filesys.FileStatus;
import org.filesys.server.filesys.cache.FileState;
import org.filesys.server.filesys.pseudo.PseudoFileList;

public class LocalFileState
extends FileState {
    private static final long serialVersionUID = 1L;
    private int m_fileId = -1;
    private FileState.DataStatus m_dataStatus = FileState.DataStatus.Available;
    private HashMap<String, Object> m_cache;
    private PseudoFileList m_pseudoFiles;
    private Object m_filesysObj;

    public LocalFileState(String fname, boolean caseSensitive) {
        super(fname, caseSensitive);
    }

    public LocalFileState(String fname, FileStatus status, boolean caseSensitive) {
        super(fname, status, caseSensitive);
    }

    @Override
    public int getFileId() {
        return this.m_fileId;
    }

    @Override
    public FileState.DataStatus getDataStatus() {
        return this.m_dataStatus;
    }

    @Override
    public void setFileId(int id) {
        this.m_fileId = id;
    }

    @Override
    public void setDataStatus(FileState.DataStatus sts) {
        this.m_dataStatus = sts;
    }

    @Override
    public boolean hasPseudoFiles() {
        if (this.m_pseudoFiles != null) {
            return this.m_pseudoFiles.numberOfFiles() > 0;
        }
        return false;
    }

    @Override
    protected PseudoFileList getPseudoFileList(boolean createList) {
        if (this.m_pseudoFiles == null && createList) {
            this.m_pseudoFiles = new PseudoFileList();
        }
        return this.m_pseudoFiles;
    }

    @Override
    public final boolean isCopyState() {
        return false;
    }

    @Override
    public Object getFilesystemObject() {
        return this.m_filesysObj;
    }

    @Override
    public void setFilesystemObject(Object filesysObj) {
        this.m_filesysObj = filesysObj;
    }

    @Override
    protected HashMap<String, Object> getAttributeMap(boolean createMap) {
        if (this.m_cache == null && createMap) {
            this.m_cache = new HashMap();
        }
        return this.m_cache;
    }
}

