/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.server.filesys.cache.cluster;

import java.io.IOException;
import org.filesys.server.filesys.cache.cluster.ClusterFileState;
import org.filesys.server.filesys.cache.cluster.ClusterFileStateCache;
import org.filesys.server.filesys.cache.cluster.ClusterInterface;
import org.filesys.server.filesys.cache.cluster.ClusterNode;
import org.filesys.server.filesys.cache.cluster.ClusterNodeList;
import org.filesys.server.locking.OpLockManager;
import org.filesys.server.thread.ThreadRequestPool;
import org.filesys.smb.server.notify.NotifyChangeHandler;

public abstract class ClusterBase
implements ClusterInterface {
    public static final String DefaultClusterName = "JFileSrvCluster";
    public static final long DefaultLowPriorityQueueInterval = -2L;
    private String m_clusterName = "JFileSrvCluster";
    private ClusterNodeList m_nodes;
    private ClusterNode m_localNode;
    private ClusterFileStateCache m_stateCache;
    private OpLockManager m_oplockManager;
    private NotifyChangeHandler m_notifyHandler;
    private ThreadRequestPool m_threadPool;
    private boolean m_sendNotExist = false;
    private boolean m_debug;

    public ClusterBase(ClusterFileStateCache stateCache, String clusterName, ThreadRequestPool threadPool) {
        if (clusterName != null) {
            this.m_clusterName = clusterName;
        }
        this.m_stateCache = stateCache;
        this.m_nodes = new ClusterNodeList();
        this.m_threadPool = threadPool;
        this.m_debug = stateCache.hasDebug();
    }

    @Override
    public abstract void startCluster() throws Exception;

    @Override
    public abstract void shutdownCluster() throws Exception;

    @Override
    public final String getClusterName() {
        return this.m_clusterName;
    }

    @Override
    public final ClusterNodeList getNodeList() {
        return this.m_nodes;
    }

    @Override
    public final ClusterNode getLocalNode() {
        return this.m_localNode;
    }

    @Override
    public final ClusterFileStateCache getStateCache() {
        return this.m_stateCache;
    }

    @Override
    public final ThreadRequestPool getThreadPool() {
        return this.m_threadPool;
    }

    @Override
    public final boolean hasDebug() {
        return this.m_debug;
    }

    @Override
    public final boolean hasSendNotExistStates() {
        return this.m_sendNotExist;
    }

    @Override
    public final OpLockManager getOpLockManager() {
        return this.m_oplockManager;
    }

    @Override
    public final NotifyChangeHandler getNotifyChangeHandler() {
        return this.m_notifyHandler;
    }

    @Override
    public final void setSendNotExistStates(boolean notExist) {
        this.m_sendNotExist = notExist;
    }

    @Override
    public final void setOpLockManager(OpLockManager oplockMgr) {
        this.m_oplockManager = oplockMgr;
    }

    @Override
    public final void setNotifyChangeHandler(NotifyChangeHandler notifyHandler) {
        this.m_notifyHandler = notifyHandler;
    }

    @Override
    public final void setNodeList(ClusterNodeList nodeList) {
        this.m_nodes = nodeList;
    }

    @Override
    public final void setLocalNode(ClusterNode localNode) {
        this.m_localNode = localNode;
    }

    public abstract void requestOplockBreak(ClusterNode var1, ClusterFileState var2) throws IOException;
}

