/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.server.filesys.cache.cluster;

import org.filesys.debug.Debug;
import org.filesys.server.filesys.DiskDeviceContext;
import org.filesys.server.filesys.DiskSharedDevice;
import org.filesys.server.filesys.cache.FileStateCache;
import org.filesys.server.filesys.cache.StateCacheException;
import org.filesys.server.filesys.cache.cluster.ClusterFileState;
import org.filesys.server.filesys.cache.cluster.ClusterInterface;
import org.filesys.server.filesys.cache.cluster.ClusterNode;
import org.filesys.server.filesys.cache.cluster.ClusterNodeList;
import org.filesys.server.filesys.cache.cluster.PerNodeState;
import org.filesys.server.locking.OpLockManager;

public abstract class ClusterFileStateCache
extends FileStateCache {
    private ClusterInterface m_cluster;
    private ClusterNodeList m_purgeList = new ClusterNodeList();

    @Override
    public boolean isClusteredCache() {
        return true;
    }

    public abstract PerNodeState getPerNodeState(ClusterFileState var1, boolean var2);

    public abstract PerNodeState getPerNodeState(String var1, boolean var2);

    public abstract boolean canReadFile(ClusterFileState var1, long var2, long var4, int var6);

    public abstract boolean canWriteFile(ClusterFileState var1, long var2, long var4, int var6);

    public abstract void updateFileState(ClusterFileState var1, int var2);

    @Override
    public void setDriverDetails(DiskSharedDevice diskDev) {
        if (diskDev.getContext() != null && diskDev.getContext() instanceof DiskDeviceContext) {
            DiskDeviceContext diskCtx = (DiskDeviceContext)diskDev.getContext();
            OpLockManager oplockMgr = diskCtx.getOpLockManager();
            this.m_cluster.setOpLockManager(oplockMgr);
            this.m_cluster.setNotifyChangeHandler(diskCtx.getChangeHandler());
        }
    }

    public final ClusterInterface getCluster() {
        return this.m_cluster;
    }

    protected final void setCluster(ClusterInterface cluster) {
        this.m_cluster = cluster;
    }

    @Override
    public void stateCacheStarted() {
        if (this.hasStateCacheListener()) {
            this.getStateCacheListener().stateCacheInitializing();
        }
        if (this.m_cluster != null) {
            try {
                this.m_cluster.startCluster();
            }
            catch (Exception ex) {
                throw new StateCacheException("Failed to start cluster", ex);
            }
        }
    }

    @Override
    public void stateCacheShuttingDown() {
        block5: {
            if (this.hasStateCacheListener()) {
                this.getStateCacheListener().stateCacheShuttingDown();
            }
            if (this.hasDumpOnShutdown()) {
                this.dumpCache(false);
            }
            if (this.m_cluster != null) {
                try {
                    this.m_cluster.shutdownCluster();
                }
                catch (Exception ex) {
                    if (!this.hasDebug()) break block5;
                    Debug.println(ex);
                }
            }
        }
    }

    protected final void addNodeToPurgeList(ClusterNode clNode) {
        this.m_purgeList.addNode(clNode);
    }

    public final void clusterRunning() {
        if (this.hasStateCacheListener()) {
            this.getStateCacheListener().stateCacheRunning();
        }
    }
}

