/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.server.filesys.cache.cluster;

import org.filesys.server.filesys.cache.cluster.ClusterBase;
import org.filesys.server.filesys.cache.cluster.ClusterFileStateCache;
import org.filesys.server.filesys.cache.cluster.ClusterInterface;

public abstract class ClusterNode {
    private String m_name;
    private Object m_address;
    private boolean m_local;
    private int m_state;
    private int m_priority;
    private ClusterInterface m_cluster;

    public ClusterNode(String name, int priority, ClusterInterface cluster, Object addr) {
        this.m_name = name;
        this.m_address = addr;
        this.m_priority = priority;
        this.m_cluster = cluster;
    }

    public ClusterNode(String name, int priority, boolean localNode, ClusterInterface cluster, Object addr) {
        this.m_name = name;
        this.m_address = addr;
        this.m_priority = priority;
        this.m_local = localNode;
        this.m_cluster = cluster;
    }

    public final String getName() {
        return this.m_name;
    }

    public final Object getAddress() {
        return this.m_address;
    }

    public final boolean isLocalNode() {
        return this.m_local;
    }

    public final ClusterInterface getCluster() {
        return this.m_cluster;
    }

    public final ClusterFileStateCache getStateCache() {
        ClusterFileStateCache clCache = null;
        if (this.m_cluster != null) {
            clCache = this.m_cluster.getStateCache();
        }
        return clCache;
    }

    public final int getPriority() {
        return this.m_priority;
    }

    public final int getState() {
        return this.m_state;
    }

    public abstract String getStateAsString();

    public final void setLocalNode(boolean localNode) {
        this.m_local = localNode;
    }

    public final void setName(String name) {
        this.m_name = name;
    }

    public final void setCluster(ClusterBase cluster) {
        this.m_cluster = cluster;
    }

    public final void setPriority(int priority) {
        this.m_priority = priority;
    }

    public final void setState(int state) {
        this.m_state = state;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ClusterNode)) {
            return false;
        }
        ClusterNode clNode = (ClusterNode)obj;
        return clNode.getAddress().equals(this.getAddress());
    }

    public boolean nameMatches(String name) {
        return this.getName().equalsIgnoreCase(name);
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("[");
        str.append(this.getName());
        str.append(this.isLocalNode() ? ":Local," : ":Remote,");
        str.append(this.getStateAsString());
        str.append(",Priority=");
        str.append(this.getPriority());
        str.append("]");
        return str.toString();
    }
}

