/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.server.filesys.cache.hazelcast;

import java.io.Serializable;
import org.filesys.server.filesys.CreateDisposition;
import org.filesys.server.filesys.FileOpenParams;
import org.filesys.server.filesys.FileStatus;
import org.filesys.server.filesys.cache.cluster.ClusterNode;
import org.filesys.smb.ImpersonationLevel;
import org.filesys.smb.OpLockType;
import org.filesys.smb.SharingMode;

public class GrantAccessParams
implements Serializable {
    private static final long serialVersionUID = 2L;
    private String m_ownerName;
    private int m_pid;
    private FileStatus m_fileSts;
    private int m_accessMode;
    private SharingMode m_sharedAccess;
    private ImpersonationLevel m_secLevel;
    private int m_createOptions;
    private CreateDisposition m_openAction;
    private OpLockType m_oplock = OpLockType.LEVEL_NONE;

    public GrantAccessParams() {
    }

    public GrantAccessParams(ClusterNode clNode, FileOpenParams openParams, FileStatus fileSts) {
        this.m_ownerName = clNode.getName();
        this.m_fileSts = fileSts;
        this.m_pid = openParams.getProcessId();
        this.m_accessMode = openParams.getAccessMode();
        this.m_sharedAccess = openParams.getSharedAccess();
        this.m_secLevel = openParams.getSecurityLevel();
        this.m_createOptions = openParams.getCreateOptions();
        this.m_openAction = openParams.getOpenAction();
        if (openParams.requestBatchOpLock()) {
            this.m_oplock = OpLockType.LEVEL_BATCH;
        } else if (openParams.requestExclusiveOpLock()) {
            this.m_oplock = OpLockType.LEVEL_EXCLUSIVE;
        }
    }

    public final String getOwnerName() {
        return this.m_ownerName;
    }

    public final FileStatus getFileStatus() {
        return this.m_fileSts;
    }

    public final int getProcessId() {
        return this.m_pid;
    }

    public final SharingMode getSharedAccess() {
        return this.m_sharedAccess;
    }

    public final CreateDisposition getOpenAction() {
        return this.m_openAction;
    }

    public final boolean hasSecurityLevel() {
        return this.m_secLevel != ImpersonationLevel.INVALID;
    }

    public final ImpersonationLevel getSecurityLevel() {
        return this.m_secLevel;
    }

    public final boolean isReadOnlyAccess() {
        return (this.m_accessMode & 3) == 1;
    }

    public final boolean isWriteOnlyAccess() {
        return (this.m_accessMode & 3) == 2;
    }

    public final boolean isReadWriteAccess() {
        return (this.m_accessMode & 3) == 3;
    }

    public final boolean isAttributesOnlyAccess() {
        return (this.m_accessMode & 7) == 0 && (this.m_accessMode & 0x180) != 0;
    }

    public final int getAccessMode() {
        return this.m_accessMode;
    }

    public final boolean hasOpLockRequest() {
        return this.m_oplock != OpLockType.LEVEL_NONE;
    }

    public final OpLockType getOpLockType() {
        return this.m_oplock;
    }

    public final boolean isDirectory() {
        return this.hasCreateOption(1) || this.getFileStatus() == FileStatus.DirectoryExists;
    }

    protected final boolean hasCreateOption(int flag) {
        return (this.m_createOptions & flag) != 0;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("[Owner=");
        str.append(this.getOwnerName());
        str.append(",pid=");
        str.append(this.getProcessId());
        str.append(",fileSts=");
        str.append(this.getFileStatus().name());
        str.append(",openAction=");
        str.append(this.getOpenAction().name());
        str.append(",create=0x");
        str.append(Integer.toHexString(this.m_createOptions));
        str.append(",access=0x");
        str.append(Integer.toHexString(this.getAccessMode()));
        str.append(",sharing=");
        str.append(this.getSharedAccess().name());
        str.append(",secLevel=");
        str.append((Object)this.getSecurityLevel());
        str.append(",oplock=");
        str.append(this.getOpLockType().name());
        if (this.isDirectory()) {
            str.append(" DIR");
        }
        str.append("]");
        return str.toString();
    }
}

