/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.server.filesys.cache.hazelcast;

import com.hazelcast.core.Cluster;
import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IExecutorService;
import com.hazelcast.core.IMap;
import com.hazelcast.core.ITopic;
import com.hazelcast.core.MapEvent;
import com.hazelcast.core.Member;
import com.hazelcast.core.MemberAttributeEvent;
import com.hazelcast.core.MembershipEvent;
import com.hazelcast.core.MembershipListener;
import com.hazelcast.core.Message;
import com.hazelcast.core.Partition;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.filesys.debug.Debug;
import org.filesys.locking.FileLock;
import org.filesys.locking.FileLockList;
import org.filesys.locking.LockConflictException;
import org.filesys.locking.NotLockedException;
import org.filesys.server.RequestPostProcessor;
import org.filesys.server.config.CoreServerConfigSection;
import org.filesys.server.config.InvalidConfigurationException;
import org.filesys.server.config.ServerConfiguration;
import org.filesys.server.filesys.AccessDeniedException;
import org.filesys.server.filesys.DeferFailedException;
import org.filesys.server.filesys.ExistingOpLockException;
import org.filesys.server.filesys.FileAccessToken;
import org.filesys.server.filesys.FileExistsException;
import org.filesys.server.filesys.FileOpenParams;
import org.filesys.server.filesys.FileSharingException;
import org.filesys.server.filesys.FileStatus;
import org.filesys.server.filesys.NetworkFile;
import org.filesys.server.filesys.NotifyAction;
import org.filesys.server.filesys.cache.FileState;
import org.filesys.server.filesys.cache.FileStateProxy;
import org.filesys.server.filesys.cache.LocalFileStateProxy;
import org.filesys.server.filesys.cache.cluster.ClusterFileLock;
import org.filesys.server.filesys.cache.cluster.ClusterFileState;
import org.filesys.server.filesys.cache.cluster.ClusterFileStateCache;
import org.filesys.server.filesys.cache.cluster.ClusterInterface;
import org.filesys.server.filesys.cache.cluster.ClusterNode;
import org.filesys.server.filesys.cache.cluster.ClusterNodeList;
import org.filesys.server.filesys.cache.cluster.PerNodeState;
import org.filesys.server.filesys.cache.hazelcast.ClusterConfigSection;
import org.filesys.server.filesys.cache.hazelcast.ClusterMessage;
import org.filesys.server.filesys.cache.hazelcast.DataUpdateMessage;
import org.filesys.server.filesys.cache.hazelcast.GrantAccessParams;
import org.filesys.server.filesys.cache.hazelcast.HazelCastAccessToken;
import org.filesys.server.filesys.cache.hazelcast.HazelCastClusterFileState;
import org.filesys.server.filesys.cache.hazelcast.HazelCastClusterNode;
import org.filesys.server.filesys.cache.hazelcast.OpLockMessage;
import org.filesys.server.filesys.cache.hazelcast.RemoteOpLockDetails;
import org.filesys.server.filesys.cache.hazelcast.RemoveOpLockTask;
import org.filesys.server.filesys.cache.hazelcast.StateRenameMessage;
import org.filesys.server.filesys.cache.hazelcast.StateUpdateMessage;
import org.filesys.server.filesys.cache.hazelcast.StateUpdatePostProcessor;
import org.filesys.server.locking.LocalOpLockDetails;
import org.filesys.server.locking.OpLockDetails;
import org.filesys.server.locking.OpLockManager;
import org.filesys.server.thread.ThreadRequestPool;
import org.filesys.smb.OpLockType;
import org.filesys.smb.SharingMode;
import org.filesys.smb.server.SMBSrvPacket;
import org.filesys.smb.server.SMBSrvSession;
import org.filesys.smb.server.notify.NotifyChangeHandler;
import org.springframework.extensions.config.ConfigElement;

public abstract class HazelCastClusterFileStateCache
extends ClusterFileStateCache
implements ClusterInterface,
MembershipListener {
    public static final int DebugStateCache = 1;
    public static final int DebugExpire = 2;
    public static final int DebugNearCache = 4;
    public static final int DebugOplock = 8;
    public static final int DebugByteLock = 16;
    public static final int DebugFileAccess = 32;
    public static final int DebugMembership = 64;
    public static final int DebugCleanup = 128;
    public static final int DebugPerNode = 256;
    public static final int DebugClusterEntry = 512;
    public static final int DebugClusterMessage = 1024;
    public static final int DebugRemoteTask = 2048;
    public static final int DebugRemoteTiming = 4096;
    public static final int DebugRename = 8192;
    public static final int DebugFileDataUpdate = 16384;
    public static final int DebugFileStatus = 32768;
    private static final String[] _debugLevels = new String[]{"StateCache", "Expire", "NearCache", "Oplock", "ByteLock", "FileAccess", "Membership", "Cleanup", "PerNode", "ClusterEntry", "ClusterMessage", "RemoteTask", "RemoteTiming", "Rename", "FileDataUpdate", "FileStatus"};
    protected static final String ExecutorName = "Executor";
    public static final long DefaultNearCacheTimeout = 5000L;
    public static final long MinimumNearCacheTimeout = 3000L;
    public static final long MaximumNearCacheTimeout = 120000L;
    private final int DisableAllStateUpdates = -1;
    protected String m_clusterName;
    protected String m_topicName;
    protected ClusterConfigSection m_clusterConfig;
    protected HazelcastInstance m_hazelCastInstance;
    protected Cluster m_cluster;
    protected IMap<String, HazelCastClusterFileState> m_stateCache;
    protected ITopic<ClusterMessage> m_clusterTopic;
    protected HashMap<String, PerNodeState> m_perNodeCache;
    protected ConcurrentHashMap<String, HazelCastClusterFileState> m_nearCache;
    protected long m_nearCacheTimeout = 5000L;
    protected ThreadRequestPool m_threadPool;
    protected ClusterNodeList m_nodes;
    protected ClusterNode m_localNode;
    protected OpLockManager m_oplockManager;
    protected NotifyChangeHandler m_notifyHandler;
    protected boolean m_sendNotExist = false;
    private int m_debugFlags;

    @Override
    public void initializeCache(ConfigElement config, ServerConfiguration srvConfig) throws InvalidConfigurationException {
        super.initializeCache(config, srvConfig);
        this.m_clusterConfig = (ClusterConfigSection)srvConfig.getConfigSection("HazelcastCluster");
        if (this.m_clusterConfig == null) {
            throw new InvalidConfigurationException("Cluster configuration not available");
        }
        ConfigElement elem = config.getChild("clusterName");
        if (elem != null && elem.getValue() != null) {
            this.m_clusterName = elem.getValue();
            if (this.m_clusterName == null || this.m_clusterName.length() == 0) {
                throw new InvalidConfigurationException("Empty cluster name");
            }
        } else {
            throw new InvalidConfigurationException("Cluster name not specified");
        }
        elem = config.getChild("clusterTopic");
        if (elem != null && elem.getValue() != null) {
            this.m_topicName = elem.getValue();
            if (this.m_topicName == null || this.m_topicName.length() == 0) {
                throw new InvalidConfigurationException("Empty cluster topic name");
            }
        } else {
            throw new InvalidConfigurationException("Cluster topic name not specified");
        }
        elem = config.getChild("nearCache");
        boolean useNearCache = true;
        if (elem != null) {
            String disableNear = elem.getAttribute("disable");
            if (Boolean.parseBoolean(disableNear)) {
                useNearCache = false;
            }
            String cacheTmo = elem.getAttribute("timeout");
            try {
                this.m_nearCacheTimeout = Long.parseLong(cacheTmo) * 1000L;
                if (this.m_nearCacheTimeout < 3000L || this.m_nearCacheTimeout > 120000L) {
                    throw new InvalidConfigurationException("Near-cache timeout value out of valid range (3-120)");
                }
            }
            catch (NumberFormatException ex) {
                throw new InvalidConfigurationException("Invalid near-cache timeout value specified, " + cacheTmo);
            }
        }
        if (useNearCache) {
            this.m_nearCache = new ConcurrentHashMap();
        }
        CoreServerConfigSection coreConfig = (CoreServerConfigSection)srvConfig.getConfigSection("CoreServer");
        this.m_threadPool = coreConfig.getThreadPool();
        this.setCluster(this);
        this.m_perNodeCache = new HashMap();
        elem = config.getChild("cacheDebug");
        if (elem != null) {
            String flags = elem.getAttribute("flags");
            int cacheDbg = 0;
            if (flags != null) {
                flags = flags.toUpperCase();
                StringTokenizer token = new StringTokenizer(flags, ",");
                while (token.hasMoreTokens()) {
                    int idx;
                    String dbg = token.nextToken().trim();
                    for (idx = 0; idx < _debugLevels.length && !_debugLevels[idx].equalsIgnoreCase(dbg); ++idx) {
                    }
                    if (idx >= _debugLevels.length) {
                        throw new InvalidConfigurationException("Invalid state cache debug flag, " + dbg);
                    }
                    cacheDbg += 1 << idx;
                }
            }
            this.m_debugFlags = cacheDbg;
        }
    }

    @Override
    public int numberOfStates() {
        return this.m_stateCache != null ? this.m_stateCache.size() : 0;
    }

    public Enumeration<String> enumerateCache() {
        return null;
    }

    @Override
    public void dumpCache(boolean dumpAttribs) {
        Set localKeys;
        if (this.m_stateCache.size() > 0) {
            Debug.println("++ HazelCastFileStateCache Entries:");
        }
        if ((localKeys = this.m_stateCache.localKeySet()).size() == 0) {
            return;
        }
        Iterator keysIter = localKeys.iterator();
        long curTime = System.currentTimeMillis();
        while (keysIter.hasNext()) {
            String fname = (String)keysIter.next();
            FileState state = (FileState)this.m_stateCache.get((Object)fname);
            Debug.println("++  " + fname + "(" + state.getSecondsToExpire(curTime) + ") : " + state.toString());
            if (!dumpAttribs) continue;
            state.DumpAttributes();
        }
    }

    @Override
    public FileStateProxy getFileStateProxy(FileState fstate) {
        return new LocalFileStateProxy(fstate);
    }

    public final boolean hasNearCache() {
        return this.m_nearCache != null;
    }

    @Override
    public FileState findFileState(String path) {
        HazelCastClusterFileState fstate = (HazelCastClusterFileState)this.m_stateCache.get((Object)FileState.normalizePath(path, this.isCaseSensitive()));
        if (fstate != null) {
            fstate.setStateCache(this);
        }
        return fstate;
    }

    @Override
    public FileState findFileState(String path, boolean create) {
        return this.findFileState(path, create, FileStatus.Unknown);
    }

    @Override
    public FileState findFileState(String path, boolean create, FileStatus status) {
        String normPath = FileState.normalizePath(path, this.isCaseSensitive());
        HazelCastClusterFileState state = this.getStateFromNearCache(normPath);
        if (state == null) {
            state = (HazelCastClusterFileState)this.m_stateCache.get((Object)normPath);
        }
        if (this.hasDebugLevel(1)) {
            Debug.println("findFileState path=" + path + ", create=" + create + ", sts=" + status.name() + ", state=" + state);
        }
        if (state == null && create) {
            HazelCastClusterFileState curState;
            state = new HazelCastClusterFileState(path, this.isCaseSensitive());
            state.setExpiryTime(System.currentTimeMillis() + this.getFileStateExpireInterval());
            if (status != FileStatus.Unknown) {
                state.setFileStatus(status);
            }
            if ((curState = (HazelCastClusterFileState)this.m_stateCache.putIfAbsent((Object)state.getPath(), (Object)state)) != null) {
                if (this.hasDebugLevel(1)) {
                    Debug.println("Using existing state from putIfAbsent() returnedState=" + curState);
                    Debug.println("  newState=" + state);
                }
                state = curState;
            }
            if (this.hasDebugLevel(1)) {
                Debug.println("findFileState created state=" + state);
            }
            if (this.hasNearCache()) {
                state.setNearCacheTime();
                this.m_nearCache.put(normPath, state);
                if (this.hasDebugLevel(4)) {
                    Debug.println("Added state to near-cache state=" + state);
                }
            }
        }
        if (state != null) {
            state.setStateCache(this);
        }
        return state;
    }

    @Override
    public FileState removeFileState(String path) {
        String normPath = FileState.normalizePath(path, this.isCaseSensitive());
        FileState state = (FileState)this.m_stateCache.remove((Object)normPath);
        this.m_perNodeCache.remove(normPath);
        if (this.hasDebugLevel(1)) {
            Debug.println("removeFileState path=" + path + ", state=" + state);
        }
        if (this.hasNearCache()) {
            HazelCastClusterFileState hcState = this.m_nearCache.remove(normPath);
            if (this.hasDebugLevel(4)) {
                Debug.println("Removed state from near-cache state=" + hcState);
            }
        }
        if (this.hasStateListener() && state != null) {
            this.getStateListener().fileStateClosed(state);
        }
        return state;
    }

    @Override
    public void renameFileState(String newPath, FileState state, boolean isDir) {
        block15: {
            if (this.hasDebugLevel(8192)) {
                Debug.println("Request rename via remote call, curPath=" + state.getPath() + ", newPath=" + newPath + ", isDir=" + isDir);
            }
            String oldPath = state.getPath();
            String newPathNorm = FileState.normalizePath(newPath, this.isCaseSensitive());
            try {
                if (this.executeRenameFileState(state.getPath(), newPathNorm, isDir)) {
                    String newNormPath = FileState.normalizePath(newPath, this.isCaseSensitive());
                    PerNodeState perNode = this.m_perNodeCache.remove(oldPath);
                    if (perNode != null) {
                        this.m_perNodeCache.put(newNormPath, perNode);
                    }
                    if (this.hasNearCache()) {
                        HazelCastClusterFileState hcState = this.m_nearCache.remove(oldPath);
                        if (hcState != null) {
                            hcState.setPathInternal(newNormPath);
                            hcState.setFileStatusInternal(isDir ? FileStatus.DirectoryExists : FileStatus.FileExists, FileState.ChangeReason.None);
                            hcState.removeAllAttributes();
                            this.m_nearCache.put(hcState.getPath(), hcState);
                            if (this.hasDebugLevel(4)) {
                                Debug.println("Rename near-cache entry, from=" + oldPath + ", to=" + hcState);
                            }
                        } else if (state instanceof HazelCastClusterFileState) {
                            hcState = (HazelCastClusterFileState)state;
                            hcState.setNearCacheTime();
                            hcState.setPathInternal(newNormPath);
                            this.m_nearCache.put(newNormPath, hcState);
                            if (this.hasDebugLevel(4)) {
                                Debug.println("Added state to near-cache state=" + state + " (rename)");
                            }
                        }
                    }
                    StateRenameMessage stateRenameMsg = new StateRenameMessage("*", this.m_localNode, state.getPath(), newPath, isDir);
                    this.m_clusterTopic.publish((Object)stateRenameMsg);
                    if (this.hasDebugLevel(1024)) {
                        Debug.println("Sent file state rename to cluster, state=" + state + ", msg=" + stateRenameMsg);
                    }
                    break block15;
                }
                throw new RuntimeException("Rename state task failed, state=" + state);
            }
            catch (ExecutionException ex) {
                if (this.hasDebugLevel(8192)) {
                    Debug.println("Error renaming state, fstate=" + state + ", newPath=" + newPath);
                    Debug.println(ex);
                }
                throw new RuntimeException("Failed to rename state " + state.getPath(), ex);
            }
            catch (InterruptedException ex2) {
                if (this.hasDebugLevel(8192)) {
                    Debug.println("Error renaming state, fstate=" + state + ", newPath=" + newPath);
                    Debug.println(ex2);
                }
                throw new RuntimeException("Failed to rename state " + state.getPath(), ex2);
            }
        }
    }

    @Override
    public void removeAllFileStates() {
        if (this.hasNearCache()) {
            this.m_nearCache.clear();
        }
        this.m_perNodeCache.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int removeExpiredFileStates() {
        HazelCastClusterFileState hcState;
        if (this.m_stateCache == null) {
            return 0;
        }
        Set localKeys = this.m_stateCache.localKeySet();
        int expiredCnt = 0;
        if (localKeys.size() > 0) {
            if (this.hasDebugLevel(2)) {
                Debug.println("Removing expired file states from local partition");
            }
            Iterator keysIter = localKeys.iterator();
            long curTime = System.currentTimeMillis();
            int openCnt = 0;
            while (keysIter.hasNext()) {
                ClusterFileState state = (ClusterFileState)this.m_stateCache.get(keysIter.next());
                if (state == null || state.isPermanentState()) continue;
                ClusterFileState clusterFileState = state;
                synchronized (clusterFileState) {
                    if (state.hasExpired(curTime) && state.getOpenCount() == 0) {
                        if (this.hasStateListener() && this.getStateListener().fileStateExpired(state)) {
                            hcState = (HazelCastClusterFileState)this.m_stateCache.remove((Object)state.getPath());
                            PerNodeState perNode = this.m_perNodeCache.remove(state.getPath());
                            if (this.hasDebugLevel(2)) {
                                Debug.println("++ Expired file state=" + hcState + ", perNode=" + perNode);
                            }
                            ++expiredCnt;
                        }
                    } else if (state.getOpenCount() > 0) {
                        ++openCnt;
                    }
                }
            }
            if (this.hasDebugLevel(2)) {
                Debug.println("++ Open files " + openCnt);
                this.dumpCache(false);
            }
        }
        boolean nearDebug = this.hasDebugLevel(4);
        long checkTime = System.currentTimeMillis() - this.m_nearCacheTimeout;
        int nearExpireCnt = 0;
        if (this.hasNearCache() && this.m_nearCache.size() > 0) {
            Enumeration<String> nearEnum = this.m_nearCache.keys();
            while (nearEnum.hasMoreElements()) {
                String nearKey = nearEnum.nextElement();
                hcState = this.m_nearCache.get(nearKey);
                if (!hcState.isStateValid() || hcState.getNearCacheLastAccessTime() >= checkTime) continue;
                this.m_nearCache.remove(nearKey);
                ++nearExpireCnt;
                hcState.setStateValid(false);
                if (!nearDebug) continue;
                Debug.println("Removed from near-cache state=" + hcState);
            }
            if (nearDebug && nearExpireCnt > 0) {
                Debug.println("Removed " + nearExpireCnt + " states from near-cache, " + this.m_nearCache.size() + " states remaining");
            }
        }
        return expiredCnt;
    }

    @Override
    public OpLockDetails getOpLock(FileState fstate) {
        OpLockDetails oplock = null;
        if (fstate.hasOpLock()) {
            RemoteOpLockDetails remoteOplock;
            ClusterNode clNode;
            PerNodeState perNode = this.m_perNodeCache.get(fstate.getPath());
            if (perNode != null && perNode.hasOpLock()) {
                oplock = perNode.getOpLock();
            }
            if (oplock == null && (oplock = fstate.getOpLock()) instanceof RemoteOpLockDetails && (clNode = this.m_nodes.findNode((remoteOplock = (RemoteOpLockDetails)oplock).getOwnerName())).isLocalNode()) {
                oplock = null;
                HazelCastClusterFileState hcState = this.getStateFromNearCache(fstate.getPath());
                if (hcState != null) {
                    hcState.clearOpLock();
                }
                if (this.hasDebugLevel(8)) {
                    Debug.println("Local oplock out of sync, cleared near cache for " + fstate);
                }
            }
        }
        return oplock;
    }

    @Override
    public boolean addOpLock(FileState fstate, OpLockDetails oplock, NetworkFile netFile) throws ExistingOpLockException {
        HazelCastAccessToken hcToken;
        FileAccessToken token;
        ClusterFileState clState;
        if (!(oplock instanceof LocalOpLockDetails)) {
            throw new RuntimeException("Attempt to add non-local oplock to file state " + fstate.getPath());
        }
        if (this.hasDebugLevel(8)) {
            Debug.println("Add oplock for state=" + fstate + ", oplock=" + oplock);
        }
        if ((clState = (ClusterFileState)fstate).hasLocalOpLock()) {
            LocalOpLockDetails grantedOplock = clState.getLocalOpLock();
            LocalOpLockDetails reqOplock = (LocalOpLockDetails)oplock;
            if (reqOplock.getPath().equalsIgnoreCase(grantedOplock.getPath()) && reqOplock.getLockType() == grantedOplock.getLockType() && reqOplock.hasOplockOwner() && reqOplock.getOplockOwner().equals(grantedOplock.getOplockOwner())) {
                try {
                    clState.clearLocalOpLock();
                    clState.setLocalOpLock(reqOplock);
                }
                catch (ExistingOpLockException ex) {
                    Debug.println(ex);
                }
                if (this.hasDebugLevel(8)) {
                    Debug.println("Oplock already granted via file access check, oplock=" + grantedOplock);
                }
                return true;
            }
        } else if (netFile.hasAccessToken() && (token = netFile.getAccessToken()) != null && token instanceof HazelCastAccessToken && !(hcToken = (HazelCastAccessToken)token).isOplockAvailable()) {
            if (this.hasDebugLevel(8)) {
                Debug.println("Oplock not available, via access token=" + hcToken);
            }
            return false;
        }
        RemoteOpLockDetails remoteOpLock = new RemoteOpLockDetails(this.getLocalNode(), oplock, this);
        if (this.hasDebugLevel(8)) {
            Debug.println("Request oplock via remote call, remoteOplock=" + remoteOpLock);
        }
        boolean sts = false;
        try {
            if (this.executeAddOpLock(fstate.getPath(), remoteOpLock)) {
                HazelCastClusterFileState hcState;
                clState.setLocalOpLock((LocalOpLockDetails)oplock);
                if (this.hasNearCache() && (hcState = this.getStateFromNearCache(fstate.getPath())) != null) {
                    hcState.setOpLock(remoteOpLock);
                    if (this.hasDebugLevel(4)) {
                        Debug.println("Added oplock to near-cache state=" + hcState);
                    }
                }
                sts = true;
            }
        }
        catch (ExecutionException ex) {
            if (this.hasDebugLevel(8)) {
                Debug.println("Error adding oplock, fstate=" + fstate + ", oplock=" + oplock);
                Debug.println(ex);
            }
            throw new ExistingOpLockException("Failed to execute remote oplock add on " + fstate.getPath(), ex);
        }
        catch (InterruptedException ex2) {
            if (this.hasDebugLevel(8)) {
                Debug.println("Error adding oplock, fstate=" + fstate + ", oplock=" + oplock);
                Debug.println(ex2);
            }
            throw new ExistingOpLockException("Failed to execute remote oplock add on " + fstate.getPath(), ex2);
        }
        return sts;
    }

    @Override
    public void clearOpLock(FileState fstate) {
        PerNodeState perNode;
        ClusterFileState clState = (ClusterFileState)fstate;
        if (this.hasDebugLevel(8)) {
            Debug.println("Clear oplock for state=" + fstate);
        }
        if ((perNode = this.m_perNodeCache.get(clState.getPath())) != null && perNode.hasOpLock()) {
            IExecutorService execService = this.m_hazelCastInstance.getExecutorService(ExecutorName);
            RemoveOpLockTask callable = new RemoveOpLockTask(this.getClusterName(), fstate.getPath(), this.hasTaskDebug(), this.hasTaskTiming());
            Future removeOpLockTask = execService.submitToKeyOwner((Callable)callable, (Object)fstate.getPath());
            try {
                HazelCastClusterFileState hcState;
                this.executeClearOpLock(fstate.getPath());
                if (this.hasNearCache() && (hcState = this.getStateFromNearCache(fstate.getPath())) != null) {
                    hcState.clearOpLock();
                    if (this.hasDebugLevel(4)) {
                        Debug.println("Cleared oplock from near-cache state=" + hcState);
                    }
                }
            }
            catch (Exception ex) {
                Debug.println(ex, 1);
            }
            OpLockMessage oplockMsg = new OpLockMessage("*", 2, clState.getPath());
            this.m_clusterTopic.publish((Object)oplockMsg);
        } else if (this.hasDebugLevel(8)) {
            Debug.println("No local oplock found for " + fstate);
        }
    }

    public FileLock createFileLockObject(NetworkFile file, long offset, long len, int pid) {
        return new ClusterFileLock(this.m_localNode, offset, len, pid);
    }

    @Override
    public boolean hasActiveLocks(FileState fstate) {
        return fstate.hasActiveLocks();
    }

    @Override
    public void addLock(FileState fstate, FileLock lock) throws LockConflictException {
        if (!(lock instanceof ClusterFileLock)) {
            throw new RuntimeException("Attempt to add non-cluster byte lock to file state " + fstate.getPath());
        }
        if (this.hasDebugLevel(16)) {
            Debug.println("Add byte lock for state=" + fstate + ", lock=" + lock);
        }
        try {
            ClusterFileState clState = this.executeAddLock(fstate.getPath(), (ClusterFileLock)lock);
            this.updateNearCacheState(clState);
        }
        catch (ExecutionException ex) {
            if (this.hasDebugLevel(16)) {
                Debug.println("Error adding byte lock, fstate=" + fstate + ", lock=" + lock);
                Debug.println(ex);
            }
            throw new LockConflictException("Failed to execute remote lock add on " + fstate.getPath(), ex);
        }
        catch (InterruptedException ex2) {
            if (this.hasDebugLevel(16)) {
                Debug.println("Error adding byte lock, fstate=" + fstate + ", lock=" + lock);
                Debug.println(ex2);
            }
            throw new LockConflictException("Failed to execute remote lock add on " + fstate.getPath(), ex2);
        }
    }

    @Override
    public void removeLock(FileState fstate, FileLock lock) throws NotLockedException {
        if (!(lock instanceof ClusterFileLock)) {
            throw new RuntimeException("Attempt to remove non-cluster byte lock from file state " + fstate.getPath());
        }
        if (this.hasDebugLevel(16)) {
            Debug.println("Remove byte lock for state=" + fstate + ", lock=" + lock);
        }
        try {
            ClusterFileState clState = this.executeRemoveLock(fstate.getPath(), (ClusterFileLock)lock);
            this.updateNearCacheState(clState);
        }
        catch (ExecutionException ex) {
            if (this.hasDebugLevel(16)) {
                Debug.println("Error removing byte lock, fstate=" + fstate + ", lock=" + lock);
                Debug.println(ex);
            }
            throw new NotLockedException("Failed to execute remote unlock add on " + fstate.getPath(), ex);
        }
        catch (InterruptedException ex2) {
            if (this.hasDebugLevel(16)) {
                Debug.println("Error removing byte lock, fstate=" + fstate + ", lock=" + lock);
                Debug.println(ex2);
            }
            throw new NotLockedException("Failed to execute remote unlock add on " + fstate.getPath(), ex2);
        }
    }

    @Override
    public void startCluster() throws Exception {
        if (this.hasDebug()) {
            Debug.println("Starting cluster, name=" + this.getClusterName());
        }
        this.m_hazelCastInstance = this.m_clusterConfig.getHazelcastInstance();
        this.m_cluster = this.m_hazelCastInstance.getCluster();
        this.rebuildClusterNodeList();
        this.m_cluster.addMembershipListener((MembershipListener)this);
        this.m_stateCache = this.m_hazelCastInstance.getMap(this.getClusterName());
        if (this.m_stateCache == null) {
            throw new Exception("Failed to initialize state cache, " + this.getClusterName());
        }
        this.m_clusterTopic = this.m_hazelCastInstance.getTopic(this.m_topicName);
        if (this.m_clusterTopic == null) {
            throw new Exception("Failed to initialize cluster topic, " + this.m_topicName);
        }
    }

    @Override
    public void shutdownCluster() throws Exception {
        if (this.hasDebug()) {
            Debug.println("Shutting cluster, name=" + this.getClusterName());
        }
    }

    @Override
    public void requestOplockBreak(String path, OpLockDetails oplock, SMBSrvSession sess, SMBSrvPacket pkt) throws IOException, DeferFailedException {
        String normPath = FileState.normalizePath(path, this.isCaseSensitive());
        PerNodeState perNode = this.m_perNodeCache.get(normPath);
        if (perNode != null && perNode.hasOpLock()) {
            LocalOpLockDetails localOpLock = perNode.getOpLock();
            localOpLock.addDeferredSession(sess, pkt);
            if (this.hasDebugLevel(8)) {
                Debug.println("Request oplock break, path=" + path + ", via local oplock=" + localOpLock);
            }
            localOpLock.requestOpLockBreak();
        } else if (oplock instanceof RemoteOpLockDetails) {
            RemoteOpLockDetails remoteOplock;
            ClusterNode clNode;
            if (this.hasDebugLevel(8)) {
                Debug.println("Request oplock break, path=" + path + ", via remote oplock=" + oplock);
            }
            if ((clNode = this.m_nodes.findNode((remoteOplock = (RemoteOpLockDetails)oplock).getOwnerName())) == null) {
                if (this.hasDebugLevel(8)) {
                    Debug.println("Cannot find node details for " + remoteOplock.getOwnerName());
                }
                throw new IOException("Cannot find remote oplock node details for " + remoteOplock.getOwnerName());
            }
            if (clNode.isLocalNode()) {
                throw new IOException("Attempt to send remote oplock break to local node, path=" + path);
            }
            remoteOplock.setStateCache(this);
            remoteOplock.addDeferredSession(sess, pkt);
            OpLockMessage oplockMsg = new OpLockMessage(clNode.getName(), 1, normPath);
            this.m_clusterTopic.publish((Object)oplockMsg);
        } else if (this.hasDebugLevel(8)) {
            Debug.println("Unable to send oplock break, oplock=" + oplock);
        }
    }

    @Override
    public void changeOpLockType(OpLockDetails oplock, OpLockType newTyp) {
        block12: {
            if (this.hasDebugLevel(8)) {
                Debug.println("Change oplock type to=" + newTyp.name() + " for oplock=" + oplock);
            }
            String normPath = FileState.normalizePath(oplock.getPath(), this.isCaseSensitive());
            try {
                OpLockType newOplockType = this.executeChangeOpLockType(normPath, newTyp);
                if (newOplockType == newTyp) {
                    HazelCastClusterFileState hcState;
                    PerNodeState perNode = this.m_perNodeCache.get(normPath);
                    if (perNode != null && perNode.hasOpLock()) {
                        LocalOpLockDetails localOpLock = perNode.getOpLock();
                        localOpLock.setLockType(newTyp);
                    }
                    if (this.hasNearCache() && (hcState = this.getStateFromNearCache(normPath)) != null) {
                        if (hcState.hasOpLock()) {
                            hcState.getOpLock().setLockType(newTyp);
                            if (this.hasDebugLevel(4)) {
                                Debug.println("Near-cache updated oplock type to=" + newTyp.name() + ", nearState=" + hcState);
                            }
                        } else {
                            hcState.setStateValid(false);
                            if (this.hasDebugLevel(4)) {
                                Debug.println("Near-cache no oplock, marked as invalid, nearState=" + hcState);
                            }
                        }
                    }
                    OpLockMessage oplockMsg = new OpLockMessage("*", 6, normPath);
                    this.m_clusterTopic.publish((Object)oplockMsg);
                } else if (this.hasDebugLevel(8)) {
                    Debug.println("Failed to change oplock type, no oplock on file state, path=" + oplock.getPath());
                }
            }
            catch (Exception ex) {
                if (!this.hasDebugLevel(8)) break block12;
                Debug.println("Error changing oplock type to=" + newTyp.name() + ", for oplock=" + oplock);
                Debug.println(ex);
            }
        }
    }

    public void memberAdded(MembershipEvent membershipEvent) {
        if (this.hasDebugLevel(64)) {
            Debug.println("Cluster added member " + membershipEvent.getMember());
        }
        this.rebuildClusterNodeList();
    }

    public void memberRemoved(MembershipEvent membershipEvent) {
        if (this.hasDebugLevel(64)) {
            Debug.println("Cluster removed member " + membershipEvent.getMember());
        }
        this.rebuildClusterNodeList();
        this.removeMemberData(membershipEvent.getMember());
    }

    public void memberAttributeChanged(MemberAttributeEvent attributeEvent) {
    }

    public void mapEvicted(MapEvent event) {
    }

    public void mapCleared(MapEvent event) {
    }

    private final synchronized void rebuildClusterNodeList() {
        if (this.hasDebugLevel(64)) {
            Debug.println("Rebuilding cluster node list");
        }
        ClusterNodeList curList = this.getNodeList();
        ClusterNodeList newList = new ClusterNodeList();
        Set members = this.m_cluster.getMembers();
        Iterator iterMembers = members.iterator();
        int nodeId = 1;
        while (iterMembers.hasNext()) {
            Member curMember = (Member)iterMembers.next();
            ClusterNode clNode = null;
            String clName = curMember.getSocketAddress().toString();
            if (curList != null && curList.numberOfNodes() > 0) {
                clNode = curList.findNode(clName);
            }
            if (clNode == null) {
                clNode = new HazelCastClusterNode(clName, nodeId, (ClusterInterface)this, curMember);
            } else {
                clNode.setPriority(nodeId);
            }
            newList.addNode(clNode);
            if (clNode.isLocalNode()) {
                this.setLocalNode(clNode);
            }
            ++nodeId;
        }
        this.setNodeList(newList);
        if (this.hasDebugLevel(64)) {
            Debug.println("  New member list: " + newList);
        }
    }

    protected int removeMemberData(Member member) {
        if (this.m_stateCache == null) {
            return 0;
        }
        Set localKeys = this.m_stateCache.localKeySet();
        if (localKeys.size() == 0) {
            return 0;
        }
        if (this.hasDebugLevel(128)) {
            Debug.println("Removing state data for member " + member);
        }
        String memberName = member.toString();
        int stateCnt = 0;
        Iterator keysIter = localKeys.iterator();
        while (keysIter.hasNext()) {
            RemoteOpLockDetails oplock;
            HazelCastClusterFileState state = (HazelCastClusterFileState)this.m_stateCache.get(keysIter.next());
            String primaryOwner = (String)state.getPrimaryOwner();
            if (primaryOwner != null && primaryOwner.equals(memberName)) {
                if (state.getOpenCount() > 0) {
                    state.decrementOpenCount();
                }
                state.setSharedAccess(SharingMode.ALL);
                state.setPrimaryOwner(null);
                if (this.hasDebugLevel(128)) {
                    Debug.println("  Cleared primary owner, state=" + state);
                }
            }
            if (state.hasActiveLocks()) {
                RemoteOpLockDetails oplock2;
                ClusterFileLock curLock;
                int idx;
                FileLockList lockList = state.getLockList();
                int lockCnt = 0;
                for (idx = 0; idx < lockList.numberOfLocks(); ++idx) {
                    curLock = (ClusterFileLock)lockList.getLockAt(idx);
                    if (!curLock.getOwnerNode().equalsIgnoreCase(memberName)) continue;
                    ++lockCnt;
                }
                if (this.hasDebugLevel(128) && lockCnt > 0) {
                    Debug.println("  Removing " + lockCnt + " file locks, state=" + state);
                }
                this.m_stateCache.lock((Object)state.getPath());
                state = (HazelCastClusterFileState)this.m_stateCache.get((Object)state.getPath());
                lockList = state.getLockList();
                idx = 0;
                while (idx < lockList.numberOfLocks()) {
                    curLock = (ClusterFileLock)lockList.getLockAt(idx);
                    if (curLock.getOwnerNode().equalsIgnoreCase(memberName)) {
                        lockList.removeLockAt(idx);
                        continue;
                    }
                    ++idx;
                }
                if (state.hasOpLock() && (oplock2 = (RemoteOpLockDetails)state.getOpLock()).getOwnerName().equalsIgnoreCase(memberName)) {
                    state.clearOpLock();
                    if (this.hasDebugLevel(128)) {
                        Debug.println("  And removing oplock");
                    }
                }
                this.m_stateCache.put((Object)state.getPath(), (Object)state);
                this.m_stateCache.unlock((Object)state.getPath());
                ++stateCnt;
            }
            if (!state.hasOpLock() || !(oplock = (RemoteOpLockDetails)state.getOpLock()).getOwnerName().equalsIgnoreCase(memberName)) continue;
            if (this.hasDebugLevel(128)) {
                Debug.println("  Removing oplock, state=" + state);
            }
            this.m_stateCache.lock((Object)state.getPath());
            state = (HazelCastClusterFileState)this.m_stateCache.get((Object)state.getPath());
            state.clearOpLock();
            this.m_stateCache.put((Object)state.getPath(), (Object)state);
            this.m_stateCache.unlock((Object)state.getPath());
            ++stateCnt;
        }
        return stateCnt;
    }

    @Override
    public PerNodeState getPerNodeState(ClusterFileState fState, boolean createState) {
        PerNodeState perNode = this.m_perNodeCache.get(fState.getPath());
        if (perNode == null && createState) {
            perNode = new PerNodeState();
            this.m_perNodeCache.put(fState.getPath(), perNode);
        }
        return perNode;
    }

    @Override
    public PerNodeState getPerNodeState(String path, boolean createState) {
        String normPath = FileState.normalizePath(path, this.isCaseSensitive());
        PerNodeState perNode = this.m_perNodeCache.get(normPath);
        if (perNode == null && createState) {
            perNode = new PerNodeState();
            this.m_perNodeCache.put(normPath, perNode);
        }
        return perNode;
    }

    @Override
    public FileAccessToken grantFileAccess(FileOpenParams params, FileState fstate, FileStatus fileSts) throws FileSharingException, AccessDeniedException, FileExistsException {
        if (this.hasDebugLevel(32)) {
            Debug.println("Grant file access for state=" + fstate + ", params=" + params + ", fileSts=" + fileSts.name());
        }
        GrantAccessParams grantParams = new GrantAccessParams(this.getLocalNode(), params, fileSts);
        HazelCastAccessToken accessToken = null;
        try {
            HazelCastClusterFileState hcState;
            accessToken = this.executeGrantFileAccess(fstate.getPath(), grantParams);
            accessToken.setNetworkFilePath(params.getPath());
            accessToken.setReleased(false);
            if (accessToken.getOpLockType() != OpLockType.LEVEL_NONE) {
                HazelCastClusterFileState hcState2;
                LocalOpLockDetails localOplock = new LocalOpLockDetails(accessToken.getOpLockType(), params.getFullPath(), (SMBSrvSession)params.getSession(), params.getOplockOwner(), fileSts == FileStatus.DirectoryExists);
                ClusterFileState clState = (ClusterFileState)fstate;
                clState.setLocalOpLock(localOplock);
                if (this.hasNearCache() && (hcState2 = this.getStateFromNearCache(fstate.getPath())) != null) {
                    RemoteOpLockDetails remoteOpLock = new RemoteOpLockDetails(this.getLocalNode(), localOplock, this);
                    hcState2.setOpLock(remoteOpLock);
                    hcState2.setOpenCount(1);
                    if (this.hasDebugLevel(4)) {
                        Debug.println("Added oplock to near-cache (via grant access) state=" + hcState2);
                    }
                }
            } else if (this.hasNearCache() && (hcState = this.getStateFromNearCache(fstate.getPath())) != null) {
                hcState.incrementOpenCount();
                if (this.hasDebugLevel(4)) {
                    Debug.println("Update near-cache open count state=" + hcState);
                }
            }
            this.clearLowPriorityStateUpdates(-1);
        }
        catch (ExistingOpLockException ex) {
            if (this.hasDebugLevel(32)) {
                Debug.println("Error saving oplock, fstate=" + fstate + ", params=" + params);
                Debug.println(ex);
            }
        }
        catch (ExecutionException ex) {
            if (this.hasDebugLevel(32)) {
                Debug.println("Error granting access, fstate=" + fstate + ", params=" + params);
                Debug.println(ex);
            }
            if (ex.getCause() != null) {
                if (ex.getCause() instanceof FileSharingException) {
                    throw (FileSharingException)ex.getCause();
                }
                if (ex.getCause() instanceof AccessDeniedException) {
                    throw (AccessDeniedException)ex.getCause();
                }
            }
            throw new AccessDeniedException("Failed to execute remote grant access on " + fstate.getPath(), ex);
        }
        catch (InterruptedException ex) {
            if (this.hasDebugLevel(32)) {
                Debug.println("Error granting access, fstate=" + fstate + ", params=" + params);
                Debug.println(ex);
            }
            throw new AccessDeniedException("Failed to execute remote grant access on " + fstate.getPath(), ex);
        }
        return accessToken;
    }

    @Override
    public int releaseFileAccess(FileState fstate, FileAccessToken token) {
        int openCnt;
        block14: {
            if (token == null) {
                return fstate.getOpenCount();
            }
            if (!(token instanceof HazelCastAccessToken)) {
                throw new RuntimeException("Attempt to release Invalid access token type=" + token.getClass().getCanonicalName() + ", file state " + fstate.getPath());
            }
            if (this.hasDebugLevel(32)) {
                Debug.println("Release file access for state=" + fstate + ", token=" + token);
            }
            if (this.hasNearCache()) {
                this.m_nearCache.remove(fstate.getPath());
            }
            openCnt = -1;
            try {
                HazelCastClusterFileState hcState;
                openCnt = this.executeReleaseFileAccess(fstate.getPath(), (HazelCastAccessToken)token);
                HazelCastAccessToken hcToken = (HazelCastAccessToken)token;
                hcToken.setReleased(true);
                PerNodeState perNode = this.m_perNodeCache.get(fstate.getPath());
                if (perNode != null && perNode.hasOpLock() && (openCnt == 0 || hcToken.getOpLockType() != OpLockType.LEVEL_NONE)) {
                    if (perNode.getOpLock().hasBreakInProgress()) {
                        OpLockMessage oplockMsg = new OpLockMessage("*", 2, fstate.getPath());
                        this.m_clusterTopic.publish((Object)oplockMsg);
                        if (this.hasDebugLevel(40)) {
                            Debug.println("Sent oplock break notify for in-progress break, file closed to release oplock, state=" + fstate);
                        }
                    }
                    perNode.clearOpLock();
                    if (this.hasDebugLevel(40)) {
                        Debug.println("Cleared local oplock during token release, token=" + token);
                    }
                }
                if (this.hasNearCache() && (hcState = this.getStateFromNearCache(fstate.getPath())) != null) {
                    hcState.setOpenCount(openCnt);
                    if (this.hasDebugLevel(4)) {
                        Debug.println("Update near-cache open count state=" + hcState);
                    }
                    if (openCnt == 0 || hcToken.getOpLockType() != OpLockType.LEVEL_NONE) {
                        hcState.clearOpLock();
                        if (this.hasDebugLevel(4)) {
                            Debug.println("Cleared oplock from near-cache (release token) state=" + hcState);
                        }
                    }
                }
            }
            catch (Exception ex) {
                if (!this.hasDebugLevel(32)) break block14;
                Debug.println("Error releasing access, fstate=" + fstate + ", token=" + token);
                Debug.println(ex);
            }
        }
        return openCnt;
    }

    @Override
    public boolean canReadFile(ClusterFileState clState, long offset, long len, int pid) {
        boolean canRead = true;
        if (clState.getOpenCount() > 1) {
            canRead = this.checkFileAccess(clState, offset, len, pid, false);
        } else if (this.hasDebugLevel(16)) {
            Debug.println("Check file readable for state=" + clState + ", fileCount=" + clState.getOpenCount());
        }
        return canRead;
    }

    @Override
    public boolean canWriteFile(ClusterFileState clState, long offset, long len, int pid) {
        boolean canWrite = true;
        if (clState.getOpenCount() > 1) {
            canWrite = this.checkFileAccess(clState, offset, len, pid, true);
        } else if (this.hasDebugLevel(16)) {
            Debug.println("Check file writeable for state=" + clState + ", fileCount=" + clState.getOpenCount());
        }
        return canWrite;
    }

    protected boolean checkFileAccess(ClusterFileState clState, long offset, long len, int pid, boolean writeCheck) {
        boolean canAccess;
        block3: {
            ClusterFileLock checkLock = new ClusterFileLock(this.getLocalNode(), offset, len, pid);
            if (this.hasDebugLevel(16)) {
                Debug.println("Check file " + (writeCheck ? "writeable" : "readable") + " for state=" + clState + ", area=" + checkLock);
            }
            canAccess = false;
            try {
                canAccess = this.executeCheckFileAccess(clState.getPath(), checkLock, writeCheck);
            }
            catch (Exception ex) {
                if (!this.hasDebugLevel(16)) break block3;
                Debug.println("Error checking file access, fstate=" + clState + ", area=" + checkLock);
                Debug.println(ex);
            }
        }
        return canAccess;
    }

    protected boolean remoteUpdateState(ClusterFileState clState, int updateMask) {
        boolean stateUpdated;
        block8: {
            if (this.hasDebugLevel(34816)) {
                Debug.println("Remote state update state=" + clState + ", updateMask=" + ClusterFileState.getUpdateMaskAsString(updateMask));
            }
            if (updateMask != 8) {
                throw new RuntimeException("Remote state update for " + ClusterFileState.getUpdateMaskAsString(updateMask) + " not supported");
            }
            stateUpdated = false;
            try {
                stateUpdated = this.executeRemoteUpdateState(clState.getPath(), clState.getFileStatus());
                if (stateUpdated) {
                    HazelCastClusterFileState hcState;
                    this.updateFileState(clState, updateMask);
                    if (this.hasNearCache() && (hcState = this.getStateFromNearCache(clState.getPath())) != null) {
                        hcState.setFileStatusInternal(clState.getFileStatus(), clState.getStatusChangeReason());
                        if (clState.getFileStatus() == FileStatus.NotExist) {
                            hcState.setFileId(-1);
                            hcState.removeAllAttributes();
                        }
                        if (this.hasDebugLevel(4)) {
                            Debug.println("Updated near-cache file status, state=" + hcState);
                        }
                    }
                }
            }
            catch (Exception ex) {
                if (!this.hasDebugLevel(34816)) break block8;
                Debug.println("Error updating status, fstate=" + clState + ", updateMask=" + ClusterFileState.getUpdateMaskAsString(updateMask));
                Debug.println(ex);
            }
        }
        return stateUpdated;
    }

    @Override
    public void updateFileState(ClusterFileState clState, int updateMask) {
        StateUpdateMessage stateUpdMsg = new StateUpdateMessage("*", this.m_localNode, clState, updateMask);
        this.m_clusterTopic.publish((Object)stateUpdMsg);
        if (this.hasDebugLevel(1024)) {
            Debug.println("Sent file state update to cluster, state=" + clState + ", update=" + ClusterFileState.getUpdateMaskAsString(updateMask));
        }
    }

    @Override
    public String getClusterName() {
        return this.m_clusterName;
    }

    @Override
    public ClusterNodeList getNodeList() {
        return this.m_nodes;
    }

    @Override
    public ClusterNode getLocalNode() {
        return this.m_localNode;
    }

    @Override
    public ClusterFileStateCache getStateCache() {
        return this;
    }

    @Override
    public ThreadRequestPool getThreadPool() {
        return this.m_threadPool;
    }

    @Override
    public boolean hasSendNotExistStates() {
        return this.m_sendNotExist;
    }

    @Override
    public OpLockManager getOpLockManager() {
        return this.m_oplockManager;
    }

    public boolean hasNotifyChangeHandler() {
        return this.m_notifyHandler != null;
    }

    @Override
    public NotifyChangeHandler getNotifyChangeHandler() {
        return this.m_notifyHandler;
    }

    @Override
    public void setSendNotExistStates(boolean notExist) {
        this.m_sendNotExist = notExist;
    }

    @Override
    public void setOpLockManager(OpLockManager oplockMgr) {
        this.m_oplockManager = oplockMgr;
    }

    @Override
    public void setNotifyChangeHandler(NotifyChangeHandler notifyHandler) {
        this.m_notifyHandler = notifyHandler;
    }

    @Override
    public void setNodeList(ClusterNodeList nodeList) {
        this.m_nodes = nodeList;
    }

    @Override
    public void setLocalNode(ClusterNode localNode) {
        this.m_localNode = localNode;
    }

    public final boolean hasDebugLevel(int flg) {
        return (this.m_debugFlags & flg) != 0;
    }

    public final boolean hasTaskDebug() {
        return this.hasDebugLevel(2048);
    }

    public final boolean hasTaskTiming() {
        return this.hasDebugLevel(4096);
    }

    public void entryAdded(EntryEvent<String, HazelCastClusterFileState> event) {
        if (this.hasDebugLevel(512)) {
            Debug.println("EntryAdded: key=" + (String)event.getKey());
        }
    }

    public void entryRemoved(EntryEvent<String, HazelCastClusterFileState> event) {
        HazelCastClusterFileState hcState;
        PerNodeState perNode;
        if (this.hasDebugLevel(512)) {
            Debug.println("EntryRemoved: key=" + (String)event.getKey());
        }
        if ((perNode = this.m_perNodeCache.remove(event.getKey())) != null && this.hasDebugLevel(256)) {
            Debug.println("Removed entry " + (String)event.getKey() + " from per-node cache (remote remove), perNode=" + perNode);
        }
        if (this.hasNearCache() && (hcState = this.m_nearCache.remove(event.getKey())) != null && this.hasDebugLevel(4)) {
            Debug.println("Removed entry from near-cache (remote remove), state=" + hcState);
        }
    }

    public void entryUpdated(EntryEvent<String, HazelCastClusterFileState> event) {
        HazelCastClusterFileState hcState;
        if (this.hasDebugLevel(512)) {
            Debug.println("EntryUpdated: key=" + (String)event.getKey());
        }
        if (this.hasNearCache() && (hcState = this.getStateFromNearCache((String)event.getKey())) != null) {
            hcState.setNearRemoteUpdateTime();
            if (this.hasDebugLevel(4)) {
                Debug.println("Near-cache remote update time state=" + hcState);
            }
        }
    }

    public void entryEvicted(EntryEvent<String, HazelCastClusterFileState> event) {
        HazelCastClusterFileState hcState;
        if (this.hasDebugLevel(512)) {
            Debug.println("EntryEvicted: key=" + (String)event.getKey());
        }
        if (this.hasNearCache() && (hcState = this.m_nearCache.remove(event.getKey())) != null && this.hasDebugLevel(4)) {
            Debug.println("Removed entry " + (String)event.getKey() + " from near-cache (remote evict), state=" + hcState);
        }
    }

    public void onMessage(Message<ClusterMessage> hzMessage) {
        ClusterMessage msg = (ClusterMessage)hzMessage.getMessageObject();
        if (msg.isAllNodes() || this.m_localNode.nameMatches(msg.getTargetNode())) {
            switch (msg.isType()) {
                case 1: {
                    this.procOpLockBreakRequest((OpLockMessage)msg);
                    break;
                }
                case 2: {
                    this.procOpLockBreakNotify((OpLockMessage)msg);
                    break;
                }
                case 6: {
                    this.procOpLockTypeChange((OpLockMessage)msg);
                    break;
                }
                case 3: {
                    this.procFileStateUpdate((StateUpdateMessage)msg);
                    break;
                }
                case 4: {
                    this.procFileStateRename((StateRenameMessage)msg);
                    break;
                }
                case 5: {
                    this.procDataUpdate((DataUpdateMessage)msg);
                    break;
                }
                default: {
                    if (!this.hasDebugLevel(1024)) break;
                    Debug.println("Unknown cluster message msg=" + msg);
                }
            }
        }
    }

    protected void procOpLockBreakRequest(OpLockMessage msg) {
        PerNodeState perNode;
        if (this.hasDebugLevel(1032)) {
            Debug.println("Process oplock break request msg=" + msg);
        }
        if ((perNode = this.m_perNodeCache.get(msg.getPath())) != null && perNode.hasOpLock()) {
            LocalOpLockDetails localOpLock = perNode.getOpLock();
            if (this.hasDebugLevel(1032)) {
                Debug.println("Request oplock break, path=" + msg.getPath() + ", via local oplock=" + localOpLock);
            }
            try {
                localOpLock.requestOpLockBreak();
            }
            catch (Exception ex) {
                if (this.hasDebugLevel(1032)) {
                    Debug.println("Oplock break failed, ex=" + ex);
                }
            }
        } else if (this.hasDebugLevel(1032)) {
            OpLockMessage oplockMsg = new OpLockMessage(msg.getFromNode(), 2, msg.getPath());
            this.m_clusterTopic.publish((Object)oplockMsg);
            Debug.println("No oplock on path=" + msg.getPath());
        }
    }

    protected void procOpLockBreakNotify(OpLockMessage msg) {
        PerNodeState perNode;
        HazelCastClusterFileState hcState;
        if (this.hasDebugLevel(1032)) {
            Debug.println("Process oplock break notify msg=" + msg);
        }
        if (this.hasNearCache() && (hcState = this.getStateFromNearCache(msg.getPath())) != null) {
            hcState.setStateValid(false);
        }
        if ((perNode = this.m_perNodeCache.get(msg.getPath())) != null && perNode.hasDeferredSessions()) {
            this.m_oplockManager.cancelOplockTimer(msg.getPath());
            perNode.requeueDeferredRequests();
        }
    }

    protected void procOpLockTypeChange(OpLockMessage msg) {
        if (this.hasDebugLevel(1032)) {
            Debug.println("Process oplock change type msg=" + msg);
        }
        if (!msg.isFromLocalNode(this.m_localNode)) {
            PerNodeState perNode;
            HazelCastClusterFileState hcState;
            if (this.hasNearCache() && (hcState = this.getStateFromNearCache(msg.getPath())) != null) {
                hcState.setStateValid(false);
            }
            if ((perNode = this.m_perNodeCache.get(msg.getPath())) != null && perNode.hasDeferredSessions()) {
                this.m_oplockManager.cancelOplockTimer(msg.getPath());
                perNode.requeueDeferredRequests();
            }
        }
    }

    protected void procFileStateUpdate(StateUpdateMessage msg) {
        if (this.hasDebugLevel(1024)) {
            Debug.println("Process file state update msg=" + msg);
        }
        HazelCastClusterFileState clState = null;
        if (this.isLocalKey(msg.getPath()) && msg.getUpdateMask() != 8) {
            this.m_stateCache.lock((Object)msg.getPath());
            clState = (HazelCastClusterFileState)this.m_stateCache.get((Object)msg.getPath());
            if (clState != null) {
                clState.updateState(msg);
                this.m_stateCache.put((Object)msg.getPath(), (Object)clState);
                if (this.hasDebugLevel(1024)) {
                    Debug.println("Updated file status, state=" + clState);
                }
            }
            this.m_stateCache.unlock((Object)msg.getPath());
        }
        if (!msg.isFromLocalNode(this.m_localNode)) {
            PerNodeState perNode;
            HazelCastClusterFileState hcState;
            FileState.ChangeReason reason = msg.getStatusChangeReason();
            if (this.hasNearCache() && (hcState = this.getStateFromNearCache(msg.getPath())) != null) {
                hcState.updateState(msg);
                if (msg.hasUpdate(8) && hcState.getFileStatus() == FileStatus.NotExist) {
                    hcState.setFileStatusInternal(FileStatus.Unknown, FileState.ChangeReason.None);
                }
                if (reason == FileState.ChangeReason.FileDeleted || reason == FileState.ChangeReason.FileCreated) {
                    hcState.setFileId(-1);
                    hcState.removeAllAttributes();
                    if (this.hasDebugLevel(4)) {
                        Debug.println("File " + (reason == FileState.ChangeReason.FileCreated ? " Created" : "Deleted") + ", path=" + msg.getPath() + ", cleared file id/attributes");
                    }
                }
                if (this.hasDebugLevel(4)) {
                    Debug.println("Updated near-cache file state=" + hcState);
                }
            }
            if ((perNode = this.m_perNodeCache.get(msg.getPath())) != null && (reason == FileState.ChangeReason.FileDeleted || reason == FileState.ChangeReason.FileCreated)) {
                perNode.setFileId(-1);
                perNode.remoteAllAttributes();
                if (this.hasDebugLevel(256)) {
                    Debug.println("Reset fileId, removed attributes for path=" + msg.getPath() + ", perNode=" + perNode + ", reason=" + reason.name());
                }
            }
            if (this.hasNotifyChangeHandler() && msg.hasUpdate(8) && msg.getStatusChangeReason() != FileState.ChangeReason.None) {
                FileState.ChangeReason reasonCode = msg.getStatusChangeReason();
                String path = msg.getPath();
                switch (reasonCode) {
                    case FileCreated: {
                        this.getNotifyChangeHandler().notifyFileChanged(NotifyAction.Added, path);
                        break;
                    }
                    case FolderCreated: {
                        this.getNotifyChangeHandler().notifyDirectoryChanged(NotifyAction.Added, path);
                        break;
                    }
                    case FileDeleted: {
                        this.getNotifyChangeHandler().notifyFileChanged(NotifyAction.Removed, path);
                        break;
                    }
                    case FolderDeleted: {
                        this.getNotifyChangeHandler().notifyDirectoryChanged(NotifyAction.Removed, path);
                    }
                }
                if (this.hasDebugLevel(1024)) {
                    Debug.println("Sent change notification path=" + path + ", reason=" + reasonCode.name());
                }
            }
        }
    }

    protected void procFileStateRename(StateRenameMessage msg) {
        if (this.hasDebugLevel(1024)) {
            Debug.println("Process file state rename msg=" + msg);
        }
        if (!msg.isFromLocalNode(this.m_localNode)) {
            HazelCastClusterFileState hcState;
            PerNodeState perNode = this.m_perNodeCache.remove(msg.getOldPath());
            if (perNode != null) {
                this.m_perNodeCache.put(msg.getNewPath(), perNode);
            }
            if (this.hasNearCache() && (hcState = this.m_nearCache.remove(msg.getOldPath())) != null) {
                hcState.setPath(msg.getNewPath(), this.isCaseSensitive());
                hcState.removeAllAttributes();
                this.m_nearCache.put(hcState.getPath(), hcState);
                if (this.hasDebugLevel(4)) {
                    Debug.println("Rename near-cache entry (remote), from=" + msg.getOldPath() + ", to=" + hcState);
                }
            }
            if (this.hasNotifyChangeHandler()) {
                this.getNotifyChangeHandler().notifyRename(msg.getOldPath(), msg.getNewPath());
                if (this.hasDebugLevel(1024)) {
                    Debug.println("Sent rename change notification newPath=" + msg.getNewPath());
                }
            }
        }
        if (msg.isFolderPath()) {
            HazelCastClusterFileState hcState;
            String newPath;
            String oldPathPrefix = msg.getOldPath();
            if (!oldPathPrefix.endsWith("\\")) {
                oldPathPrefix = oldPathPrefix + "\\";
            }
            oldPathPrefix = FileState.normalizePath(oldPathPrefix, this.isCaseSensitive());
            String newPathPrefix = msg.getNewPath();
            if (!newPathPrefix.endsWith("\\")) {
                newPathPrefix = newPathPrefix + "\\";
            }
            newPathPrefix = FileState.normalizePath(newPathPrefix, this.isCaseSensitive());
            Set localKeys = this.m_stateCache.localKeySet();
            StringBuilder newStatePath = new StringBuilder(newPathPrefix.length() + 64);
            newStatePath.append(newPathPrefix);
            if (localKeys.size() > 0) {
                if (this.hasDebugLevel(8192)) {
                    Debug.println("Rename folder, checking local cache entries, oldPath=" + oldPathPrefix);
                }
                for (String curKey : localKeys) {
                    if (!curKey.startsWith(oldPathPrefix)) continue;
                    newStatePath.setLength(newPathPrefix.length());
                    newStatePath.append(curKey.substring(oldPathPrefix.length()));
                    newPath = newStatePath.toString();
                    this.m_stateCache.lock((Object)curKey);
                    hcState = (HazelCastClusterFileState)this.m_stateCache.remove((Object)curKey);
                    hcState.setPathInternal(newPath);
                    this.m_stateCache.put((Object)newPath, (Object)hcState);
                    this.m_stateCache.unlock((Object)curKey);
                    if (!this.hasDebugLevel(8192)) continue;
                    Debug.println("Renamed state path from=" + curKey + " to=" + newPath);
                }
            }
            if (this.hasNearCache()) {
                Enumeration<String> nearEnum = this.m_nearCache.keys();
                while (nearEnum.hasMoreElements()) {
                    String nearKey = nearEnum.nextElement();
                    if (!nearKey.startsWith(oldPathPrefix)) continue;
                    newStatePath.setLength(newPathPrefix.length());
                    newStatePath.append(nearKey.substring(oldPathPrefix.length()));
                    newPath = newStatePath.toString();
                    hcState = this.m_nearCache.remove(nearKey);
                    hcState.setPathInternal(newPath);
                    this.m_nearCache.put(newPath, hcState);
                    if (!this.hasDebugLevel(8196)) continue;
                    Debug.println("Renamed near-cache state from=" + nearKey + " to=" + newPath);
                }
            }
        }
    }

    protected void procDataUpdate(DataUpdateMessage msg) {
        HazelCastClusterFileState hcState;
        if (this.hasDebugLevel(1024)) {
            Debug.println("Process file data update msg=" + msg);
        }
        if (!msg.isFromLocalNode(this.m_localNode) && this.hasNearCache() && (hcState = this.m_nearCache.remove(msg.getPath())) != null) {
            if (msg.isStartOfUpdate()) {
                hcState.setDataUpdateNode(msg.getFromNode());
            } else {
                hcState.setDataUpdateNode(null);
            }
            if (this.hasDebugLevel(4)) {
                Debug.println("Data update on node=" + msg.getFromNode() + ", to=" + hcState + (msg.isStartOfUpdate() ? ", Start" : ", Completed"));
            }
        }
    }

    protected boolean isLocalKey(String path) {
        Partition keyPart = this.m_hazelCastInstance.getPartitionService().getPartition((Object)path);
        return keyPart.getOwner().equals((Member)this.m_localNode.getAddress());
    }

    protected final void clearLowPriorityStateUpdates(int updateMask) {
        StateUpdatePostProcessor updatePostProc = (StateUpdatePostProcessor)RequestPostProcessor.findPostProcessor(StateUpdatePostProcessor.class);
        if (updatePostProc != null) {
            if (updateMask == -1 || updatePostProc.getUpdateMask() == updateMask) {
                RequestPostProcessor.removePostProcessorFromQueue(updatePostProc);
                if (this.hasDebugLevel(1024)) {
                    Debug.println("Removed state update post processor");
                }
            } else {
                updatePostProc.removeFromUpdateMask(updateMask);
                if (this.hasDebugLevel(1024)) {
                    Debug.println("Removed state updates from post processor, mask=" + ClusterFileState.getUpdateMaskAsString(updateMask));
                }
            }
        }
    }

    protected final void updateNearCacheState(ClusterFileState clState) {
        if (this.hasNearCache() && clState instanceof HazelCastClusterFileState) {
            HazelCastClusterFileState curState = this.getStateFromNearCache(clState.getPath());
            HazelCastClusterFileState newState = (HazelCastClusterFileState)clState;
            if (curState != null) {
                newState.copyNearCacheDetails(curState);
            } else {
                newState.setNearCacheTime();
            }
            this.m_nearCache.put(clState.getPath(), newState);
            if (this.hasDebugLevel(4)) {
                Debug.println("Updated near-cache from task result, state=" + newState + (curState != null ? " Copied" : "New"));
            }
        }
    }

    @Override
    public void setDataUpdateInProgress(FileState fstate) {
        this.updateFileDataStatus((ClusterFileState)fstate, true);
    }

    @Override
    public void setDataUpdateCompleted(FileState fstate) {
        this.updateFileDataStatus((ClusterFileState)fstate, false);
    }

    private void updateFileDataStatus(ClusterFileState fState, boolean startUpdate) {
        block7: {
            if (this.hasDebugLevel(16384)) {
                Debug.println("File data update " + (startUpdate ? "started" : "completed") + " on state=" + fState);
            }
            try {
                if (this.executeUpdateFileDataStatus(fState.getPath(), startUpdate)) {
                    HazelCastClusterFileState nearState;
                    if (this.hasNearCache() && fState instanceof HazelCastClusterFileState && (nearState = this.getStateFromNearCache(fState.getPath())) != null) {
                        nearState.setDataUpdateNode(startUpdate ? this.getLocalNode() : null);
                        if (this.hasDebugLevel(4)) {
                            Debug.println("Updated near-cache (file data update), state=" + nearState);
                        }
                    }
                    DataUpdateMessage dataUpdMsg = new DataUpdateMessage("*", this.m_localNode, fState.getPath(), startUpdate);
                    this.m_clusterTopic.publish((Object)dataUpdMsg);
                    if (this.hasDebugLevel(1024)) {
                        Debug.println("Sent file data update to cluster, state=" + fState + ", startUpdate=" + startUpdate);
                    }
                }
            }
            catch (Exception ex) {
                if (!this.hasDebugLevel(16384)) break block7;
                Debug.println("Error setting file data update, fstate=" + fState + ", startUpdate=" + startUpdate);
                Debug.println(ex);
            }
        }
    }

    protected final HazelCastClusterFileState getStateFromNearCache(String path) {
        HazelCastClusterFileState hcState = null;
        if (this.hasNearCache() && (hcState = this.m_nearCache.get(path)) != null) {
            if (hcState.isStateValid() && !hcState.hasExpired(System.currentTimeMillis())) {
                hcState.incrementNearCacheHitCount();
                if (this.hasDebugLevel(4)) {
                    Debug.println("Found state in near-cache state=" + hcState);
                }
            } else {
                hcState = null;
                this.m_nearCache.remove(path);
                if (this.hasDebugLevel(4)) {
                    Debug.println("Removed invalid state from near-cache state=" + hcState);
                }
            }
        }
        return hcState;
    }

    public abstract boolean executeRenameFileState(String var1, String var2, boolean var3) throws InterruptedException, ExecutionException;

    public abstract boolean executeAddOpLock(String var1, RemoteOpLockDetails var2) throws InterruptedException, ExecutionException;

    public abstract void executeClearOpLock(String var1) throws InterruptedException, ExecutionException;

    public abstract ClusterFileState executeAddLock(String var1, ClusterFileLock var2) throws InterruptedException, ExecutionException;

    public abstract ClusterFileState executeRemoveLock(String var1, ClusterFileLock var2) throws InterruptedException, ExecutionException;

    public abstract OpLockType executeChangeOpLockType(String var1, OpLockType var2) throws InterruptedException, ExecutionException;

    public abstract HazelCastAccessToken executeGrantFileAccess(String var1, GrantAccessParams var2) throws InterruptedException, ExecutionException;

    public abstract int executeReleaseFileAccess(String var1, HazelCastAccessToken var2) throws InterruptedException, ExecutionException;

    public abstract boolean executeCheckFileAccess(String var1, ClusterFileLock var2, boolean var3) throws InterruptedException, ExecutionException;

    public abstract boolean executeRemoteUpdateState(String var1, FileStatus var2) throws InterruptedException, ExecutionException;

    public abstract boolean executeUpdateFileDataStatus(String var1, boolean var2) throws InterruptedException, ExecutionException;
}

