/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.server.filesys.cache.hazelcast;

import com.hazelcast.core.IMap;
import org.filesys.debug.Debug;
import org.filesys.server.filesys.FileStatus;
import org.filesys.server.filesys.cache.FileState;
import org.filesys.server.filesys.cache.cluster.ClusterFileState;
import org.filesys.server.filesys.cache.hazelcast.RemoteStateTask;

public class UpdateStateTask
extends RemoteStateTask<Boolean> {
    private static final long serialVersionUID = 1L;
    private FileStatus m_fileStatus;

    public UpdateStateTask() {
    }

    public UpdateStateTask(String mapName, String key, FileStatus fileSts, boolean debug, boolean timingDebug) {
        super(mapName, key, true, false, debug, timingDebug);
        this.m_fileStatus = fileSts;
    }

    @Override
    protected Boolean runRemoteTaskAgainstState(IMap<String, ClusterFileState> stateCache, ClusterFileState fState) throws Exception {
        if (this.hasDebug()) {
            Debug.println("UpdateStateTask: Update file status=" + this.m_fileStatus.name() + ", state=" + fState);
        }
        boolean changedSts = false;
        if (fState.getFileStatus() != this.m_fileStatus) {
            fState.setFileStatusInternal(this.m_fileStatus, FileState.ChangeReason.None);
            changedSts = true;
            if (fState.getFileStatus() == FileStatus.NotExist) {
                fState.setFileId(-1);
                fState.removeAllAttributes();
            }
            if (this.hasDebug()) {
                Debug.println("UpdateStateTask: Status updated, state=" + fState);
            }
        }
        return new Boolean(changedSts);
    }
}

