/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.server.filesys.db;

import java.io.IOException;
import org.filesys.server.filesys.NetworkFile;
import org.filesys.server.filesys.cache.FileState;
import org.filesys.server.filesys.cache.FileStateProxy;
import org.filesys.server.filesys.cache.NetworkFileStateInterface;
import org.filesys.server.filesys.db.DBFileInfo;
import org.filesys.server.filesys.loader.FileLoader;

public abstract class DBNetworkFile
extends NetworkFile
implements NetworkFileStateInterface {
    public static final String DBCacheFile = "DBCacheFile";
    private FileStateProxy m_stateProxy;
    private FileLoader m_loader;
    private String m_ownerSess;

    public DBNetworkFile(String name, int fid, int stid, int did) {
        super(fid, stid, did);
        this.setName(name);
        this.setUniqueId(fid, did);
    }

    public DBNetworkFile(String name, String fullName, int fid, int stid, int did) {
        super(fid, stid, did);
        this.setName(name);
        this.setFullName(fullName);
        this.setUniqueId(fid, did);
    }

    public final FileState.DataStatus getStatus() {
        if (this.m_stateProxy != null) {
            return this.m_stateProxy.getFileState().getDataStatus();
        }
        return FileState.DataStatus.Unknown;
    }

    public final boolean hasFileState() {
        return this.m_stateProxy != null;
    }

    @Override
    public final FileState getFileState() {
        return this.m_stateProxy.getFileState();
    }

    public final boolean hasLoader() {
        return this.m_loader != null;
    }

    public final FileLoader getLoader() {
        return this.m_loader;
    }

    public final boolean hasOwnerSessionId() {
        return this.m_ownerSess != null;
    }

    public final String getOwnerSessionId() {
        return this.m_ownerSess;
    }

    public final void setFileDetails(DBFileInfo info) {
        this.setFileId(info.getFileId());
        this.setName(info.getFileName());
        if (info.getFullName() != null && info.getFullName().length() > 0) {
            this.setFullName(info.getFullName());
        }
        this.setDirectoryId(info.getDirectoryId());
        this.setFileSize(info.getSize());
        this.setAttributes(info.getFileAttributes());
        if (info.getCreationDateTime() > 0L) {
            this.setCreationDate(info.getCreationDateTime());
        }
        if (info.getModifyDateTime() > 0L) {
            this.setModifyDate(info.getModifyDateTime());
        } else {
            this.setModifyDate(this.getCreationDate());
        }
        if (info.getAccessDateTime() > 0L) {
            this.setAccessDate(info.getAccessDateTime());
        } else {
            this.setAccessDate(this.getModifyDate());
        }
    }

    public final void setStatus(FileState.DataStatus state) {
        if (this.m_stateProxy != null) {
            this.m_stateProxy.getFileState().setDataStatus(state);
        }
    }

    public final void setOwnerSessionId(String id) {
        this.m_ownerSess = id;
    }

    public final void setFileState(FileStateProxy stateProxy) {
        this.m_stateProxy = stateProxy;
    }

    public final void setLoader(FileLoader loader) {
        this.m_loader = loader;
    }

    @Override
    public void openFile(boolean createFlag) throws IOException {
        this.setClosed(false);
    }
}

