/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.server.filesys.db;

import org.filesys.debug.Debug;
import org.filesys.server.filesys.cache.FileStateCache;
import org.filesys.server.filesys.loader.BackgroundFileLoader;
import org.filesys.server.filesys.loader.CachedFileInfo;
import org.filesys.server.filesys.loader.FileRequest;
import org.filesys.server.filesys.loader.FileRequestQueue;
import org.filesys.server.filesys.loader.MultipleFileRequest;
import org.filesys.server.filesys.loader.SingleFileRequest;

public class MemoryBackgroundLoadSave {
    public static final int StsSuccess = 0;
    public static final int StsRequeue = 1;
    public static final int StsError = 2;
    public static final int DefaultWorkerThreads = 4;
    public static final int MinimumWorkerThreads = 1;
    public static final int MaximumWorkerThreads = 50;
    public static final int RequestQueueMaxSize = 5000;
    public static final int RequestQueueMinSize = 50;
    public static final int RequestQueueDefaultSize = 200;
    public static final int RequestQueueLowWaterMark = 50;
    public static final int RequeueMinSize = 20;
    public static final long RequeueWaitTime = 500L;
    private static final String DefaultThreadName = "MemLoadSave_";
    public static final String DBFileSegmentInfo = "DBFileSegmentInfo";
    public static final long SequentialFileExpire = 3000L;
    public static final long RequestProcessedExpire = 3000L;
    public static final long RequestQueuedExpire = 10000L;
    public static final long DefaultTransactionTimeout = 5000L;
    public static final long MinimumTransactionTimeout = 2000L;
    public static final long MaximumTransactionTimeout = 60000L;
    private String m_name;
    private FileRequestQueue m_readQueue;
    private FileRequestQueue m_writeQueue;
    private int m_maxQueueSize;
    private int m_lowQueueSize;
    private ThreadWorker[] m_readThreads;
    private ThreadWorker[] m_writeThreads;
    private int m_readWorkers;
    private int m_writeWorkers;
    private boolean m_debug;
    private FileStateCache m_stateCache;
    private long m_stateTimeout;
    private BackgroundFileLoader m_fileLoader;

    public MemoryBackgroundLoadSave(FileStateCache stateCache, BackgroundFileLoader bgLoader) {
        this.m_stateCache = stateCache;
        this.m_fileLoader = bgLoader;
        this.m_readQueue = new FileRequestQueue();
        this.m_writeQueue = new FileRequestQueue();
        this.m_maxQueueSize = 200;
        this.m_lowQueueSize = 50;
        this.setName(DefaultThreadName);
    }

    public MemoryBackgroundLoadSave(String name, FileStateCache stateCache, BackgroundFileLoader bgLoader) {
        this.m_stateCache = stateCache;
        this.m_fileLoader = bgLoader;
        this.m_readQueue = new FileRequestQueue();
        this.m_writeQueue = new FileRequestQueue();
        this.m_maxQueueSize = 200;
        this.m_lowQueueSize = 50;
        this.setName(name);
    }

    public final void startThreads() {
        int i;
        this.m_readThreads = new ThreadWorker[this.m_readWorkers];
        for (i = 0; i < this.m_readWorkers; ++i) {
            this.m_readThreads[i] = new ThreadWorker(this.getName() + "_RD_" + (i + 1), i, this.m_readQueue);
        }
        this.m_writeThreads = new ThreadWorker[this.m_writeWorkers];
        for (i = 0; i < this.m_writeWorkers; ++i) {
            this.m_writeThreads[i] = new ThreadWorker(this.getName() + "_WR_" + (i + 1), i, this.m_writeQueue);
        }
        if (this.hasDebug()) {
            Debug.println("FileLoader threadPool read=" + this.m_readWorkers + ", write=" + this.m_writeWorkers);
        }
    }

    public final void shutdownThreads() {
        int i;
        if (this.m_readThreads != null) {
            for (i = 0; i < this.m_readThreads.length; ++i) {
                this.m_readThreads[i].shutdownRequest();
            }
        }
        if (this.m_writeThreads != null) {
            for (i = 0; i < this.m_writeThreads.length; ++i) {
                this.m_writeThreads[i].shutdownRequest();
            }
        }
    }

    public void queueFileRequest(FileRequest req) {
        if (req instanceof SingleFileRequest) {
            SingleFileRequest fileReq = (SingleFileRequest)req;
            if (fileReq.hasFileState()) {
                fileReq.getFileState().setExpiryTime(-1L);
            }
            if (fileReq.isType() == 0) {
                this.m_readQueue.addRequest(fileReq);
            } else {
                this.m_writeQueue.addRequest(fileReq);
            }
        }
    }

    public final boolean hasDebug() {
        return this.m_debug;
    }

    public final BackgroundFileLoader getFileLoader() {
        return this.m_fileLoader;
    }

    public final long getFileStateTimeout() {
        return this.m_stateTimeout;
    }

    public final int getMaximumQueueSize() {
        return this.m_maxQueueSize;
    }

    public final int getLowQueueSize() {
        return this.m_lowQueueSize;
    }

    public final String getName() {
        return this.m_name;
    }

    protected final FileRequestQueue getReadQueue() {
        return this.m_readQueue;
    }

    protected final FileRequestQueue getWriteQueue() {
        return this.m_writeQueue;
    }

    public final int getReadWorkers() {
        return this.m_readWorkers;
    }

    public final int getWriteWorkers() {
        return this.m_writeWorkers;
    }

    protected final FileStateCache getStateCache() {
        return this.m_stateCache;
    }

    public final void setName(String name) {
        this.m_name = name;
    }

    public final void setDebug(boolean dbg) {
        this.m_debug = dbg;
    }

    public final void setMaximumQueueSize(int qsize) {
        this.m_maxQueueSize = qsize;
    }

    public final void setLowQueueSize(int lowqSize) {
        this.m_lowQueueSize = lowqSize;
    }

    public final void setReadWorkers(int rdWorkers) {
        this.m_readWorkers = rdWorkers;
    }

    public final void setWriteWorkers(int wrWorkers) {
        this.m_writeWorkers = wrWorkers;
    }

    protected class ThreadWorker
    implements Runnable {
        private Thread mi_thread;
        private int mi_id;
        private FileRequestQueue mi_queue;
        private boolean mi_shutdown = false;

        public ThreadWorker(String name, int id, FileRequestQueue queue) {
            this.mi_id = id;
            this.mi_queue = queue;
            this.mi_thread = new Thread(this);
            this.mi_thread.setName(name);
            this.mi_thread.setDaemon(true);
            this.mi_thread.start();
        }

        public final void shutdownRequest() {
            this.mi_shutdown = true;
            try {
                this.mi_thread.interrupt();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public void run() {
            FileRequest fileReq = null;
            while (!this.mi_shutdown) {
                int reqSts;
                block19: {
                    try {
                        fileReq = this.mi_queue.removeRequest();
                    }
                    catch (InterruptedException ex) {
                        if (this.mi_shutdown) break;
                    }
                    if (fileReq == null) continue;
                    if (MemoryBackgroundLoadSave.this.hasDebug()) {
                        Debug.println("BackgroundLoadSave loader=" + MemoryBackgroundLoadSave.this.getName() + ", fileReq=" + fileReq + ", queued=" + this.mi_queue.numberOfRequests());
                    }
                    reqSts = 1;
                    try {
                        fileReq.setThreadId(this.mi_id);
                        if (fileReq.isType() == 0) {
                            reqSts = MemoryBackgroundLoadSave.this.getFileLoader().loadFile(fileReq);
                        } else if (fileReq.isType() == 1 || fileReq.isType() == 2) {
                            reqSts = MemoryBackgroundLoadSave.this.getFileLoader().storeFile(fileReq);
                        }
                    }
                    catch (Exception ex) {
                        if (!MemoryBackgroundLoadSave.this.hasDebug()) break block19;
                        Debug.println("BackgroundLoadSave exception=" + ex.toString());
                        Debug.println(ex);
                    }
                }
                if (reqSts == 0 || reqSts == 2) {
                    if (fileReq instanceof MultipleFileRequest) {
                        MultipleFileRequest multiReq = (MultipleFileRequest)fileReq;
                        long expireAt = System.currentTimeMillis() + 3000L;
                        for (int i = 0; i < multiReq.getNumberOfFiles(); ++i) {
                            CachedFileInfo finfo = multiReq.getFileInfo(i);
                            if (!finfo.hasFileState()) continue;
                            finfo.getFileState().setExpiryTime(expireAt);
                        }
                    } else {
                        SingleFileRequest singleReq = (SingleFileRequest)fileReq;
                        if (singleReq.hasFileState()) {
                            singleReq.getFileState().setExpiryTime(System.currentTimeMillis() + 3000L);
                        }
                    }
                    if (reqSts != 2 || !MemoryBackgroundLoadSave.this.hasDebug()) continue;
                    Debug.println("BackgroundLoadSave Error request=" + fileReq);
                    continue;
                }
                if (reqSts != 1) continue;
                if (MemoryBackgroundLoadSave.this.hasDebug()) {
                    Debug.println("BackgroundLoadSave ReQueue request=" + fileReq);
                }
                if (this.mi_queue.numberOfRequests() < 20) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.mi_queue.addRequest(fileReq);
            }
            if (MemoryBackgroundLoadSave.this.hasDebug()) {
                Debug.println("BackgroundLoadSave thread=" + this.mi_thread.getName() + " shutdown");
            }
        }
    }
}

