/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.server.filesys.db;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import org.filesys.debug.Debug;
import org.filesys.server.SrvSession;
import org.filesys.server.auth.ClientInfo;
import org.filesys.server.core.DeviceContext;
import org.filesys.server.filesys.DiskDeviceContext;
import org.filesys.server.filesys.FileName;
import org.filesys.server.filesys.FileOfflineException;
import org.filesys.server.filesys.FileOpenParams;
import org.filesys.server.filesys.FileStatus;
import org.filesys.server.filesys.NetworkFile;
import org.filesys.server.filesys.cache.FileState;
import org.filesys.server.filesys.cache.FileStateCache;
import org.filesys.server.filesys.cache.FileStateListener;
import org.filesys.server.filesys.db.BackgroundLoadSave;
import org.filesys.server.filesys.db.CachedNetworkFile;
import org.filesys.server.filesys.db.DBDeviceContext;
import org.filesys.server.filesys.db.DBException;
import org.filesys.server.filesys.db.DBFileInfo;
import org.filesys.server.filesys.db.DBNetworkFile;
import org.filesys.server.filesys.db.DBObjectIdInterface;
import org.filesys.server.filesys.db.DBQueueInterface;
import org.filesys.server.filesys.db.DirectoryNetworkFile;
import org.filesys.server.filesys.loader.BackgroundFileLoader;
import org.filesys.server.filesys.loader.DeleteFileRequest;
import org.filesys.server.filesys.loader.FileLoader;
import org.filesys.server.filesys.loader.FileLoaderException;
import org.filesys.server.filesys.loader.FileProcessor;
import org.filesys.server.filesys.loader.FileProcessorList;
import org.filesys.server.filesys.loader.FileRequest;
import org.filesys.server.filesys.loader.FileRequestQueue;
import org.filesys.server.filesys.loader.FileSegment;
import org.filesys.server.filesys.loader.FileSegmentInfo;
import org.filesys.server.filesys.loader.SingleFileRequest;
import org.filesys.util.NameValue;
import org.filesys.util.NameValueList;
import org.filesys.util.StringList;
import org.springframework.extensions.config.ConfigElement;

public abstract class ObjectIdFileLoader
implements FileLoader,
BackgroundFileLoader,
FileStateListener {
    public static final int StsSuccess = 0;
    public static final int StsRequeue = 1;
    public static final int StsError = 2;
    public static final String TempDirPrefix = "ldr";
    public static final String TempFilePrefix = "ldr_";
    public static final String JarFilePrefix = "jar_";
    private static final int MaximumFilesPerSubDir = 500;
    public static final String DBFileSegmentInfo = "DBFileSegmentInfo";
    public static final int DefaultWorkerThreads = 4;
    public static final int MinimumWorkerThreads = 1;
    public static final int MaximumWorkerThreads = 50;
    public static final long SequentialFileExpire = 3000L;
    public static final long RequestProcessedExpire = 3000L;
    public static final long RequestQueuedExpire = 10000L;
    public static final long DEFAULT_FRAGSIZE = 524288L;
    public static final long MIN_FRAGSIZE = 65536L;
    public static final long MAX_FRAGSIZE = 0x40000000L;
    public static final long MAX_MEMORYBUFFER = 524288L;
    private String m_name;
    private int m_maxQueueSize;
    private int m_lowQueueSize;
    private boolean m_debug;
    private boolean m_threadDebug;
    private int m_readWorkers;
    private int m_writeWorkers;
    private DBDeviceContext m_dbCtx;
    private FileStateCache m_stateCache;
    private DBObjectIdInterface m_dbObjectIdInterface;
    private BackgroundLoadSave m_backgroundLoader;
    private String m_tempDirName;
    private File m_tempDir;
    private String m_tempDirPrefix = "ldr";
    private String m_tempFilePrefix = "ldr_";
    private String m_curTempName;
    private File m_curTempDir;
    private int m_curTempIdx;
    private int m_tempCount;
    private int m_tempMax;
    private FileProcessorList m_fileProcessors;
    private StringList m_reqAttributes;

    @Override
    public int getRequiredDBFeatures() {
        return 36;
    }

    public final DBDeviceContext getContext() {
        return this.m_dbCtx;
    }

    protected final FileStateCache getStateCache() {
        return this.m_stateCache;
    }

    public final String getTemporaryDirectoryPath() {
        return this.m_tempDirName;
    }

    public final File getTemporaryDirectory() {
        return this.m_tempDir;
    }

    public final File getCurrentTempDirectory() {
        return this.m_curTempDir;
    }

    public final DBObjectIdInterface getDBObjectIdInterface() {
        return this.m_dbObjectIdInterface;
    }

    @Override
    public void addFileProcessor(FileProcessor fileProc) throws FileLoaderException {
        if (this.m_fileProcessors == null) {
            this.m_fileProcessors = new FileProcessorList();
        }
        this.m_fileProcessors.addProcessor(fileProc);
    }

    public final boolean hasFileProcessors() {
        return this.m_fileProcessors != null;
    }

    public final boolean hasDebug() {
        return this.m_debug;
    }

    public final int getMaximumQueueSize() {
        return this.m_maxQueueSize;
    }

    public final int getLowQueueSize() {
        return this.m_lowQueueSize;
    }

    public final String getName() {
        return this.m_name;
    }

    public final String getShareName() {
        return this.m_dbCtx.getShareName();
    }

    public final String getTempDirectoryPrefix() {
        return this.m_tempDirPrefix;
    }

    public final String getTempFilePrefix() {
        return this.m_tempFilePrefix;
    }

    protected final void setName(String name) {
        this.m_name = name;
    }

    protected final void setRequiredAttributes(StringList attrNames) {
        this.m_reqAttributes = attrNames;
    }

    protected final boolean hasRequiredAttributes() {
        return this.m_reqAttributes != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NetworkFile openFile(FileOpenParams params, int fid, int stid, int did, boolean create, boolean dir) throws IOException, FileNotFoundException {
        String[] paths = FileName.splitPath(params.getPath());
        String name = paths[1];
        if (params.isStream()) {
            name = name + params.getStreamName();
        }
        FileState fstate = this.m_stateCache.findFileState(params.getFullPath(), true);
        fstate.setExpiryTime(System.currentTimeMillis() + this.m_stateCache.getFileStateExpireInterval());
        DBNetworkFile netFile = null;
        if (!dir) {
            CachedNetworkFile cacheFile;
            netFile = cacheFile = this.createNetworkFile(fstate, params, name, fid, stid, did);
            FileSegment fileSeg = cacheFile.getFileSegment();
            if (create || params.isOverwrite()) {
                fileSeg.setStatus(3);
            } else if (params.isSequentialAccessOnly() && !fileSeg.isDataLoading()) {
                FileState fileState = cacheFile.getFileState();
                synchronized (fileState) {
                    cacheFile.openFile(create);
                    cacheFile.closeFile();
                    if (!fileSeg.isDataLoading()) {
                        this.queueFileRequest(new SingleFileRequest(0, cacheFile.getFileId(), cacheFile.getStreamId(), fileSeg.getInfo(), cacheFile.getFullName(), fstate));
                    }
                }
                if (this.hasDebug()) {
                    Debug.println("ObjIdLoader Queued file load, SEQUENTIAL access, file=" + cacheFile.getFullName());
                }
            }
        } else {
            netFile = new DirectoryNetworkFile(name, fid, did, this.m_stateCache.getFileStateProxy(fstate));
            if (this.hasDebug()) {
                Debug.println("ObjIdLoader.openFile() DIR name=" + name + ", state=" + fstate);
            }
        }
        return netFile;
    }

    @Override
    public void closeFile(SrvSession sess, NetworkFile netFile) throws IOException {
        if (netFile instanceof CachedNetworkFile) {
            CachedNetworkFile cacheFile = (CachedNetworkFile)netFile;
            cacheFile.closeFile();
            FileSegment fileSeg = cacheFile.getFileSegment();
            if (fileSeg.isUpdated() && !netFile.hasDeleteOnClose()) {
                File tempFile = new File(fileSeg.getTemporaryFile());
                netFile.setModifyDate(tempFile.lastModified());
                netFile.setFileSize(tempFile.length());
                if (!fileSeg.isSaveQueued()) {
                    SingleFileRequest fileReq = new SingleFileRequest(1, cacheFile.getFileId(), cacheFile.getStreamId(), fileSeg.getInfo(), netFile.getFullName(), cacheFile.getFileState());
                    if (this.hasRequiredAttributes() && sess != null) {
                        if (this.m_reqAttributes.containsString("UserName")) {
                            ClientInfo cInfo = sess.getClientInformation();
                            String userName = "";
                            if (cInfo != null && cInfo.getUserName() != null) {
                                userName = cInfo.getUserName();
                            }
                            fileReq.addAttribute(new NameValue("UserName", userName));
                        }
                        if (this.m_reqAttributes.containsString("Protocol")) {
                            fileReq.addAttribute(new NameValue("Protocol", sess.getProtocolName()));
                        }
                    }
                    fileSeg.setStatus(4, true);
                    this.queueFileRequest(fileReq);
                } else if (this.hasDebug()) {
                    Debug.println("## FileLoader Save already queued for " + fileSeg);
                }
            } else if (cacheFile.getFileState().getOpenCount() == 0) {
                long tmo = System.currentTimeMillis();
                tmo = cacheFile.isSequentialOnly() ? (tmo += 3000L) : (tmo += this.m_stateCache.getFileStateExpireInterval());
                cacheFile.getFileState().setExpiryTime(tmo);
            }
            if (!this.m_dbCtx.isAvailable() && netFile.hasDeleteOnClose()) {
                DeleteFileRequest deleteReq = new DeleteFileRequest(cacheFile.getFileId(), cacheFile.getStreamId(), fileSeg.getTemporaryFile(), cacheFile.getFullNameStream(), cacheFile.getFileState());
                this.m_dbCtx.addOfflineFileDelete(deleteReq);
                if (this.hasDebug()) {
                    Debug.println("## FileLoader queued offline delete, " + deleteReq);
                }
            }
        }
    }

    @Override
    public void deleteFile(String fname, int fid, int stid) throws IOException {
        block6: {
            try {
                FileSegmentInfo fileSegInfo;
                FileState fstate = this.m_stateCache.findFileState(fname, false);
                if (fstate != null && (fileSegInfo = (FileSegmentInfo)fstate.removeAttribute(DBFileSegmentInfo)) != null) {
                    try {
                        fileSegInfo.setQueued(false);
                        fileSegInfo.setStatus(0);
                        fileSegInfo.deleteTemporaryFile();
                    }
                    catch (Exception ex) {
                        if (this.hasDebug()) {
                            Debug.println("## ObjIdLoader failed to delete temp file " + fileSegInfo.getTemporaryFile());
                        }
                    }
                }
            }
            catch (Exception ex) {
                if (!this.hasDebug()) break block6;
                Debug.println("## ObjIdLoader deleteFile() error, " + ex.toString());
            }
        }
    }

    @Override
    public void queueFileRequest(FileRequest req) {
        this.m_backgroundLoader.queueFileRequest(req);
    }

    @Override
    public int loadFile(FileRequest req) throws Exception {
        long startTime = 0L;
        SingleFileRequest loadReq = (SingleFileRequest)req;
        if (this.hasDebug()) {
            Debug.println("## ObjIdLoader loadFile() req=" + loadReq.toString() + ", thread=" + Thread.currentThread().getName());
            startTime = System.currentTimeMillis();
        }
        File tempFile = new File(loadReq.getTemporaryFile());
        FileSegment fileSeg = this.findFileSegmentForPath(loadReq.getVirtualPath());
        if (!tempFile.exists() || fileSeg == null) {
            if (this.hasDebug()) {
                Debug.println("  Temporary file deleted");
            }
            fileSeg.setStatus(7, false);
            return 2;
        }
        if (this.hasDebug()) {
            Debug.println("## ObjIdLoader fileSeg=" + fileSeg.getTemporaryFile() + ", virtPath=" + loadReq.getVirtualPath());
        }
        int loadSts = 1;
        String objectId = null;
        int fileId = loadReq.getFileId();
        int strmId = loadReq.getStreamId();
        try {
            fileSeg.setStatus(2);
            objectId = this.getDBObjectIdInterface().loadObjectId(fileId, strmId);
            if (objectId != null) {
                this.loadFileData(fileId, strmId, objectId, fileSeg);
                loadSts = 0;
                if (this.hasDebug()) {
                    long endTime = System.currentTimeMillis();
                    Debug.println("## ObjIdLoader loaded fid=" + loadReq.getFileId() + ", stream=" + loadReq.getStreamId() + ", time=" + (endTime - startTime) + "ms");
                }
            } else {
                if (this.hasDebug()) {
                    Debug.println("## ObjIdLoader No object id mapping for fid=" + loadReq.getFileId() + ", stream=" + loadReq.getStreamId());
                }
                loadSts = 0;
            }
        }
        catch (DBException ex) {
            if (this.hasDebug()) {
                Debug.println(ex);
            }
            loadSts = 2;
        }
        catch (FileOfflineException ex) {
            if (this.hasDebug()) {
                Debug.println(ex);
            }
            loadSts = 2;
        }
        catch (IOException ex) {
            if (this.hasDebug()) {
                Debug.println(ex);
            }
            loadSts = 1;
        }
        catch (Exception ex) {
            if (this.hasDebug()) {
                Debug.println(ex);
            }
            loadSts = 2;
        }
        tempFile.setLastModified(0L);
        if (loadSts == 0) {
            fileSeg.signalDataAvailable();
            fileSeg.setStatus(3, false);
            this.runFileLoadedProcessors(this.getContext(), loadReq.getFileState(), fileSeg);
        } else if (loadSts == 2) {
            fileSeg.setStatus(7, false);
            fileSeg.setReadableLength(0L);
            fileSeg.signalDataAvailable();
            fileSeg.deleteTemporaryFile();
        }
        return loadSts;
    }

    @Override
    public int storeFile(FileRequest req) throws Exception {
        int saveSts = 2;
        SingleFileRequest saveReq = (SingleFileRequest)req;
        File tempFile = new File(saveReq.getTemporaryFile());
        FileSegment fileSeg = this.findFileSegmentForPath(saveReq.getVirtualPath());
        if (!tempFile.exists() || fileSeg == null) {
            if (this.hasDebug()) {
                Debug.println("  Temporary file deleted");
            }
            return 2;
        }
        this.runFileStoreProcessors(this.m_dbCtx, saveReq.getFileState(), fileSeg);
        fileSeg.setStatus(5);
        fileSeg.getInfo().setUpdated(false);
        try {
            String objectId = this.saveFileData(saveReq.getFileId(), saveReq.getStreamId(), fileSeg, req.getAttributes());
            this.getDBObjectIdInterface().saveObjectId(saveReq.getFileId(), saveReq.getStreamId(), objectId);
            saveSts = 0;
        }
        catch (DBException ex) {
            if (this.hasDebug()) {
                Debug.println(ex);
            }
            saveSts = 2;
        }
        catch (IOException ex) {
            if (this.hasDebug()) {
                Debug.println(ex);
            }
            saveSts = 2;
        }
        if (saveSts == 0) {
            fileSeg.setStatus(6, false);
        } else {
            fileSeg.setStatus(7, false);
        }
        return saveSts;
    }

    public abstract void loadFileData(int var1, int var2, String var3, FileSegment var4) throws IOException;

    public abstract String saveFileData(int var1, int var2, FileSegment var3, NameValueList var4) throws IOException;

    @Override
    public void initializeLoader(ConfigElement params, DeviceContext ctx) throws FileLoaderException, IOException {
        ConfigElement fileProcs;
        block33: {
            ConfigElement nameVal;
            if (params.getChild("Debug") != null) {
                this.m_debug = true;
            }
            if ((nameVal = params.getChild("ThreadPoolSize")) != null && (nameVal.getValue() == null || nameVal.getValue().length() == 0)) {
                throw new FileLoaderException("FileLoader ThreadPoolSize parameter is null");
            }
            this.m_readWorkers = 4;
            this.m_writeWorkers = 4;
            if (nameVal != null) {
                try {
                    String numVal = nameVal.getValue();
                    int rdCnt = -1;
                    int wrtCnt = -1;
                    int pos = numVal.indexOf(58);
                    if (pos == -1) {
                        wrtCnt = rdCnt = Integer.parseInt(numVal);
                    } else {
                        String val = numVal.substring(0, pos);
                        rdCnt = Integer.parseInt(val);
                        val = numVal.substring(pos + 1);
                        wrtCnt = Integer.parseInt(val);
                    }
                    this.m_readWorkers = rdCnt;
                    this.m_writeWorkers = wrtCnt;
                }
                catch (NumberFormatException ex) {
                    throw new FileLoaderException("ObjIdLoader Invalid ThreadPoolSize value, " + ex.toString());
                }
            }
            if (this.m_readWorkers < 1 || this.m_readWorkers > 50) {
                throw new FileLoaderException("ObjIdLoader Invalid ThreadPoolSize (read), valid range is 1-50");
            }
            if (this.m_writeWorkers < 1 || this.m_writeWorkers > 50) {
                throw new FileLoaderException("ObjIdLoader Invalid ThreadPoolSize (write), valid range is 1-50");
            }
            ConfigElement tempArea = params.getChild("TempDirectory");
            if (tempArea == null || tempArea.getValue() == null || tempArea.getValue().length() == 0) {
                throw new FileLoaderException("FileLoader TempDirectory not specified or null");
            }
            File tempDir = new File(tempArea.getValue());
            if (!tempDir.exists() && !tempDir.mkdir()) {
                throw new FileLoaderException("Failed to create temporary directory " + tempDir.getAbsolutePath());
            }
            this.m_tempDirName = tempDir.getAbsolutePath();
            if (this.m_tempDirName != null && !this.m_tempDirName.endsWith(File.separator)) {
                this.m_tempDirName = this.m_tempDirName + File.separator;
            }
            this.m_tempDir = new File(this.m_tempDirName);
            if (!this.m_tempDir.exists() || !this.m_tempDir.isDirectory()) {
                throw new FileLoaderException("FileLoader TempDirectory does not exist, or is not a directory, " + this.m_tempDirName);
            }
            if (!this.m_tempDir.canWrite()) {
                throw new FileLoaderException("FileLoader TempDirectory is not writeable, " + this.m_tempDirName);
            }
            this.createNewTempDirectory();
            ConfigElement maxFiles = params.getChild("MaximumFilesPerDirectory");
            if (maxFiles != null) {
                try {
                    this.m_tempMax = Integer.parseInt(maxFiles.getValue());
                    if (this.m_tempMax < 10 || this.m_tempMax > 20000) {
                        throw new FileLoaderException("FileLoader MaximumFilesPerDirectory out of valid range (10-20000)");
                    }
                    break block33;
                }
                catch (NumberFormatException ex) {
                    throw new FileLoaderException("FileLoader MaximumFilesPerDirectory invalid, " + maxFiles.getValue());
                }
            }
            this.m_tempMax = 500;
        }
        if ((fileProcs = params.getChild("FileProcessors")) != null) {
            List elems = fileProcs.getChildren();
            for (ConfigElement className : elems) {
                if (className == null || className.getValue() == null || className.getValue().length() == 0) {
                    throw new FileLoaderException("Empty file processor class name");
                }
                try {
                    Object procObj = Class.forName(className.getValue()).newInstance();
                    if (procObj instanceof FileProcessor) {
                        this.addFileProcessor((FileProcessor)procObj);
                        continue;
                    }
                    throw new FileLoaderException("Class " + className.getValue() + " is not a FileProcessor implementation");
                }
                catch (ClassNotFoundException ex) {
                    throw new FileLoaderException("File processor class not found, " + className.getValue());
                }
                catch (InstantiationException ex) {
                    throw new FileLoaderException("File processor exception, " + ex.toString());
                }
                catch (IllegalAccessException ex) {
                    throw new FileLoaderException("File processor exception, " + ex.toString());
                }
            }
        }
        if (ctx instanceof DBDeviceContext) {
            this.m_dbCtx = (DBDeviceContext)ctx;
            if (!this.getContext().getDBInterface().supportsFeature(4)) {
                throw new FileLoaderException("DBLoader requires queue support in database interface");
            }
            if (!(this.getContext().getDBInterface() instanceof DBQueueInterface)) {
                throw new FileLoaderException("Database interface does not implement queue interface");
            }
            if (!this.getContext().getDBInterface().supportsFeature(32)) {
                throw new FileLoaderException("DBLoader requires data support in database interface");
            }
            if (!(this.getContext().getDBInterface() instanceof DBObjectIdInterface)) {
                throw new FileLoaderException("Database interface does not implement object id interface");
            }
        } else {
            throw new FileLoaderException("Requires database device context");
        }
        this.m_dbObjectIdInterface = (DBObjectIdInterface)((Object)this.getContext().getDBInterface());
        if (params.getChild("ThreadDebug") != null) {
            this.m_threadDebug = true;
        }
    }

    @Override
    public void startLoader(DeviceContext ctx) {
        FileRequestQueue recoveredQueue;
        DBQueueInterface dbQueue;
        block8: {
            this.m_stateCache = this.getContext().getStateCache();
            this.m_stateCache.addStateListener(this);
            dbQueue = null;
            if (!(this.getContext().getDBInterface() instanceof DBQueueInterface)) {
                throw new RuntimeException("Database interface does not implement queue interface");
            }
            dbQueue = (DBQueueInterface)((Object)this.getContext().getDBInterface());
            recoveredQueue = null;
            try {
                recoveredQueue = dbQueue.performQueueCleanup(this.m_tempDir, TempDirPrefix, TempFilePrefix, JarFilePrefix);
                if (recoveredQueue != null && this.hasDebug()) {
                    Debug.println("[DBLoader] Cleanup recovered " + recoveredQueue.numberOfRequests() + " pending save files");
                }
            }
            catch (DBException ex) {
                if (!this.hasDebug()) break block8;
                Debug.println(ex);
            }
        }
        FileRequestQueue saveQueue = new FileRequestQueue();
        try {
            dbQueue.loadFileRequests(1, 1, saveQueue, 1);
        }
        catch (DBException dBException) {
            // empty catch block
        }
        this.m_backgroundLoader = new BackgroundLoadSave("DBLdr", dbQueue, this.m_stateCache, this);
        this.m_backgroundLoader.setReadWorkers(this.m_readWorkers);
        this.m_backgroundLoader.setWriteWorkers(this.m_writeWorkers);
        this.m_backgroundLoader.setDebug(this.m_threadDebug);
        this.m_backgroundLoader.startThreads(saveQueue.numberOfRequests());
        if (recoveredQueue != null) {
            while (recoveredQueue.numberOfRequests() > 0) {
                this.queueFileRequest(recoveredQueue.removeRequestNoWait());
            }
        }
    }

    @Override
    public void shutdownLoader(boolean immediate) {
        if (this.m_backgroundLoader != null) {
            this.m_backgroundLoader.shutdownThreads();
        }
    }

    protected final void runFileStoreProcessors(DiskDeviceContext context, FileState state, FileSegment segment) {
        block4: {
            if (this.m_fileProcessors == null || this.m_fileProcessors.numberOfProcessors() == 0) {
                return;
            }
            try {
                for (int i = 0; i < this.m_fileProcessors.numberOfProcessors(); ++i) {
                    FileProcessor fileProc = this.m_fileProcessors.getProcessorAt(i);
                    fileProc.processStoredFile(context, state, segment);
                }
                segment.closeFile();
            }
            catch (Exception ex) {
                if (!this.hasDebug()) break block4;
                Debug.println("$$ Store file processor exception");
                Debug.println(ex);
            }
        }
    }

    protected final void runFileLoadedProcessors(DiskDeviceContext context, FileState state, FileSegment segment) {
        block4: {
            if (this.m_fileProcessors == null || this.m_fileProcessors.numberOfProcessors() == 0) {
                return;
            }
            try {
                for (int i = 0; i < this.m_fileProcessors.numberOfProcessors(); ++i) {
                    FileProcessor fileProc = this.m_fileProcessors.getProcessorAt(i);
                    fileProc.processLoadedFile(context, state, segment);
                }
                segment.closeFile();
            }
            catch (Exception ex) {
                if (!this.hasDebug()) break block4;
                Debug.println("$$ Load file processor exception");
                Debug.println(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final FileState createFileStateForRequest(int fid, String tempPath, String virtPath, int sts) {
        FileState state;
        FileState fileState = state = this.m_stateCache.findFileState(virtPath, true);
        synchronized (fileState) {
            state.setExpiryTime(-1L);
            state.setFileStatus(FileStatus.FileExists);
            state.setFileId(fid);
            FileSegmentInfo fileSegInfo = (FileSegmentInfo)state.findAttribute(DBFileSegmentInfo);
            FileSegment fileSeg = null;
            if (fileSegInfo == null) {
                fileSegInfo = new FileSegmentInfo();
                fileSegInfo.setTemporaryFile(tempPath);
                fileSeg = new FileSegment(fileSegInfo, true);
                fileSeg.setStatus(sts, true);
                state.addAttribute(DBFileSegmentInfo, fileSegInfo);
            } else {
                fileSeg = new FileSegment(fileSegInfo, true);
                fileSeg.setStatus(sts, true);
            }
        }
        return state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final FileSegment findFileSegmentForPath(String virtPath) {
        FileState fstate = this.m_stateCache.findFileState(virtPath, false);
        if (fstate == null) {
            return null;
        }
        FileSegmentInfo segInfo = null;
        FileSegment fileSeg = null;
        FileState fileState = fstate;
        synchronized (fileState) {
            segInfo = (FileSegmentInfo)fstate.findAttribute(DBFileSegmentInfo);
            fileSeg = new FileSegment(segInfo, true);
        }
        return fileSeg;
    }

    @Override
    public boolean supportsStreams() {
        if (this.getContext() != null) {
            return this.getContext().getDBInterface().supportsFeature(1);
        }
        return true;
    }

    private final void createNewTempDirectory() {
        this.m_curTempName = this.m_tempDirName + this.getTempDirectoryPrefix() + this.m_curTempIdx++;
        this.m_curTempDir = new File(this.m_curTempName);
        if (!this.m_curTempDir.exists()) {
            this.m_curTempDir.mkdir();
        }
        this.m_tempCount = 0;
        if (this.hasDebug()) {
            Debug.println("ObjIdLoader Created new temp directory - " + this.m_curTempName);
        }
    }

    @Override
    public boolean fileStateExpired(FileState state) {
        FileSegmentInfo segInfo = (FileSegmentInfo)state.findAttribute(DBFileSegmentInfo);
        boolean expire = true;
        if (segInfo != null) {
            if (!segInfo.isQueued()) {
                try {
                    if (segInfo.hasStatus() != 0) {
                        File tempFile;
                        File subDir;
                        String[] files;
                        try {
                            segInfo.deleteTemporaryFile();
                        }
                        catch (IOException ex) {
                            Debug.println("Delete temp file error: " + ex.toString());
                            File tempFile2 = new File(segInfo.getTemporaryFile());
                            Debug.println("  TempFile file=" + tempFile2.getAbsolutePath() + ", exists=" + tempFile2.exists());
                            Debug.println("  FileState state=" + state);
                            Debug.println("  FileSegmentInfo segInfo=" + segInfo);
                            Debug.println("  StateCache size=" + this.m_stateCache.numberOfStates());
                        }
                        state.removeAttribute(DBFileSegmentInfo);
                        segInfo.setStatus(0);
                        state.setDataStatus(FileState.DataStatus.LoadWait);
                        if (!(segInfo.getTemporaryFile().startsWith(this.m_curTempName) || (files = (subDir = (tempFile = new File(segInfo.getTemporaryFile())).getParentFile()).list()) != null && files.length != 0)) {
                            subDir.delete();
                            if (this.hasDebug()) {
                                Debug.println("$$ Deleted temporary directory " + subDir.getPath() + ", curTempName=" + this.m_curTempName + ", tempFile=" + segInfo.getTemporaryFile());
                            }
                        }
                        expire = false;
                        if (this.hasDebug()) {
                            Debug.println("$$ Deleted temporary file " + segInfo.getTemporaryFile() + " [EXPIRED] $$");
                        }
                    }
                    if (!expire) {
                        state.setExpiryTime(System.currentTimeMillis() + this.m_stateCache.getFileStateExpireInterval());
                    }
                }
                catch (Exception ex) {
                    Debug.println("$$  " + ex.toString());
                    Debug.println("  state=" + state);
                }
            } else {
                File tempFile;
                if (this.hasDebug() && !(tempFile = new File(segInfo.getTemporaryFile())).exists()) {
                    Debug.println("== Skipped file state, queued " + state);
                    Debug.println("   File seg=" + segInfo);
                }
                expire = false;
            }
        } else if (state.isDirectory()) {
            expire = true;
        } else if (this.hasDebug()) {
            Debug.println("$$ Expiring state=" + state);
        }
        return expire;
    }

    @Override
    public void fileStateClosed(FileState state) {
        if (state == null) {
            Debug.println("%%%%% FileLoader.fileStateClosed() state=NULL %%%%%");
            return;
        }
        FileSegmentInfo segInfo = (FileSegmentInfo)state.findAttribute(DBFileSegmentInfo);
        if (segInfo != null && !segInfo.isQueued() && segInfo.hasStatus() != 4) {
            try {
                segInfo.deleteTemporaryFile();
                if (this.hasDebug()) {
                    Debug.println("$$ Deleted temporary file " + segInfo.getTemporaryFile() + " [CLOSED] $$");
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final CachedNetworkFile createNetworkFile(FileState state, FileOpenParams params, String fname, int fid, int stid, int did) throws IOException {
        FileSegment fileSeg = null;
        CachedNetworkFile netFile = null;
        FileState fileState = state;
        synchronized (fileState) {
            FileSegmentInfo fileSegInfo = (FileSegmentInfo)state.findAttribute(DBFileSegmentInfo);
            if (fileSegInfo == null) {
                if (this.m_tempCount++ >= this.m_tempMax) {
                    this.createNewTempDirectory();
                }
                StringBuffer tempName = new StringBuffer();
                tempName.append(this.getTempFilePrefix());
                tempName.append(fid);
                if (stid > 0) {
                    tempName.append("_");
                    tempName.append(stid);
                    if (this.hasDebug()) {
                        Debug.println("## Temp file for stream ##");
                    }
                }
                tempName.append(".tmp");
                fileSegInfo = new FileSegmentInfo();
                fileSeg = FileSegment.createSegment(fileSegInfo, tempName.toString(), this.m_curTempDir, !params.isReadOnlyAccess());
                state.addAttribute(DBFileSegmentInfo, fileSegInfo);
                DBFileInfo finfo = (DBFileInfo)state.findAttribute("FileInfo");
                if (finfo != null && finfo.getSize() == 0L) {
                    fileSeg.setStatus(3);
                }
            } else {
                fileSeg = new FileSegment(fileSegInfo, !params.isReadOnlyAccess());
                File tempFile = new File(fileSeg.getTemporaryFile());
                if (!tempFile.exists()) {
                    tempFile.createNewFile();
                    fileSeg.setStatus(0);
                }
            }
            netFile = new CachedNetworkFile(fname, fid, stid, did, this.m_stateCache.getFileStateProxy(state), fileSeg, this);
            netFile.setGrantedAccess(params.isReadOnlyAccess() ? NetworkFile.Access.READ_ONLY : NetworkFile.Access.READ_WRITE);
            netFile.setSequentialOnly(params.isSequentialAccessOnly());
            netFile.setAttributes(params.getAttributes());
            netFile.setFullName(params.getPath());
            if (stid != 0) {
                netFile.setStreamName(params.getStreamName());
            }
        }
        return netFile;
    }

    @Override
    public final void setContext(DBDeviceContext dbCtx) {
        this.m_dbCtx = dbCtx;
    }
}

