/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.server.filesys.loader;

import java.util.StringTokenizer;
import org.filesys.util.NameValue;
import org.filesys.util.NameValueList;

public class FileRequest {
    public static final int LOAD = 0;
    public static final int SAVE = 1;
    public static final int TRANSSAVE = 2;
    public static final int DELETE = 3;
    public static final String AttrUserName = "UserName";
    public static final String AttrProtocol = "Protocol";
    private int m_reqType;
    private int m_threadId;
    private int m_tranId = -1;
    private boolean m_lastFile;
    private NameValueList m_attributes;

    protected FileRequest(int typ) {
        this.m_reqType = typ;
    }

    public final int isType() {
        return this.m_reqType;
    }

    public final int getThreadId() {
        return this.m_threadId;
    }

    public final boolean isLastTransactionFile() {
        return this.m_lastFile;
    }

    public final boolean isTransaction() {
        return this.m_tranId != -1;
    }

    public final int getTransactionId() {
        return this.m_tranId;
    }

    public final void setThreadId(int id) {
        this.m_threadId = id;
    }

    public final void setTransactionId(int id) {
        this.m_tranId = id;
    }

    public final void setTransactionId(int id, boolean last) {
        this.m_tranId = id;
        this.m_lastFile = last;
    }

    public final boolean hasAttributes() {
        return this.m_attributes != null && this.m_attributes.numberOfItems() > 0;
    }

    public final NameValueList getAttributes() {
        return this.m_attributes;
    }

    public final void addAttribute(NameValue attr) {
        if (this.m_attributes == null) {
            this.m_attributes = new NameValueList();
        }
        this.m_attributes.addItem(attr);
    }

    public final NameValue hasAttribute(String attrName) {
        NameValue attr = null;
        if (this.m_attributes != null) {
            attr = this.m_attributes.findItem(attrName);
        }
        return attr;
    }

    public final String getAttributesString() {
        if (!this.hasAttributes()) {
            return "";
        }
        StringBuffer str = new StringBuffer(256);
        NameValueList attrList = this.getAttributes();
        for (int i = 0; i < attrList.numberOfItems(); ++i) {
            NameValue attr = attrList.getItemAt(i);
            if (str.length() > 0) {
                str.append(",");
            }
            str.append(attr.getName());
            str.append("=");
            str.append(attr.getValue());
        }
        return str.toString();
    }

    public final void setAttributes(String attrs) {
        if (attrs == null || attrs.length() == 0) {
            this.m_attributes = null;
            return;
        }
        this.m_attributes = new NameValueList();
        StringTokenizer token = new StringTokenizer(attrs, ",");
        while (token.hasMoreTokens()) {
            String nameVal = token.nextToken();
            int pos = nameVal.indexOf(61);
            if (pos == -1) continue;
            String name = nameVal.substring(0, pos);
            String value = nameVal.substring(pos + 1);
            this.m_attributes.addItem(new NameValue(name, value));
        }
    }
}

