/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.server.filesys.loader;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.filesys.debug.Debug;
import org.filesys.server.filesys.loader.FileSegmentInfo;

public class FileSegment {
    private FileSegmentInfo m_info;
    private RandomAccessFile m_segment;
    private boolean m_writeable;

    public FileSegment(FileSegmentInfo info, boolean writeable) {
        this.m_info = info;
        this.m_writeable = writeable;
    }

    public final long getFileLength() throws IOException {
        if (this.isOpen()) {
            return this.m_segment.length();
        }
        return -1L;
    }

    public final FileSegmentInfo getInfo() {
        return this.m_info;
    }

    public final long getReadableLength() {
        return this.m_info.getReadableLength();
    }

    public final String getTemporaryFile() {
        return this.m_info.getTemporaryFile();
    }

    public final boolean isDataLoading() {
        return this.m_info.hasStatus() != 0 || this.m_info.isQueued();
    }

    public final boolean isDataAvailable() {
        return this.m_info.hasStatus() >= 3 && this.m_info.hasStatus() < 7;
    }

    public final int hasStatus() {
        return this.m_info.hasStatus();
    }

    public final boolean hasLoadError() {
        return this.m_info.hasStatus() == 7;
    }

    public final void setReadableLength(long readable) {
        this.m_info.setReadableLength(readable);
    }

    public final void setStatus(int sts) {
        this.m_info.setStatus(sts);
    }

    public final synchronized void setStatus(int sts, boolean queued) {
        this.m_info.setStatus(sts);
        this.m_info.setQueued(queued);
    }

    public final boolean isOpen() {
        return this.m_segment != null;
    }

    public final boolean isUpdated() {
        return this.m_info.isUpdated();
    }

    public final boolean isQueued() {
        return this.m_info.isQueued();
    }

    public final synchronized boolean isSaveQueued() {
        return this.m_info.isQueued() && this.m_info.hasStatus() == 4;
    }

    public final synchronized boolean isSaving() {
        return this.m_info.isQueued() && this.m_info.hasStatus() == 5;
    }

    public final synchronized boolean isLoading() {
        return this.m_info.isQueued() && this.m_info.hasStatus() == 2;
    }

    public final boolean isWriteable() {
        return this.m_writeable;
    }

    public final synchronized boolean getLoadLock() throws InterruptedException {
        boolean sts = false;
        if (this.isLoading()) {
            this.wait();
        } else {
            this.setStatus(2);
            sts = true;
        }
        return sts;
    }

    public final void waitForData(long tmo) {
        this.m_info.waitForData(tmo);
    }

    public final void signalDataAvailable() {
        this.m_info.signalDataAvailable();
    }

    public final boolean fileExists() {
        if (this.m_segment != null) {
            return true;
        }
        File tempFile = new File(this.getTemporaryFile());
        return tempFile.exists();
    }

    public final void createTemporaryFile() throws IOException {
        File tempFile = new File(this.getTemporaryFile());
        tempFile.createNewFile();
    }

    public final void closeFile() throws IOException {
        if (this.m_segment != null) {
            this.m_segment.close();
            this.m_segment = null;
        }
    }

    public final void openFile() throws IOException {
        if (this.m_segment == null) {
            this.m_segment = new RandomAccessFile(this.m_info.getTemporaryFile(), "rw");
        }
    }

    public final synchronized int readBytes(byte[] buf, int len, int pos, long fileOff) throws IOException {
        if (this.m_segment == null) {
            this.openFile();
        } else {
            this.checkFileDescriptor();
        }
        this.m_segment.seek(fileOff);
        int totLen = 0;
        int rdLen = len;
        int bufPos = pos;
        try {
            while (totLen < len && rdLen > 0) {
                if ((rdLen = this.m_segment.read(buf, bufPos, rdLen)) <= 0) continue;
                totLen += rdLen;
                bufPos += rdLen;
                rdLen = len - totLen;
            }
        }
        catch (Exception ex) {
            Debug.println("***** FileSegment Read Error *****");
            Debug.println(ex);
        }
        return totLen;
    }

    public final synchronized void writeBytes(byte[] buf, int len, int pos, long fileOff) throws IOException {
        if (this.m_segment == null) {
            this.openFile();
        } else {
            this.checkFileDescriptor();
        }
        long fileLen = this.m_segment.length();
        long endpos = fileOff + (long)len;
        if (fileOff > fileLen) {
            this.m_segment.setLength(endpos);
        }
        if (len == 0) {
            return;
        }
        this.m_segment.seek(fileOff);
        this.m_segment.write(buf, pos, len);
        if (!this.m_info.isUpdated()) {
            this.m_info.setUpdated(true);
        }
    }

    public final void flush() throws IOException {
        if (this.m_segment != null) {
            this.m_segment.getFD().sync();
        }
    }

    public final void truncate(long siz) throws IOException {
        if (this.m_segment == null) {
            this.openFile();
        }
        this.m_segment.setLength(siz);
    }

    public final synchronized void deleteTemporaryFile() throws IOException {
        if (this.m_segment != null) {
            throw new IOException("Attempt to delete file segment whilst open");
        }
        if (this.m_info != null) {
            this.m_info.deleteTemporaryFile();
        }
    }

    public static final FileSegment createSegment(FileSegmentInfo info, String prefix, String fname, File tempDir, boolean writeable) throws IOException {
        File tempFile = File.createTempFile(prefix, fname, tempDir);
        info.setTemporaryFile(tempFile.getAbsolutePath());
        return new FileSegment(info, writeable);
    }

    public static final FileSegment createSegment(FileSegmentInfo info, String fname, File tempDir, boolean writeable) throws IOException {
        File tempFile = new File(tempDir, fname);
        info.setTemporaryFile(tempFile.getAbsolutePath());
        return new FileSegment(info, writeable);
    }

    public String toString() {
        return this.m_info.toString();
    }

    protected void finalize() {
        if (this.m_segment != null) {
            try {
                this.m_segment.close();
                this.m_segment = null;
            }
            catch (Exception ex) {
                Debug.println(ex);
            }
        }
    }

    private final void checkFileDescriptor() throws IOException {
        if (this.m_segment != null && this.m_segment.getFD() != null && !this.m_segment.getFD().valid()) {
            try {
                this.closeFile();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.openFile();
        }
    }
}

