/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.server.filesys.loader;

import java.util.ArrayList;
import java.util.List;
import org.filesys.server.filesys.loader.MemorySegment;

public class MemorySegmentList {
    private List<MemorySegment> m_segments = new ArrayList<MemorySegment>();

    public final synchronized void addSegment(MemorySegment seg) {
        this.m_segments.add(seg);
    }

    public final MemorySegment getSegmentAt(int idx) {
        if (idx >= 0 && idx <= this.numberOfSegments()) {
            return this.m_segments.get(idx);
        }
        return null;
    }

    public final int numberOfSegments() {
        return this.m_segments.size();
    }

    public final MemorySegment findSegment(long fileOff, int len) {
        if (this.m_segments == null || this.m_segments.size() == 0) {
            return null;
        }
        for (int i = 0; i < this.numberOfSegments(); ++i) {
            MemorySegment seg = this.m_segments.get(i);
            if (!seg.containsData(fileOff, len)) continue;
            return seg;
        }
        return null;
    }

    public final synchronized int removeSegments(int readLev) {
        if (this.m_segments == null || this.m_segments.size() == 0) {
            return 0;
        }
        int remCount = 0;
        int idx = 0;
        while (idx < this.m_segments.size()) {
            MemorySegment memSeg = this.m_segments.get(idx);
            if (memSeg.getReadCounter() <= readLev) {
                this.m_segments.remove(idx);
                ++remCount;
                continue;
            }
            ++idx;
        }
        return remCount;
    }

    public final synchronized int decrementHitCounts(int decr, boolean remZero) {
        if (this.m_segments == null || this.m_segments.size() == 0) {
            return 0;
        }
        int remCount = 0;
        int idx = 0;
        while (idx < this.m_segments.size()) {
            MemorySegment memSeg = this.m_segments.get(idx);
            memSeg.decrementReadCounter(decr);
            if (remZero && memSeg.getReadCounter() == 0) {
                this.m_segments.remove(idx);
                ++remCount;
                continue;
            }
            ++idx;
        }
        return remCount;
    }
}

