/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.server.filesys.loader;

import java.util.ArrayList;
import java.util.List;
import org.filesys.server.filesys.loader.CachedFileInfo;
import org.filesys.server.filesys.loader.FileRequest;

public class MultipleFileRequest
extends FileRequest {
    private List<CachedFileInfo> m_files;

    public MultipleFileRequest(int typ, int tranId) {
        super(typ);
        this.setTransactionId(tranId);
        this.m_files = new ArrayList<CachedFileInfo>();
    }

    public final int getNumberOfFiles() {
        return this.m_files.size();
    }

    public final CachedFileInfo getFileInfo(int idx) {
        if (idx > this.m_files.size()) {
            return null;
        }
        return this.m_files.get(idx);
    }

    public final void addFileInfo(CachedFileInfo finfo) {
        this.m_files.add(finfo);
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        if (this.isTransaction()) {
            str.append("[Tran=");
            str.append(this.getTransactionId());
        }
        str.append(",Files=");
        str.append(this.getNumberOfFiles());
        if (this.hasAttributes()) {
            str.append(",Attr=");
            str.append(this.getAttributes());
        }
        str.append("]");
        return str.toString();
    }
}

