/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.server.filesys.loader;

import org.filesys.server.filesys.cache.FileState;
import org.filesys.server.filesys.loader.FileRequest;
import org.filesys.server.filesys.loader.FileSegmentInfo;

public class SingleFileRequest
extends FileRequest {
    private int m_fid;
    private int m_stid;
    private int m_seqNo = -1;
    private String m_tempPath;
    private String m_virtPath;
    private FileState m_state;

    public SingleFileRequest(int typ, int fid, int stid, String tempPath, String virtPath, FileState state) {
        super(typ);
        this.m_fid = fid;
        this.m_stid = stid;
        this.m_tempPath = tempPath;
        this.m_virtPath = virtPath;
        this.m_state = state;
    }

    public SingleFileRequest(int typ, int fid, int stid, FileSegmentInfo segInfo, String virtPath, FileState state) {
        super(typ);
        this.m_fid = fid;
        this.m_stid = stid;
        this.m_tempPath = segInfo.getTemporaryFile();
        this.m_virtPath = virtPath;
        this.m_state = state;
        segInfo.setQueued(true);
    }

    public SingleFileRequest(int typ, int fid, int stid, String tempPath, String virtPath, int seq, FileState state) {
        super(typ);
        this.m_fid = fid;
        this.m_stid = stid;
        this.m_tempPath = tempPath;
        this.m_virtPath = virtPath;
        this.m_seqNo = seq;
    }

    public final int getFileId() {
        return this.m_fid;
    }

    public final int getStreamId() {
        return this.m_stid;
    }

    public final int getSequenceNumber() {
        return this.m_seqNo;
    }

    public final String getVirtualPath() {
        return this.m_virtPath;
    }

    public final String getTemporaryFile() {
        return this.m_tempPath;
    }

    public final boolean hasFileState() {
        return this.m_state != null;
    }

    public final FileState getFileState() {
        return this.m_state;
    }

    public final void setFileState(FileState state) {
        this.m_state = state;
    }

    public final void setSequenceNumber(int id) {
        this.m_seqNo = id;
    }

    public final void setVirtualPath(String path) {
        this.m_virtPath = path;
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("[FID=");
        str.append(this.getFileId());
        str.append(",STID=");
        str.append(this.getStreamId());
        str.append(",Seq=");
        str.append(this.getSequenceNumber());
        if (this.isTransaction()) {
            str.append(",Tran=");
            str.append(this.getTransactionId());
            if (this.isLastTransactionFile()) {
                str.append("(Last)");
            }
        }
        if (this.isType() == 0) {
            str.append(",LOAD:");
        } else {
            str.append(",SAVE:");
        }
        str.append(this.getTemporaryFile());
        str.append(",");
        str.append(this.getVirtualPath());
        str.append(",State=");
        str.append(this.getFileState());
        if (this.hasAttributes()) {
            str.append(",Attr=");
            str.append(this.getAttributes());
        }
        str.append("]");
        return str.toString();
    }
}

