/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.server.filesys.pseudo;

import java.io.File;
import org.filesys.server.filesys.FileInfo;
import org.filesys.server.filesys.NetworkFile;
import org.filesys.server.filesys.pseudo.PseudoFile;
import org.filesys.server.filesys.pseudo.PseudoFileInfo;
import org.filesys.server.filesys.pseudo.PseudoNetworkFile;

public class LocalPseudoFile
extends PseudoFile {
    private String m_path;

    public LocalPseudoFile(String name, String path) {
        super(name);
        this.m_path = path;
    }

    public final String getFilePath() {
        return this.m_path;
    }

    @Override
    public FileInfo getFileInfo() {
        File localFile;
        if (this.getInfo() == null && (localFile = new File(this.getFilePath())).exists()) {
            PseudoFileInfo fInfo = new PseudoFileInfo(this.getFileName(), localFile.length(), this.getAttributes());
            fInfo.setModifyDateTime(localFile.lastModified());
            fInfo.setCreationDateTime(_creationDateTime);
            fInfo.setChangeDateTime(_creationDateTime);
            fInfo.setAllocationSize(localFile.length() + 512L & 0xFFFFFFFFFFFFFE00L);
            this.setFileInfo(fInfo);
        }
        return this.getInfo();
    }

    @Override
    public NetworkFile getFile(String netPath) {
        return new PseudoNetworkFile(this.getFileName(), this.getFilePath(), netPath);
    }
}

