/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.server.locking;

import java.io.IOException;
import java.util.ArrayList;
import org.filesys.debug.Debug;
import org.filesys.server.filesys.DeferFailedException;
import org.filesys.server.locking.DeferredRequest;
import org.filesys.server.locking.OpLockDetailsAdapter;
import org.filesys.server.locking.OplockOwner;
import org.filesys.smb.OpLockType;
import org.filesys.smb.server.SMBParser;
import org.filesys.smb.server.SMBSrvPacket;
import org.filesys.smb.server.SMBSrvSession;
import org.filesys.smb.server.SMBThreadRequest;

public class LocalOpLockDetails
extends OpLockDetailsAdapter {
    public static final int MaxDeferredRequests = 3;
    private OpLockType m_type;
    private String m_path;
    private boolean m_folder;
    private ArrayList<DeferredRequest> m_deferredRequests = new ArrayList(3);
    private long m_opBreakTime;
    private boolean m_failedBreak;
    private SMBSrvSession m_ownerSess;
    private OplockOwner m_oplockOwner;

    public LocalOpLockDetails(OpLockType lockTyp, String path, SMBSrvSession sess, SMBSrvPacket pkt, boolean folder) {
        this.m_type = lockTyp;
        this.m_path = path;
        this.m_folder = folder;
        this.m_ownerSess = sess;
        SMBParser parser = pkt.getParser();
        parser.setOplockOwner(sess, this);
    }

    public LocalOpLockDetails(OpLockType lockTyp, String path, SMBSrvSession sess, OplockOwner owner, boolean folder) {
        this.m_type = lockTyp;
        this.m_path = path;
        this.m_folder = folder;
        this.m_ownerSess = sess;
        this.m_oplockOwner = owner;
    }

    @Override
    public OpLockType getLockType() {
        return this.m_type;
    }

    public SMBSrvSession getOwnerSession() {
        return this.m_ownerSess;
    }

    public final boolean hasOplockOwner() {
        return this.m_oplockOwner != null;
    }

    public final OplockOwner getOplockOwner() {
        return this.m_oplockOwner;
    }

    @Override
    public String getPath() {
        return this.m_path;
    }

    @Override
    public boolean isFolder() {
        return this.m_folder;
    }

    @Override
    public long getOplockBreakTime() {
        return this.m_opBreakTime;
    }

    @Override
    public boolean hasOplockBreakFailed() {
        return this.m_failedBreak;
    }

    @Override
    public boolean isRemoteLock() {
        return false;
    }

    @Override
    public void setOplockOwner(OplockOwner owner) {
        this.m_oplockOwner = owner;
    }

    @Override
    public final void setOplockBreakFailed() {
        this.m_failedBreak = true;
        if (this.m_ownerSess != null && this.m_ownerSess.hasDebug(0x4000000)) {
            this.m_ownerSess.debugPrintln("*** Oplock break failed, timed out");
        }
    }

    @Override
    public void setLockType(OpLockType lockTyp) {
        this.m_type = lockTyp;
    }

    @Override
    public boolean hasDeferredSessions() {
        return this.m_deferredRequests.size() > 0;
    }

    @Override
    public int numberOfDeferredSessions() {
        return this.m_deferredRequests.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int requeueDeferredRequests() {
        int requeueCnt = 0;
        ArrayList<DeferredRequest> arrayList = this.m_deferredRequests;
        synchronized (arrayList) {
            for (DeferredRequest deferReq : this.m_deferredRequests) {
                SMBSrvSession sess = deferReq.getDeferredSession();
                SMBSrvPacket pkt = deferReq.getDeferredPacket();
                if (sess.hasDebug(0x4000000)) {
                    Debug.println("Release oplock, queued deferred request to thread pool sess=" + sess.getUniqueId() + ", pkt=" + pkt);
                }
                try {
                    sess.getThreadPool().queueRequest(new SMBThreadRequest(sess, pkt));
                }
                catch (Throwable ex) {
                    sess.getPacketPool().releasePacket(pkt);
                }
            }
            this.m_deferredRequests.clear();
        }
        return requeueCnt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int failDeferredRequests() {
        int failCnt = 0;
        ArrayList<DeferredRequest> arrayList = this.m_deferredRequests;
        synchronized (arrayList) {
            for (DeferredRequest deferReq : this.m_deferredRequests) {
                SMBSrvSession sess = deferReq.getDeferredSession();
                SMBSrvPacket pkt = deferReq.getDeferredPacket();
                try {
                    if (sess.sendAsyncErrorResponseSMB(pkt, -1073741790, 6)) {
                        ++failCnt;
                        if (!sess.hasDebug(0x4000000)) continue;
                        Debug.println("Oplock break timeout, oplock=" + this);
                        continue;
                    }
                    if (!sess.hasDebug(0x4000000)) continue;
                    Debug.println("Failed to send open reject, oplock break timed out, oplock=" + this);
                }
                catch (IOException iOException) {}
                continue;
                finally {
                    if (pkt == null) continue;
                    sess.getPacketPool().releasePacket(pkt);
                }
            }
            this.m_deferredRequests.clear();
        }
        return failCnt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDeferredSession(SMBSrvSession deferredSess, SMBSrvPacket deferredPkt) throws DeferFailedException {
        ArrayList<DeferredRequest> arrayList = this.m_deferredRequests;
        synchronized (arrayList) {
            if (this.m_deferredRequests.size() < 3) {
                this.m_deferredRequests.add(new DeferredRequest(deferredSess, deferredPkt));
                deferredPkt.incrementDeferredCount();
                if (this.m_deferredRequests.size() == 1) {
                    this.m_opBreakTime = System.currentTimeMillis();
                }
                if (deferredSess.hasDebug(0x4000000)) {
                    Debug.println("Added deferred request, list=" + this.m_deferredRequests.size() + ", oplock=" + this);
                }
            } else {
                throw new DeferFailedException("No more deferred slots available on oplock");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateDeferredPacketLease() {
        ArrayList<DeferredRequest> arrayList = this.m_deferredRequests;
        synchronized (arrayList) {
            long newLeaseTime = System.currentTimeMillis() + 5000L;
            for (DeferredRequest deferReq : this.m_deferredRequests) {
                deferReq.getDeferredPacket().setLeaseTime(newLeaseTime);
            }
        }
    }

    @Override
    public void requestOpLockBreak() throws IOException {
        if (this.getOwnerSession() == null || this.hasOplockBreakFailed()) {
            return;
        }
        SMBSrvPacket opBreakPkt = this.getOwnerSession().getProtocolHandler().buildOpLockBreakResponse(this);
        if (opBreakPkt == null) {
            if (this.getOwnerSession().hasDebug(0x4000000)) {
                this.getOwnerSession().debugPrintln("buildOpLockBreakResponse() returned null");
            }
            return;
        }
        boolean breakSent = this.getOwnerSession().sendAsynchResponseSMB(opBreakPkt, opBreakPkt.getLength());
        this.m_opBreakTime = System.currentTimeMillis();
        if (this.getOwnerSession().hasDebug(0x4000000)) {
            this.getOwnerSession().debugPrintln("Oplock break sent to " + this.getOwnerSession().getUniqueId() + " async=" + (breakSent ? "Sent" : "Queued"));
        }
    }

    @Override
    public boolean hasBreakInProgress() {
        return this.m_opBreakTime != 0L && !this.hasOplockBreakFailed();
    }

    public void finalize() {
        if (this.m_deferredRequests != null && this.m_deferredRequests.size() > 0) {
            Debug.println("** Deferred requests found during oplock finalize, oplock=" + this);
            for (DeferredRequest deferReq : this.m_deferredRequests) {
                Debug.println("**  Leaked deferred request=" + deferReq);
            }
        }
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("[Local Type=");
        str.append(this.getLockType().name());
        str.append(",");
        str.append(this.getPath());
        str.append(",Sess=");
        if (this.getOwnerSession() != null) {
            str.append(this.getOwnerSession().getUniqueId());
        } else {
            str.append("NULL");
        }
        str.append(", Owner=");
        if (this.hasOplockOwner()) {
            str.append(this.getOplockOwner().toString());
        } else {
            str.append("NULL");
        }
        if (this.hasDeferredSessions()) {
            str.append(",DeferList=");
            str.append(this.numberOfDeferredSessions());
        }
        if (this.hasOplockBreakFailed()) {
            str.append(" BreakFailed");
        } else if (this.hasBreakInProgress()) {
            str.append(" BreakInProgress");
        }
        str.append("]");
        return str.toString();
    }
}

