/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.smb;

public final class Dialect {
    private static final String[] protList = new String[]{"PC NETWORK PROGRAM 1.0", "MICROSOFT NETWORKS 1.03", "MICROSOFT NETWORKS 3.0", "DOS LANMAN1.0", "LANMAN1.0", "DOS LM1.2X002", "LM1.2X002", "DOS LANMAN2.1", "LANMAN2.1", "Samba", "NT LM 0.12", "NT LANMAN 1.0", "SMB 2.002", "SMB 2.210", "SMB 2.???", "SMB 3.000", "SMB 3.002", "SMB 3.110"};
    private static final String[] protType = new String[]{"Core", "CorePlus", "DOS LANMAN 1.0", "LANMAN1.0", "DOS LANMAN 2.1", "LM1.2X002", "LANMAN2.1", "NT LM 0.12", "SMB 2.002", "SMB 2.210", "SMB 2.ANY", "SMB 3.000", "SMB 3.002", "SMB 3.110"};
    public static final int Core = 0;
    public static final int CorePlus = 1;
    public static final int DOSLanMan1 = 2;
    public static final int LanMan1 = 3;
    public static final int DOSLanMan2 = 4;
    public static final int LanMan2 = 5;
    public static final int LanMan2_1 = 6;
    public static final int NT = 7;
    public static final int SMB2_202 = 8;
    public static final int SMB2_210 = 9;
    public static final int SMB2_Any = 10;
    public static final int SMB3_300 = 11;
    public static final int SMB3_302 = 12;
    public static final int SMB3_311 = 13;
    public static final int Max = 13;
    public static final int UpToSMBv1 = 8;
    public static final int UpToSMBv2 = 11;
    public static final int UpToSMBv3 = 14;
    public static final int Unknown = -1;
    private static final int[] protIdx = new int[]{0, 1, 2, 2, 3, 4, 5, 6, 6, 7, 7, 7, 8, 9, 10, 11, 12, 13};
    public static final int SMB_PROT_MAXSTRING = protIdx.length;
    private static final int[] cmdtable = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 3, 0, 0, 0, 0, 0, 3, 3, 3, 3, 0, 3, 0, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0, 3, 5, 5, 5, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 7, 7, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, -1};

    public static String DialectString(int i) {
        if (i >= protList.length) {
            return null;
        }
        return protList[i];
    }

    public static final boolean DialectSupportsCommand(int dialect, int cmd) {
        if (cmd > cmdtable.length) {
            return false;
        }
        return cmdtable[cmd] <= dialect;
    }

    public static int DialectType(int i) {
        return protIdx[i];
    }

    public static int DialectType(String diastr) {
        int i;
        for (i = 0; i < protList.length && protList[i].compareTo(diastr) != 0; ++i) {
        }
        if (i < protList.length) {
            return Dialect.DialectType(i);
        }
        return -1;
    }

    public static String DialectTypeString(int dia) {
        return protType[dia];
    }

    public static int NumberOfDialects() {
        return protList.length;
    }

    public static int SMB2DialectToId(int v2Id) {
        int protoId = -1;
        switch (v2Id) {
            case 514: {
                protoId = 8;
                break;
            }
            case 528: {
                protoId = 9;
                break;
            }
            case 768: {
                protoId = 11;
                break;
            }
            case 770: {
                protoId = 12;
                break;
            }
            case 785: {
                protoId = 13;
            }
        }
        return protoId;
    }

    public static int SMB2IdToDialect(int diaId) {
        int v2Id = -1;
        switch (diaId) {
            case 8: {
                v2Id = 514;
                break;
            }
            case 9: {
                v2Id = 528;
                break;
            }
            case 10: {
                v2Id = 767;
                break;
            }
            case 11: {
                v2Id = 768;
                break;
            }
            case 12: {
                v2Id = 770;
                break;
            }
            case 13: {
                v2Id = 785;
            }
        }
        return v2Id;
    }

    public static final boolean isSMB1(int dialectId) {
        return dialectId >= 0 && dialectId <= 7;
    }

    public static final boolean isSMB2(int dialectId) {
        return dialectId >= 8;
    }

    public static final boolean isSMB3(int dialectId) {
        return dialectId >= 11;
    }

    public static final int getMajorSMBVersion(int dialectId) {
        if (dialectId < 8) {
            return 1;
        }
        if (dialectId <= 10) {
            return 2;
        }
        return 3;
    }
}

